<?php
namespace app\modules\user\controllers;

use Yii;
use yii\web\Controller;
use app\models\Config;
use app\components\AccessControl;
use app\extensions\upload\PluploadHandler;
use app\extensions\upload\Yikong_imagetransfer;

class UploadController extends Controller {

    private $userobj; //用户登录信息

    public function init() {
        $this->userobj = AccessControl::isLogin();
    }

    public function beforeAction($action) {
        return true;
    }

    //头像上传
    public function actionLogo() {
    	$savepath = '/userfiles/face/'. date("Ym") .'/'. date("d") .'/';
		$ph = new PluploadHandler(array(
			'target_dir' => WEBROOT . $savepath,
			'max_execution_time' => 3600,
			'allow_extensions' => 'jpg,jpeg,png,gif,bmp'
		));

		$ph->sendNoCacheHeaders();
		$ph->sendCORSHeaders();

		if (@$result = $ph->handleUpload()) {
			$fname = basename($result["path"]);
			$goodpath = $savepath . $fname;
			$result["path"] = $goodpath;
			$filepath_s = str_ireplace(".", "_s.", $goodpath);
			$imagefile_s = WEBROOT . $filepath_s;
			$imagetrans = new Yikong_imagetransfer();
			$imagetrans->originimage = WEBROOT . $goodpath;
			$imagetrans->thumb_maxwidth = 50;
			$imagetrans->thumb_maxheight = 50;
			$imagetrans->thumbimage = $imagefile_s;
			$imagetrans->gen_thumbimage();
			if(file_exists($imagefile_s)){
				$result["path_s"] = $filepath_s;
			}
			die(json_encode(array(
				'OK' => 1,
				'info' => $result
			)));
		} else {
			die(json_encode(array(
				'OK' => 0,
				'error' => array(
					'code' => $ph->getErrorCode(),
					'message' => $ph->getErrorMessage()
				)
			)));
		}
    }
		
}

?>