<?php
use app\models\Config;
use app\components\AccessControl;
$config = Config::find()->where("id=1")->one();
$userobj = AccessControl::isLogin();
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<title><?php echo $this->params["meta_title"]; ?><?php echo $config->name; ?></title>
  <meta name="renderer" content="webkit">
  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
  <meta name="apple-mobile-web-app-status-bar-style" content="black"> 
  <meta name="apple-mobile-web-app-capable" content="yes">
  <meta name="format-detection" content="telephone=no">
  <link rel="stylesheet" href="/plugins/layui/css/layui.css">
  <link rel="stylesheet" href="/plugins/fontawesome/css/font-awesome.min.css" />
  <link rel="stylesheet" href="/public/css/global.css">
  <script src="/public/js/jquery-1.11.3.min.js"></script>
  <script src="/public/js/jquery.form-3.36.0.min.js"></script>
</head>
<body class="layui-layout-body">
<div class="layui-layout layui-layout-admin">
  <div class="layui-header">
    <div class="layui-logo"><?php if(!empty($config->logo)){echo '<img class="layui-logo-img" src="'. $config->logo .'">';}else{echo $config->name;} ?></div>
    <!-- 头部区域（可配合layui已有的水平导航） -->
    <ul class="layui-nav layui-layout-left">
    </ul>
    <ul class="layui-nav layui-layout-right">
      <li class="layui-nav-item"><a href="/">首页</a></li>
      <li class="layui-nav-item">
        <a href="javascript:;">使用手册</a>
        <dl class="layui-nav-child">
          <dd><a href="/public/manual/admin.pdf" target="_blank">管理员</a></dd>
          <dd><a href="/public/manual/teacher.pdf" target="_blank">教师</a></dd>
          <dd><a href="/public/manual/student.pdf" target="_blank">学生</a></dd>
          <dd><a href="/public/manual/mobile_tea.pdf" target="_blank">手机端_教师</a></dd>
          <dd><a href="/public/manual/mobile_stu.pdf" target="_blank">手机端_学生</a></dd>
        </dl>
      </li>
      <li class="layui-nav-item"><a href="/yidong/default/index">手机端</a></li>
      <li class="layui-nav-item">
        <a href="javascript:;">
          <img src="<?php echo $userobj->logo; ?>" class="layui-nav-img">
          <?php echo $userobj->realname; ?>
        </a>
        <dl class="layui-nav-child">
          <dd><a href="/user/default/index">进入后台</a></dd>
          <dd><a href="/user/profile/index">个人资料</a></dd>
          <dd><a href="/user/chanpass/index">修改密码</a></dd>
          <dd><a href="<?php echo Yii::$app->params["logout_url"]; ?>">注销</a></dd>
        </dl>
      </li>
    </ul>
  </div>
  
  <div class="layui-side">
    <div class="layui-side-scroll">
      <!-- 左侧导航区域（可配合layui已有的垂直导航） -->
      <ul class="layui-nav layui-nav-tree" lay-filter="test">
      
        <?php if($userobj->roleid==1){ ?>
        <li class="layui-nav-item<?php if($this->params["navicode"]=="glspecial"){echo ' layui-nav-itemed';} ?>">
          <a href="javascript:;">院系专业</a>
          <dl class="layui-nav-child">
            <dd<?php if($this->params["navicode_two"]=="glspecial_manage"){echo ' class="layui-this"';} ?>><a href="/glspecial/default/index">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;管理</a></dd>
          </dl>
        </li>
        <li class="layui-nav-item<?php if($this->params["navicode"]=="glxzclass"){echo ' layui-nav-itemed';} ?>">
          <a href="javascript:;">班级</a>
          <dl class="layui-nav-child">
            <dd<?php if($this->params["navicode_two"]=="glxzclass_manage"){echo ' class="layui-this"';} ?>><a href="/glxzclass/default/index">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;管理</a></dd>
            <dd<?php if($this->params["navicode_two"]=="glxzclass_archive"){echo ' class="layui-this"';} ?>><a href="/glxzclass/archive/index">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;已存档的</a></dd>
          </dl>
        </li>
        <?php }elseif($userobj->roleid==3){ ?>
        <li class="layui-nav-item<?php if($this->params["navicode"]=="lespecial"){echo ' layui-nav-itemed';} ?>">
          <a href="javascript:;">院系专业</a>
          <dl class="layui-nav-child">
            <dd<?php if($this->params["navicode_two"]=="lespecial_manage"){echo ' class="layui-this"';} ?>><a href="/lespecial/default/index">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;查看</a></dd>
          </dl>
        </li>
        <?php } ?>

        <?php if($userobj->roleid==1){ ?>
        <li class="layui-nav-item<?php if($this->params["navicode"]=="gluser"){echo ' layui-nav-itemed';} ?>">
          <a href="javascript:;">用户</a>
          <dl class="layui-nav-child">
            <dd<?php if($this->params["navicode_two"]=="gluser_manage"){echo ' class="layui-this"';} ?>><a href="/gluser/default/index">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;管理</a></dd>
          </dl>
        </li>
        <?php } ?>

        <?php if($userobj->roleid==1 || $userobj->roleid==3){ ?>
        <li class="layui-nav-item<?php if($this->params["navicode"]=="glqcourse"){echo ' layui-nav-itemed';} ?>">
          <a href="javascript:;">课程</a>
          <dl class="layui-nav-child">
            <dd<?php if($this->params["navicode_two"]=="glqcourse_manage"){echo ' class="layui-this"';} ?>><a href="/glqcourse/default/index">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;我负责的专业</a></dd>
            <dd<?php if($this->params["navicode_two"]=="glqcourse_myqbank"){echo ' class="layui-this"';} ?>><a href="/glqcourse/myqbank/index">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;我负责的课程</a></dd>
          </dl>
        </li>
        <?php } ?>

        <?php if($userobj->roleid==1 || $userobj->roleid==3){ ?>
        <li class="layui-nav-item<?php if($this->params["navicode"]=="glquesti"){echo ' layui-nav-itemed';} ?>">
          <a href="javascript:;">题库</a>
          <dl class="layui-nav-child">
            <dd<?php if($this->params["navicode_two"]=="glquesti_manage"){echo ' class="layui-this"';} ?>><a href="/glquesti/default/index">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;我负责的专业</a></dd>
            <dd<?php if($this->params["navicode_two"]=="glquesti_myqbank"){echo ' class="layui-this"';} ?>><a href="/glquesti/myqbank/index">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;我负责的课程</a></dd>
          </dl>
        </li>
        <?php } ?>

        <?php if($userobj->roleid==1 || $userobj->roleid==3){ ?>
        <li class="layui-nav-item<?php if($this->params["navicode"]=="glexam" || $this->params["navicode"]=="doexam"){echo ' layui-nav-itemed';} ?>">
          <a href="javascript:;">考试</a>
          <dl class="layui-nav-child">
            <dd<?php if($this->params["navicode_two"]=="glexam_manage"){echo ' class="layui-this"';} ?>><a href="/glexam/default/index">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;我发布的</a></dd>
            <dd<?php if($this->params["navicode_two"]=="doexam_manage"){echo ' class="layui-this"';} ?>><a href="/doexam/default/index">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;我参加的</a></dd>
          </dl>
        </li>
        <?php } ?>

        <?php if($userobj->roleid==4 || $userobj->roleid==5 || $userobj->roleid==6){ ?>
        <li class="layui-nav-item<?php if($this->params["navicode"]=="lequesti"){echo ' layui-nav-itemed';} ?>">
          <a href="javascript:;">题库</a>
          <dl class="layui-nav-child">
            <dd<?php if($this->params["navicode_two"]=="lequesti_myqbank"){echo ' class="layui-this"';} ?>><a href="/lequesti/myqbank/index">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;学习</a></dd>
          </dl>
        </li>
        <?php } ?>

        <?php if($userobj->roleid==4 || $userobj->roleid==5 || $userobj->roleid==6){ ?>
        <li class="layui-nav-item<?php if($this->params["navicode"]=="doexam"){echo ' layui-nav-itemed';} ?>">
          <a href="javascript:;">考试</a>
          <dl class="layui-nav-child">
            <dd<?php if($this->params["navicode_two"]=="doexam_manage"){echo ' class="layui-this"';} ?>><a href="/doexam/default/index">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;我参加的</a></dd>
          </dl>
        </li>
        <?php } ?>

        <?php if($userobj->roleid==1){ ?>
        <li class="layui-nav-item<?php if($this->params["navicode"]=="glconfig"){echo ' layui-nav-itemed';} ?>">
          <a href="javascript:;">系统设置</a>
          <dl class="layui-nav-child">
            <dd<?php if($this->params["navicode_two"]=="glconfig_basic"){echo ' class="layui-this"';} ?>><a href="/glconfig/default/index">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;基本参数</a></dd>
            <dd<?php if($this->params["navicode_two"]=="glconfig_qutype"){echo ' class="layui-this"';} ?>><a href="/glconfig/qutype/index">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;题目类型</a></dd>
            <dd<?php if($this->params["navicode_two"]=="glconfig_logo"){echo ' class="layui-this"';} ?>><a href="/glconfig/logo/index">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;网站LOGO</a></dd>
            <dd<?php if($this->params["navicode_two"]=="glconfig_favicon"){echo ' class="layui-this"';} ?>><a href="/glconfig/favicon/index">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;收藏栏图标</a></dd>
            <dd<?php if($this->params["navicode_two"]=="glconfig_version"){echo ' class="layui-this"';} ?>><a href="/glconfig/version/index">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;版本信息</a></dd>
          </dl>
        </li>
        <?php } ?>
      
      </ul>
    </div>
  </div>
  
  <div class="layui-body">
    <!-- 内容主体区域 -->
    <div style="padding: 15px;"><?php echo $content; ?></div>
  </div>

  <div class="layui-footer" style="text-align: center;">
    <!-- 底部固定区域 -->
    Copyright © <?php echo date("Y"); ?> <?php echo $config->copyright; ?> All Rights Reserved
  </div>

</div>
<script src="/plugins/layui/layui.all.js"></script>

<script>
var serialkeyok = "<?php if(empty($userobj)){echo 'success';}else{echo $userobj->serialkeyok;} ?>";
function check_serialkey(serialkeyok){
  if(serialkeyok=="success"){
    clearInterval(check_key_timer);
  }else{
    if(serialkeyok=="trialstop"){
      layer.alert("试用已结束，请购买正式版，感谢支持。", {icon: 2}, function(){window.location.href = "/logout/index";});
      setTimeout(function(){window.location.href = "/logout/index";},5000);
    }else{
      layer.alert("您使用的是未授权版本", {icon: 2});
    }
  }
}
var check_key_timer = setInterval(function(){check_serialkey(serialkeyok);}, 30000);
</script>
</body>
</html>
