<?php
namespace app\modules\yidong\controllers;

use Yii;
use yii\web\Controller;
use app\components\AccessControl;

class DefaultController extends Controller
{
	
	private $userobj; //用户登录信息
	private $request; //Yii::$app->request对象
	
    public function init(){
		$this->request = Yii::$app->request;
		$this->userobj = AccessControl::isLogin();
	}
	
	public function beforeAction($action) {
		if(empty($this->userobj)){
			$this->userobj = new \stdclass();
			$this->userobj->realname = "游客";
			$this->userobj->logo = Yii::$app->params["user_logo"];
			$this->userobj->serialkeyok = "failed";
		}
		return true;
	}
	
	//移动端
	public function actionIndex(){
		return $this->render("index", ["userobj"=>$this->userobj]);
	}
	
}
?>