<?php
use app\models\Config;
use app\components\AccessControl;
$config = Config::find()->where("id=1")->one();
$userobj = AccessControl::isLogin();
if(empty($userobj)){
    $userobj = new \stdclass();
    $userobj->realname = "游客";
    $userobj->logo = Yii::$app->params["user_logo"];
    $userobj->serialkeyok = "failed";
}
?>
<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title><?php echo $this->params["meta_title"]; ?><?php echo $config->name; ?></title>
    <meta name="viewport" content="initial-scale=1, maximum-scale=1">
    <link rel="shortcut icon" href="/favicon.ico">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <link rel="stylesheet" href="/plugins/msui/css/sm.min.css">
    <link rel="stylesheet" href="/plugins/msui/css/sm-extend.min.css">
    <script type="text/javascript" src="/public/js/zepto.min.js"></script>
    <link rel="stylesheet" href="/public/css/global_yidong.css">
  </head>
  <body>
    <div class="page-group">
        <?php echo $content; ?>

        <div class="panel-overlay"></div>
        <div class="panel panel-left panel-reveal">
            <div class="content-block">
                <p><?php echo $userobj->realname; ?>
                <br><a href="#" class="external">个人资料</a>
                <br><a href="#" class="external">修改密码</a>
                </p>
                <p>课程
                <br><a href="#" class="external">我负责的</a>
                </p>
                <p>题库
                <br><a href="#" class="external">学习</a>
                </p>
                <p>考试
                <br><a href="#" class="external">我发布的</a>
                <br><a href="#" class="external">我参加的</a>
                </p>
                <p>侧栏
                <br><a class="close-panel">关闭</a>
                </p>
                <p>系统
                <br><a href="#" class="external">退出</a>
                </p>
            </div>
        </div>
    </div>

    <script type="text/javascript" src="/plugins/msui/js/sm.min.js"></script>
    <script type="text/javascript" src="/plugins/msui/js/sm-extend.min.js"></script>
    
  </body>
</html>