$(document).ready(function(){ 
  form = layui.form;
  //专业筛选条件
  form.on('select(changespecialty)', function(data){
    var specialid = data.elem.value;
    showXzclassList(specialid);
  });
  //切换角色条件
  form.on('radio(changerole)', function(data){
    var roleid = data.elem.value;
    onChangeRoleName(roleid);
  });
});

//根据专业切换班级
function showXzclassList(specialid, xzclassid){
  $.ajax({
    url: '/register/xzclasslist', 
    type: 'POST',
    dataType: "html", 
    data: {specialid:specialid, xzclassid:xzclassid},
    success: function(data){
      $("select[name='xzclassid']").html(data);
      form.render('select');
    },
    error: function(){
      layer.msg("系统错误，请联系管理员", {icon:2});
    }
  });
  return false;
}

//切换角色
function onChangeRoleName(roleid){
  //console.log(roleid);
  if(roleid==3 || roleid==4){
    $("#specialtybox").show();
    $("#xzclassbox").show();
  }else{
    $("#specialtybox").hide();
    $("#xzclassbox").hide();
  }
}

//提交表单
$("#finished_button").on("click", function(){
  var username = $("#detail_form").find("input[name='username']");
  var password = $("#detail_form").find("input[name='password']");
  var realname = $("#detail_form").find("input[name='realname']");
  var stdnumber = $("#detail_form").find("input[name='stdnumber']");
  var email = $("#detail_form").find("input[name='email']");
  var male = $("#detail_form").find("input[name='male']");
  if($(username).val()==""){
    layer.tips('请填写用户名', $(username), {tips: [1, '#FF5722']});
    return false;
  }
  var regex = /^\s*[A-Za-z0-9_-]{4,20}\s*$/;
  if(!regex.test($(username).val())){
    $(username).parent().next().css("color","#FF5722").html("用户名格式错误");
    layer.tips('用户名格式错误', $(username), {tips: [1, '#FF5722']});
    return false;
  }
  if($(password).val()==""){
    layer.tips('请填写密码', $(password), {tips: [1, '#FF5722']});
    return false;
  }
  if($(realname).val()==""){
    layer.tips('请填写姓名', $(realname), {tips: [1, '#FF5722']});
    return false;
  }
  var regex = /^\s*[\u4e00-\u9fa5\(\)a-zA-Z0-9_]{2,20}\s*$/;
  if(!regex.test($(realname).val())){
    $(realname).parent().next().css("color","#FF5722").html("姓名格式错误");
    layer.tips('姓名格式错误', $(realname), {tips: [1, '#FF5722']});
    return false;
  }
  if($(stdnumber).val()==""){
    layer.tips('请填写学号', $(stdnumber), {tips: [1, '#FF5722']});
    return false;
  }
  var regex = /^\s*[A-Za-z0-9_-]{4,20}\s*$/;
  if(!regex.test($(stdnumber).val())){
    $(stdnumber).parent().next().css("color","#FF5722").html("学号格式错误");
    layer.tips('学号格式错误', $(stdnumber), {tips: [1, '#FF5722']});
    return false;
  }
  if($(email).val()!=""){
    var regex = /^\w+((-\w+)|(\.\w+))*\@[A-Za-z0-9]+((\.|-)[-A-Za-z0-9]+)*\.[A-Za-z0-9]+$/;
    if(!regex.test($(email).val())){
      $(email).parent().next().css("color","#FF5722").html("邮箱格式错误");
      layer.tips('邮箱格式错误', $(email), {tips: [1, '#FF5722']});
      return false;
    }
  }
  $("#detail_form").ajaxSubmit({
    url: '/register/basicok', 
    type: 'POST',
    dataType: "json", 
    success: function(data){
      if(data.code=="success"){
        layer.msg("成功", {icon:1}, function(){window.location.href = "/register/waiting";});
      }else{
        layer.msg(data.msg, {icon:2});
      }
    },
    error: function(){
      layer.msg("系统错误，请联系管理员", {icon:2});
    }
  });
  return false;
});