//上传插件
var uploader = new plupload.Uploader({
  runtimes : 'html5,flash,silverlight,html4',
  browse_button : 'pickfiles', // you can pass an id...
  container: document.getElementById('uploadcontainer'), // ... or DOM Element itself
  url : '/glconfig/upload/favicon',
  flash_swf_url : '/plugins/plupload/js/Moxie.swf',
  silverlight_xap_url : '/plugins/plupload/js/Moxie.xap',
  multi_selection: false,
  
  filters : {
    max_file_size : '1000mb',
    mime_types: [
      {title : "Image files", extensions : "ico"}
    ]
  },

  init: {
    PostInit: function() {
      document.getElementById('filelist').innerHTML = '';
      document.getElementById('uploadfiles').onclick = function() {
        uploader.start();
        return false;
      };
    },

    FilesAdded: function(up, files) {
      plupload.each(files, function(file) {
        document.getElementById('filelist').innerHTML += '<div id="' + file.id + '">' + file.name + ' (' + plupload.formatSize(file.size) + ') <b></b><div class="progress"><div class="progress-bar" style="width: 0%"></div></div></div>';
      });
      uploader.start(); //自动开始上传
      return false;
    },

    UploadProgress: function(up, file) {
      var d = document.getElementById(file.id);
      d.getElementsByTagName('b')[0].innerHTML = '<span>' + file.percent + "%</span>";
            var prog = d.getElementsByTagName('div')[0];
      var progBar = prog.getElementsByTagName('div')[0]
      progBar.style.width= 2*file.percent+'px';
      progBar.setAttribute('aria-valuenow', file.percent);
    },

    FileUploaded: function(up, file, info) {
      //console.log(info.response);
      if (info.status == 200){
        var json = $.parseJSON(info.response);
        if(json.error){
          document.getElementById("filelist").innerHTML = '上传失败';
          return false;
        }
        document.getElementById("console").innerHTML += json.info.name +',#,'+ json.info.path +',#,'+ json.info.size +',#,'+ json.info.extension +',#,'+ json.info.oldname +'<br>';
        $("#logopreview").html('<img src="'+ json.info.path +'" style="max-width: 32px; max-height: 32px;">');
        layer.msg('成功', {icon: 1});
      }else{
        document.getElementById("console").innerHTML += file.name +'上传失败<br>';
        layer.msg("上传失败", {icon: 2});
      }
    },

    UploadComplete: function(up, files) {
      console.log('complete');
    },

    Error: function(up, err) {
      document.getElementById('console').appendChild(document.createTextNode("\nError #" + err.code + ": " + err.message));
    }
  }
});

uploader.init();