$(document).ready(function(){  
  //全选
  var form = layui.form;
  form.on('checkbox(allChoose)', function(data){
    var child = $(data.elem).parents('table').find('tbody input[name="examid[]"]');
    child.each(function(index, item){
      item.checked = data.elem.checked;
    });
    form.render('checkbox');
  });
  //筛选
  form.on('select(changecondition)', function(data){
    $("#search_form").submit();
  });

  //发布考试
  form.on('switch(changeOpenType)', function(data){
    var target = data.elem;
    var examid = $(target).val();
    var ispublish = 0;
    if(target.checked==true){
      ispublish = 1;
    }
    $.ajax({
      url: '/glexam/default/changeopen', 
      type: 'POST',
      dataType: "json", 
      data: {"examid":examid,"ispublish":ispublish},
      success: function(data){
        if(data.code=="success"){
          //layer.msg("成功", {icon:1});
          $(target).parent().html("已发布");
        }else{
          layer.msg(data.msg, {icon:2});
          target.checked = false;
          form.render('checkbox');
        }
      },
      error: function(){
        layer.msg("系统错误，请联系管理员", {icon:2});
      }
    });
    return false;
  });

  //分页
  var laypage = layui.laypage;
  laypage.render({
    elem: 'pagelinkbox',
    count: allsize,
    limit: pagesize,
    layout: ['count', 'prev', 'page', 'next', 'skip'],
    jump: function(obj){
      $("#gotopage_form").find("input[name='curpage']").val(obj.curr);
      $("#gotopage_form").find("input[name='rnum']").val(Math.random());
      $("#gotopage_form").ajaxSubmit({
        url: '/glexam/default/index', 
        type: 'POST',
        dataType: 'html',
        beforeSend: function(){
          $("#waitingtipsbox").show();
        },
        success: function(data){
          if(data==""){
            //layer.msg("已经到最后一页了", {icon: 2});
          }else{
            $("#pagelistbox").html(data);
            form.render('checkbox'); //重新渲染复选框
          }
          $("#waitingtipsbox").hide();
        },
        error: function(){
          layer.msg("系统错误，请联系管理员", {icon: 2});
        }
      });
      return false;
    }
  });

  //删除
  $("#delete_button").on("click", function(){
    var checkednum = $("#list_form").find("input[name='examid[]']:checked").length;
    if(checkednum==0){
      layer.msg("您还没有选择", {icon: 2});
      return false;
    }
    var layerbox = layer.confirm('此操作不可恢复，<br>这将同时删除学生的考试记录，<br>确认要删除吗？', {
      area: ['400px', '230px'],
      icon: 0,
      btn: ['确定','取消'] //按钮
    }, function(){
      $("#list_form").ajaxSubmit({
        url: '/glexam/default/delete', 
        type: 'POST',
        dataType: "json", 
        beforeSend: function(){
          layer.load(0, {shade: [0.2, '#393D49']});
        },
        success: function(data){
          if(data.code=="success"){
            layer.msg("成功", {icon:1}, function(){window.location.reload();});
          }else{
            layer.msg(data.msg, {icon:2});
          }
        },
        error: function(){
          layer.msg("系统错误，请联系管理员", {icon:2});
        },
        complete: function(){
          layer.closeAll('loading');
        }
      });
    }, function(){
      //do nothing
    });
    return false;
  });

  //释放题目
  form.on('switch(changeFreeType)', function(data){
    var target = data.elem;
    var examid = $(target).val();
    var isfreed = 0;
    if(target.checked==true){
      isfreed = 1;
    }
    $.ajax({
      url: '/glexam/default/changefree', 
      type: 'POST',
      dataType: "json", 
      data: {"examid":examid,"isfreed":isfreed},
      success: function(data){
        if(data.code=="success"){
          //layer.msg("成功", {icon:1});
          $(target).parent().html("已释放");
        }else{
          layer.msg(data.msg, {icon:2});
          target.checked = false;
          form.render('checkbox');
        }
      },
      error: function(){
        layer.msg("系统错误，请联系管理员", {icon:2});
      }
    });
    return false;
  });

});

//弹出层索引
var index11, index12, index13;

//预览考试
function showExamPreviewBox(examid){
  layer.load(0, {shade: [0.2, '#393D49']});
  index11 = layer.open({
    id: 'onedialog',
    type: 2,
    title: '预览',
    area: ['900px', '570px'],
    fixed: false, //不固定
    content: '/glexam/preview/'+ examid
  });
  layer.closeAll('loading');
}

//统计数据
function showExamTongjiBox(examid){
  layer.load(0, {shade: [0.2, '#393D49']});
  index12 = layer.open({
    id: 'twodialog',
    type: 2,
    title: '统计',
    area: ['900px', '570px'],
    fixed: false, //不固定
    content: '/glexam/tongji/'+ examid
  });
  layer.closeAll('loading');
}

//导出试卷(学生抽题)
function exportPaperPerson(examid){
  layer.load(0, {shade: [0.2, '#393D49']});
  index13 = layer.open({
    id: 'threedialog',
    type: 2,
    title: '导出试卷',
    area: ['900px', '570px'],
    fixed: false, //不固定
    content: '/glexam/exportperson/'+ examid
  });
  layer.closeAll('loading');
}