$(document).ready(function(){  
  var form = layui.form;
  //筛选
  form.on('select(changecondition)', function(data){
    $("#search_form").submit();
  });

  //分页
  var laypage = layui.laypage;
  laypage.render({
    elem: 'pagelinkbox',
    count: allsize,
    limit: pagesize,
    layout: ['count', 'prev', 'page', 'next', 'skip'],
    jump: function(obj){
      $("#gotopage_form").find("input[name='curpage']").val(obj.curr);
      $("#gotopage_form").find("input[name='rnum']").val(Math.random());
      $("#gotopage_form").ajaxSubmit({
        url: '/glexam/pigai/'+ examid, 
        type: 'POST',
        dataType: 'html',
        beforeSend: function(){
          $("#waitingtipsbox").show();
        },
        success: function(data){
          if(data==""){
            //layer.msg("已经到最后一页了", {icon: 2});
          }else{
            $("#pagelistbox").html(data);
            form.render('checkbox'); //重新渲染复选框
          }
          $("#waitingtipsbox").hide();
        },
        error: function(){
          layer.msg("系统错误，请联系管理员", {icon: 2});
        }
      });
      return false;
    }
  });

});

//弹出层索引
var index11, index12, index13, index14;

//弹出批改窗口
function showDoexamPigai(doexid, questway){
  layer.load(0, {shade: [0.2, '#393D49']});
  var surffix = "";
  if(questway==2){
    surffix = "chou";
  }
  index11 = layer.open({
    id: 'onedialog',
    type: 2,
    title: '批改',
    area: ['900px', '570px'],
    fixed: false, //不固定
    content: '/glexam/pigaione'+ surffix +'/index?id='+ doexid
  });
  layer.closeAll('loading');
}

//关闭批改窗口
function closeDoexamPigai(){
  layer.close(index11);
}

//弹出查看结果
function showDoexamResult(doexid, questway){
  layer.load(0, {shade: [0.2, '#393D49']});
  var surffix = "";
  if(questway==2){
    surffix = "chou";
  }
  index12 = layer.open({
    id: 'twodialog',
    type: 2,
    title: '查看',
    area: ['900px', '570px'],
    fixed: false, //不固定
    content: '/glexam/result'+ surffix +'/index?id='+ doexid
  });
  layer.closeAll('loading');
}

//关闭查看结果
function closeDoexamResult(){
  layer.close(index12);
}

//一键批改
function oneKeyPigaiok(examid){
  $.ajax({
    url: '/glexam/onekey/pigaiok?id='+ examid, 
    type: 'POST',
    dataType: 'json',
    data: {examid:examid},
    beforeSend: function(){
      layer.load(0, {shade: [0.2, '#393D49']});
    },
    success: function(data){
      if(data.code=="success"){
        layer.msg("成功", {icon:1}, function(){window.location.reload();});
      }else{
        layer.msg(data.msg, {icon:2});
      }
    },
    error: function(){
      layer.msg("系统错误，请联系管理员", {icon:2});
    },
    complete: function(){
      layer.closeAll('loading');
    }
  });
  return false;
}