$(document).ready(function(){ 
  var form = layui.form;
  //切换组卷方式
  form.on('radio(changeQuestWay)', function(data){
    var questway = $(this).val();
    if(questway==1 || questway==2){ //随机组卷,学生抽题
      $("#questway1box_1").show();
      $("#questway1box_2").show();
      $("#exstems_form").hide();
      showMaxQuestnum();
      if(questway==2){
        $("#questway2box_1").show();
      }else{
        $("#questway2box_1").hide();
      }
    }else{ //题库选取
      $("#questway1box_1").hide();
      $("#questway1box_2").hide();
      $("#exstems_form").show();
    }
  });
  //全选删除题目
  form.on('checkbox(allChoose)', function(data){
    var child = $(data.elem).parents('form').find('input[name="exstemidel[]"]');
    child.each(function(index, item){
      item.checked = data.elem.checked;
    });
    form.render('checkbox');
  });
  if(ispublish!=1 && (questway==1 || questway==2)){
    showMaxQuestnum();
  }
});

//弹出层索引
var index11, index12, index13, index14;

//弹出题库列表
function showQuestionList(){
  layer.load(0, {shade: [0.2, '#393D49']});
  index12 = layer.open({
    id: 'onedialog',
    type: 2,
    title: '选择题目',
    area: ['900px', '570px'],
    fixed: false, //不固定
    content: '/glexam/qubank/index?id='+ examid
  });
  layer.closeAll('loading');
}

//关闭题库列表
function closeQuestionList(){
  layer.close(index12);
}

//预览题目
function showResourViewBox(resourid){
  layer.load(0, {shade: [0.2, '#393D49']});
  index13 = layer.open({
    id: 'threedialog',
    type: 2,
    title: '预览',
    area: ['900px', '570px'],
    fixed: false, //不固定
    content: '/glquesti/preview/'+ resourid
  });
  layer.closeAll('loading');
}

//弹出课程列表
function showCourseList(){
  layer.load(0, {shade: [0.2, '#393D49']});
  index11 = layer.open({
    id: 'onedialog',
    type: 2,
    title: '选择范围',
    area: ['900px', '570px'],
    fixed: false, //不固定
    content: '/glexam/qucourse/index'
  });
  layer.closeAll('loading');
}

//关闭课程列表
function closeCourseList(){
  layer.close(index11);
  showMaxQuestnum();
}

//弹出章节列表
function showChapterList(rand_courseid){
  layer.load(0, {shade: [0.2, '#393D49']});
  index14 = layer.open({
    id: 'fourdialog',
    type: 2,
    title: '选择范围',
    area: ['900px', '570px'],
    fixed: false, //不固定
    content: '/glexam/qucourse/tree?id='+ rand_courseid
  });
  layer.closeAll('loading');
}

//关闭章节列表
function closeChapterList(){
  layer.close(index14);
  showMaxQuestnum();
}

//获取可用题目数量
function showMaxQuestnum(){
  var questway = $("#detail_form").find("input[name='questway']:checked").val();
  var rand_courseid = $("#detail_form").find("input[name='rand_courseid']").val();
  var rand_treeid = $("#detail_form").find("input[name='rand_treeid']").val();
  if(questway=="" || questway==0){
    return false;
  }
  if(rand_courseid=="" || rand_courseid==0){
    return false;
  }
  $.ajax({
    url: '/glexam/question/maxquest', 
    type: 'POST',
    dataType: "json",
    data: {"questway":questway, "rand_courseid":rand_courseid, "rand_treeid":rand_treeid}, 
    beforeSend: function(){
      $(".rand_maxquest").html('<i class="layui-icon layui-anim layui-anim-rotate layui-anim-loop">&#xe63d;</i>');
    },
    success: function(data){
      if(data.code=="success"){
        $(data.data).each(function(index, element){
          $("#maxquest_"+ element.id +"_box").html(element.questnum);
        });
      }else{
        layer.msg(data.msg, {icon:2});
      }
    },
    error: function(){
      layer.msg("系统错误，请联系管理员", {icon:2});
    }
  });
  return false;
}

//计算题目总分
function calcTotalPoints(){
  var totalpoints = 0;
  $("#exstems_form").find("input[name='expoints[]']").each(function(index, el) {
    totalpoints += parseInt($(this).val());
  });
  $("#totalpointsbox").html("总分："+ totalpoints);
}

//保存组卷方式
$("#finished_button").on("click", function(){
  var questway = $("#detail_form").find("input[name='questway']:checked").val();
  var rand_courseid = $("#detail_form").find("input[name='rand_courseid']").val();
  if(questway==""){
    layer.msg("请选择组卷方式", {icon:2});
    return false;
  }
  if((questway==1 || questway==2) && (rand_courseid=="" || rand_courseid=="0")){
    layer.msg("请选择组卷范围", {icon:2});
    return false;
  }
  var thereiserror = false;
  $("#detail_form").ajaxSubmit({
    url: '/glexam/question/basicok', 
    type: 'POST',
    async: false,
    dataType: "json", 
    success: function(data){
      if(data.code=="success"){
        //layer.msg("成功", {icon:1});
      }else{
        thereiserror = true;
        layer.msg(data.msg, {icon:2});
      }
    },
    error: function(){
      thereiserror = true;
      layer.msg("系统错误，请联系管理员", {icon:2});
    }
  });
  if(thereiserror==false){
    if(questway==1){ //随机组卷
      $("#detail_form").ajaxSubmit({
        url: '/glexam/question/qrandomok', 
        type: 'POST',
        dataType: "json", 
        beforeSend: function(){
          layer.load(0, {shade: [0.2, '#393D49']});
        },
        success: function(data){
          if(data.code=="success"){
            layer.msg("成功", {icon:1}, function(){window.location.reload();});
          }else{
            layer.msg(data.msg, {icon:2});
          }
        },
        error: function(){
          layer.msg("系统错误，请联系管理员", {icon:2});
        },
        complete: function(){
          layer.closeAll('loading');
        }
      });
      return false;
    }else if(questway==2){ //学生抽题
      layer.msg("保存成功", {icon:1});
    }else{ //题库选取
      showQuestionList();
    }
  }
  return false;
});

//保存题目分数
$("#savepoints_button").on("click", function(){
  var expointsarr = $("#exstems_form").find("input[name='expoints[]']");
  var thereiserror = 0;
  $("#exstems_form").find("input[name='expoints[]']").each(function(index, el) {
    if(isNaN($(this).val()) || $(this).val()<0){
      thereiserror = 1;
    }
  });
  if(thereiserror==1){
    layer.msg("分值必须为大于0的数字", {icon:2});
    return false;
  }
  $("#exstems_form").ajaxSubmit({
    url: '/glexam/question/expointsok', 
    type: 'POST',
    dataType: "json", 
    success: function(data){
      if(data.code=="success"){
        calcTotalPoints();
        layer.msg("成功", {icon:1});
      }else{
        layer.msg(data.msg, {icon:2});
      }
    },
    error: function(){
      layer.msg("系统错误，请联系管理员", {icon:2});
    }
  });
});

//删除题目
$("#deletstems_button").on("click", function(){
  if($("#exstems_form").find("input[name='exstemidel[]']:checked").length==0){
    layer.msg("您还没有选择题目", {icon:2});
    return false;
  }
  var layerbox = layer.confirm('此操作不可恢复，<br>确认要删除吗？', {
      area: ['400px', '230px'],
      icon: 0,
      btn: ['确定','取消'] //按钮
    }, function(){
      $("#exstems_form").ajaxSubmit({
        url: '/glexam/question/delete', 
        type: 'POST',
        dataType: "json", 
        success: function(data){
          if(data.code=="success"){
            layer.msg("成功", {icon:1}, function(){window.location.reload();});
          }else{
            layer.msg(data.msg, {icon:2});
          }
        },
        error: function(){
          layer.msg("系统错误，请联系管理员", {icon:2});
        }
      });
    }, function(){
      //do nothing
  });
  
});