$(document).ready(function(){  
  //全选
  var form = layui.form;
  form.on('checkbox(allChoose)', function(data){
    var child = $(data.elem).parents('table').find('tbody input[type="checkbox"]');
    child.each(function(index, item){
      item.checked = data.elem.checked;
    });
    form.render('checkbox');
  });
  //筛选
  form.on('select(changecondition)', function(data){
    $("#search_form").submit();
  });

  //对学生公开
  form.on('switch(changeOpenType)', function(data){
    var courseid = $(this).val();
    var isopen = 0;
    if(this.checked==true){
      isopen = 1;
    }
    $.ajax({
      url: '/glqcourse/special/changeopen', 
      type: 'POST',
      dataType: "json", 
      data: {courseid:courseid,isopen:isopen},
      success: function(data){
        if(data.code=="success"){
          //layer.msg("成功", {icon:1});
        }else{
          layer.msg(data.msg, {icon:2});
        }
      },
      error: function(){
        layer.msg("系统错误，请联系管理员", {icon:2});
      }
    });
    return false;
  });

  //分页
  var laypage = layui.laypage;
  laypage.render({
    elem: 'pagelinkbox',
    count: allsize,
    limit: pagesize,
    layout: ['count', 'prev', 'page', 'next', 'skip'],
    jump: function(obj){
      $("#gotopage_form").find("input[name='curpage']").val(obj.curr);
      $("#gotopage_form").find("input[name='rnum']").val(Math.random());
      $("#gotopage_form").ajaxSubmit({
        url: '/glqcourse/myqbank/index', 
        type: 'POST',
        dataType: 'html',
        beforeSend: function(){
          $("#waitingtipsbox").show();
        },
        success: function(data){
          if(data==""){
            //layer.msg("已经到最后一页了", {icon: 2});
          }else{
            $("#pagelistbox").html(data);
            form.render('checkbox'); //重新渲染复选框
          }
          $("#waitingtipsbox").hide();
        },
        error: function(){
          layer.msg("系统错误，请联系管理员", {icon: 2});
        }
      });
      return false;
    }
  });

});

//编辑课程
function showCourseEditBox(specialid, courseid){
  layer.load(0, {shade: [0.2, '#393D49']});
  layer.open({
    id: 'onedialog',
    type: 2,
    title: '编辑',
    area: ['600px', '400px'],
    fixed: false, //不固定
    content: '/glqcourse/course/index?id='+ courseid +'&specialid='+ specialid
  });
  layer.closeAll('loading');
}
//删除课程
function showCourseDeleBox(courseid){
  var layerbox = layer.confirm('这将同时删除该课程下的<br>所有章节、知识点、素材、题库，<br>确认要删除吗？', {
    area: ['400px', '230px'],
    icon: 0,
    btn: ['确定','取消'] //按钮
  }, function(){
    $.ajax({
      url: '/glqcourse/course/delete', 
      type: 'POST',
      data: {courseid:courseid,rnum:Math.random()},
      dataType: "json", 
      beforeSend: function(){
        layer.load(0, {shade: [0.2, '#393D49']});
      },
      success: function(data){
        if(data.code=="success"){
          layer.msg("成功", {icon:1}, function(){window.location.reload();});
        }else{
          layer.msg(data.msg, {icon:2});
        }
      },
      error: function(){
        layer.msg("系统错误，请联系管理员", {icon:2});
      },
      complete: function(){
        layer.closeAll('loading');
      }
    });
    return false;
  }, function(){
    //do nothing
  });
}

//弹出层索引
var index11, index12, index13, index14;

//团队成员
function showLeaderListBox(treeid){
  layer.load(0, {shade: [0.2, '#393D49']});
  index11 = layer.open({
    id: 'onedialog',
    type: 2,
    title: '团队成员',
    area: ['900px', '570px'],
    fixed: false, //不固定
    content: '/glqcourse/leader/'+ treeid
  });
  layer.closeAll('loading');
}

//添加成员
function showLeaderEditBox(treeid){
  layer.load(0, {shade: [0.2, '#393D49']});
  index12 = layer.open({
    id: 'twodialog',
    type: 2,
    title: '团队成员',
    area: ['900px', '570px'],
    fixed: false, //不固定
    content: '/glqcourse/leaderadd/index?id='+ treeid
  });
  layer.closeAll('loading');
}

//刷新成员列表
function reloadLeaderListBox(treeid){
  layer.close(index12);
  layer.iframeSrc(index11, '/glqcourse/leader/'+ treeid);
}