//弹出层索引
var index1, index2, index3;

//编辑章
function showChapterEditBox(chapterid){
  layer.load(0, {shade: [0.2, '#393D49']});
  index1 = layer.open({
    id: 'onedialog',
    type: 2,
    title: '编辑',
    area: ['600px', '400px'],
    fixed: false, //不固定
    content: '/glqcourse/chapter/'+ chapterid
  });
  layer.closeAll('loading');
}
//删除章
function showChapterDeleBox(chapterid){
  var layerbox = layer.confirm('这将同时删除该章下的<br>所有节、知识点、题库，<br>确认要删除吗？', {
    area: ['400px', '230px'],
    icon: 0,
    btn: ['确定','取消'] //按钮
  }, function(){
    $.ajax({
      url: '/glqcourse/chapter/delete', 
      type: 'POST',
      data: {chapterid:chapterid,rnum:Math.random()},
      dataType: "json", 
      beforeSend: function(){
        layer.load(0, {shade: [0.2, '#393D49']});
      },
      success: function(data){
        if(data.code=="success"){
          layer.msg("成功", {icon:1}, function(){window.location.reload();});
        }else{
          layer.msg(data.msg, {icon:2});
        }
      },
      error: function(){
        layer.msg("系统错误，请联系管理员", {icon:2});
      },
      complete: function(){
        layer.closeAll('loading');
      }
    });
    return false;
  }, function(){
    //do nothing
  });
}

//编辑节
function showSectionEditBox(sectionid, chapterid){
  layer.load(0, {shade: [0.2, '#393D49']});
  index2 = layer.open({
    id: 'onedialog',
    type: 2,
    title: '编辑',
    area: ['600px', '400px'],
    fixed: false, //不固定
    content: '/glqcourse/section/'+ sectionid +'-'+ chapterid
  });
  layer.closeAll('loading');
}
//删除节
function showSectionDeleBox(sectionid){
  var layerbox = layer.confirm('这将同时删除该节下的<br>所有知识点、题库，<br>确认要删除吗？', {
    area: ['400px', '230px'],
    icon: 0,
    btn: ['确定','取消'] //按钮
  }, function(){
    $.ajax({
      url: '/glqcourse/section/delete', 
      type: 'POST',
      data: {sectionid:sectionid,rnum:Math.random()},
      dataType: "json", 
      beforeSend: function(){
        layer.load(0, {shade: [0.2, '#393D49']});
      },
      success: function(data){
        if(data.code=="success"){
          layer.msg("成功", {icon:1}, function(){window.location.reload();});
        }else{
          layer.msg(data.msg, {icon:2});
        }
      },
      error: function(){
        layer.msg("系统错误，请联系管理员", {icon:2});
      },
      complete: function(){
        layer.closeAll('loading');
      }
    });
    return false;
  }, function(){
    //do nothing
  });
}

//编辑知识点
function showKnowledEditBox(knowledid, sectionid){
  layer.load(0, {shade: [0.2, '#393D49']});
  index3 = layer.open({
    id: 'onedialog',
    type: 2,
    title: '编辑',
    area: ['600px', '400px'],
    fixed: false, //不固定
    content: '/glqcourse/knowled/'+ knowledid +'-'+ sectionid
  });
  layer.closeAll('loading');
}
//删除知识点
function showKnowledDeleBox(knowledid){
  var layerbox = layer.confirm('这将同时删除该知识点下的<br>所有题库，<br>确认要删除吗？', {
    area: ['400px', '230px'],
    icon: 0,
    btn: ['确定','取消'] //按钮
  }, function(){
    $.ajax({
      url: '/glqcourse/knowled/delete', 
      type: 'POST',
      data: {knowledid:knowledid,rnum:Math.random()},
      dataType: "json", 
      beforeSend: function(){
        layer.load(0, {shade: [0.2, '#393D49']});
      },
      success: function(data){
        if(data.code=="success"){
          layer.msg("成功", {icon:1}, function(){window.location.reload();});
        }else{
          layer.msg(data.msg, {icon:2});
        }
      },
      error: function(){
        layer.msg("系统错误，请联系管理员", {icon:2});
      },
      complete: function(){
        layer.closeAll('loading');
      }
    });
    return false;
  }, function(){
    //do nothing
  });
}

//上下移动节点
function showNodeMoveupBox(treeid, direction){
  $.ajax({
    url: '/glqcourse/tree/moveupdown', 
    type: 'POST',
    data: {treeid:treeid,direction:direction,rnum:Math.random()},
    dataType: "json", 
    beforeSend: function(){
      layer.load(0, {shade: [0.2, '#393D49']});
    },
    success: function(data){
      if(data.code=="success"){
        layer.msg("成功", {icon:1}, function(){window.location.reload();});
      }else{
        layer.msg(data.msg, {icon:2});
      }
    },
    error: function(){
      layer.msg("系统错误，请联系管理员", {icon:2});
    },
    complete: function(){
      layer.closeAll('loading');
    }
  });
  return false;
}