$(document).ready(function(){  
  //全选
  var form = layui.form;
  form.on('checkbox(allChoose)', function(data){
    var child = $(data.elem).parents('table').find('tbody input[type="checkbox"]');
    child.each(function(index, item){
      item.checked = data.elem.checked;
    });
    form.render('checkbox');
  });
  //筛选
  form.on('select(changecondition)', function(data){
    $("#search_form").submit();
  });

  //分页
  var laypage = layui.laypage;
  laypage.render({
    elem: 'pagelinkbox',
    count: allsize,
    limit: pagesize,
    layout: ['count', 'prev', 'page', 'next', 'skip'],
    jump: function(obj){
      $("#gotopage_form").find("input[name='curpage']").val(obj.curr);
      $("#gotopage_form").find("input[name='rnum']").val(Math.random());
      $("#gotopage_form").ajaxSubmit({
        url: '/glquesti/list/'+ courseid, 
        type: 'POST',
        dataType: 'html',
        beforeSend: function(){
          $("#waitingtipsbox").show();
        },
        success: function(data){
          if(data==""){
            //layer.msg("已经到最后一页了", {icon: 2});
          }else{
            $("#pagelistbox").html(data);
            form.render('checkbox'); //重新渲染复选框
          }
          $("#waitingtipsbox").hide();
        },
        error: function(){
          layer.msg("系统错误，请联系管理员", {icon: 2});
        }
      });
      return false;
    }
  });
  
  //删除
  $("#delete_button").on("click", function(){
    var checkednum = $("#list_form").find("input[name='resourid[]']:checked").length;
    if(checkednum==0){
      layer.msg("您还没有选择", {icon: 2});
      return false;
    }
    var layerbox = layer.confirm('此操作不可恢复，<br>确认要删除吗？', {
      area: ['400px', '230px'],
      icon: 0,
      btn: ['确定','取消'] //按钮
    }, function(){
      $("#list_form").ajaxSubmit({
        url: '/glquesti/resource/delete', 
        type: 'POST',
        dataType: "json", 
        beforeSend: function(){
          layer.load(0, {shade: [0.2, '#393D49']});
        },
        success: function(data){
          if(data.code=="success"){
            layer.msg("成功", {icon:1}, function(){window.location.reload();});
          }else{
            layer.msg(data.msg, {icon:2});
          }
        },
        error: function(){
          layer.msg("系统错误，请联系管理员", {icon:2});
        },
        complete: function(){
          layer.closeAll('loading');
        }
      });
    }, function(){
      //do nothing
    });
    return false;
  });

  //移动
  $("#moveto_button").on("click", function(){
    var checkedelem = $("#list_form").find("input[name='resourid[]']:checked");
    if($(checkedelem).length==0){
      layer.msg("您还没有选择", {icon: 2});
    }else{
      var resourceids = "";
      $(checkedelem).each(function(){
        if(resourceids==""){
          resourceids = $(this).val();
        }else{
          resourceids += ","+ $(this).val();
        }
      });
      $("#moveto_form").find("input[name='resourceids']").val(resourceids);
      showResourMoveBox();
    }
    return false;
  });
});

//弹出层索引
var index11, index12, index13, index14, index15;

//编辑题目
function showResourEditBox(resourid, treeid){
  $("#stem_form").find("input[name='stemid']").val(resourid);
  $("#stem_form").find("input[name='treeid']").val(treeid);
  layer.load(0, {shade: [0.2, '#393D49']});
  index12 = layer.open({
    id: 'twodialog',
    type: 2,
    title: '编辑',
    area: ['900px', '570px'],
    fixed: false, //不固定
    content: '/glquesti/basic/index?stemid='+ resourid
  });
  layer.closeAll('loading');
}

//预览题目
function showResourViewBox(resourid){
  layer.load(0, {shade: [0.2, '#393D49']});
  index13 = layer.open({
    id: 'threedialog',
    type: 2,
    title: '预览',
    area: ['900px', '570px'],
    fixed: false, //不固定
    content: '/glquesti/preview/'+ resourid
  });
  layer.closeAll('loading');
}

//移动题目
function showResourMoveBox(){
  var checkedelem = $("#list_form").find("input[name='resourid[]']:checked");
  if($(checkedelem).length==0){
    layer.msg("您还没有选择", {icon: 2});
    return false;
  }
  var resourceids = "";
  $(checkedelem).each(function(){
    if(resourceids==""){
      resourceids = $(this).val();
    }else{
      resourceids += ","+ $(this).val();
    }
  });
  $("#moveto_form").find("input[name='resourceids']").val(resourceids);
  layer.load(0, {shade: [0.2, '#393D49']});
  index14 = layer.open({
    id: 'fourdialog',
    type: 2,
    title: '编辑',
    area: ['900px', '570px'],
    fixed: false, //不固定
    content: '/glquesti/moveto/index?courseid='+ courseid
  });
  layer.closeAll('loading');
}

//批量导入
function showQuestImportBox(){
  index15 = layer.open({
    id: 'fivedialog',
    type: 2,
    title: '导入',
    area: ['600px', '400px'],
    fixed: false, //不固定
    content: '/glquesti/import/index',
    cancel: function(){window.location.reload();}
  });
}

//禁用题目
function lockedQuestion(islocked){
  $("#list_form").find("input[name='islocked']").val(islocked);
  var checkednum = $("#list_form").find("input[name='resourid[]']:checked").length;
  if(checkednum==0){
    layer.msg("您还没有选择", {icon: 2});
    return false;
  }
  $("#list_form").ajaxSubmit({
    url: '/glquesti/resource/locked', 
    type: 'POST',
    dataType: "json", 
    beforeSend: function(){
      layer.load(0, {shade: [0.2, '#393D49']});
    },
    success: function(data){
      if(data.code=="success"){
        layer.msg("成功", {icon:1}, function(){window.location.reload();});
      }else{
        layer.msg(data.msg, {icon:2});
      }
    },
    error: function(){
      layer.msg("系统错误，请联系管理员", {icon:2});
    },
    complete: function(){
      layer.closeAll('loading');
    }
  });
  return false;
}