$(document).ready(function(){ 
  form = layui.form;
  //专业筛选条件
  form.on('select(changespecialty)', function(data){
    var specialid = data.elem.value;
    showXzclassList(specialid);
  });
  //初始化显示
  if(od_specialid>0){
    showXzclassList(od_specialid, od_xzclassid);
  }
});

//根据专业切换班级
function showXzclassList(specialid, xzclassid){
  $.ajax({
    url: '/gluser/default/xzclasslist', 
    type: 'POST',
    dataType: "html", 
    data: {specialid:specialid, xzclassid:xzclassid},
    success: function(data){
      $("select[name='xzclassid']").html(data);
      form.render('select');
    },
    error: function(){
      layer.msg("系统错误，请联系管理员", {icon:2});
    }
  });
  return false;
}

//提交表单
$("#finished_button").on("click", function(){
  var username = $("#detail_form").find("input[name='username']");
  var password = $("#detail_form").find("input[name='password']");
  var realname = $("#detail_form").find("input[name='realname']");
  var stdnumber = $("#detail_form").find("input[name='stdnumber']");
  var email = $("#detail_form").find("input[name='email']");
  var logo = $("#detail_form").find("input[name='logo']");
  var male = $("#detail_form").find("input[name='male']");
  var cellphone = $("#detail_form").find("input[name='cellphone']");
  if($(username).val()==""){
    layer.tips('请填写用户名', $(username), {tips: [1, '#FF5722']});
    return false;
  }
  var regex = /^\s*[A-Za-z0-9_-]{4,20}\s*$/;
  if(!regex.test($(username).val())){
    $(username).parent().next().css("color","#FF5722").html("用户名格式错误");
    layer.tips('用户名格式错误', $(username), {tips: [1, '#FF5722']});
    return false;
  }
  if(userid==0){
    if($(password).val()==""){
      layer.tips('请填写密码', $(password), {tips: [1, '#FF5722']});
      return false;
    }
  }
  if($(realname).val()==""){
    layer.tips('请填写姓名', $(realname), {tips: [1, '#FF5722']});
    return false;
  }
  var regex = /^\s*[\u4e00-\u9fa5\(\)a-zA-Z0-9_]{2,20}\s*$/;
  if(!regex.test($(realname).val())){
    $(realname).parent().next().css("color","#FF5722").html("姓名格式错误");
    layer.tips('姓名格式错误', $(realname), {tips: [1, '#FF5722']});
    return false;
  }
  if($(stdnumber).val()==""){
    layer.tips('请填写学号', $(stdnumber), {tips: [1, '#FF5722']});
    return false;
  }
  var regex = /^\s*[A-Za-z0-9_-]{4,20}\s*$/;
  if(!regex.test($(stdnumber).val())){
    $(stdnumber).parent().next().css("color","#FF5722").html("学号格式错误");
    layer.tips('学号格式错误', $(stdnumber), {tips: [1, '#FF5722']});
    return false;
  }
  if($(cellphone).val()!=""){
  	var regex = /^1[3|4|5|7|8][0-9]{9}$/;
  	if(!regex.test($(cellphone).val())){
  	  $(cellphone).parent().next().css("color","#FF5722").html("手机号格式错误");
  	  layer.tips('手机号格式错误', $(cellphone), {tips: [1, '#FF5722']});
  	  return false;
  	}
  }
  if($(email).val()!=""){
    var regex = /^\w+((-\w+)|(\.\w+))*\@[A-Za-z0-9]+((\.|-)[-A-Za-z0-9]+)*\.[A-Za-z0-9]+$/;
    if(!regex.test($(email).val())){
      $(email).parent().next().css("color","#FF5722").html("邮箱格式错误");
      layer.tips('邮箱格式错误', $(email), {tips: [1, '#FF5722']});
      return false;
    }
  }
  $("#detail_form").ajaxSubmit({
    url: '/gluser/basic/basicok', 
    type: 'POST',
    dataType: "json", 
    success: function(data){
      if(data.code=="success"){
        layer.msg("成功", {icon:1}, function(){window.location.href = "/gluser/default/index";});
      }else{
        layer.msg(data.msg, {icon:2});
      }
    },
    error: function(){
      layer.msg("系统错误，请联系管理员", {icon:2});
    }
  });
  return false;
});

//删除头像
function deletelogo(userid){
  var layerbox = layer.confirm('确认要删除吗', {
    area: ['400px', '230px'],
    icon: 0,
    btn: ['确定','取消'] //按钮
  }, function(){
    $.ajax({
      url: '/gluser/basic/deletelogo', 
      type: 'POST',
      data: {userid:userid,rnum:Math.random()},
      dataType: "json", 
      success: function(data){
        if(data.code=="success"){
          $("#logopreview").empty();
          $("#detail_form").find("input[name='logo']").val("");
          layer.close(layerbox);
        }else{
          layer.msg(data.msg, {icon:2});
        }
      },
      error: function(){
        layer.msg("系统错误，请联系管理员", {icon:2});
      }
    });
    return false;
  }, function(){
    //do nothing
  });
}

//上传插件
var uploader = new plupload.Uploader({
  runtimes : 'html5,flash,silverlight,html4',
  browse_button : 'pickfiles', // you can pass an id...
  container: document.getElementById('uploadcontainer'), // ... or DOM Element itself
  url : '/gluser/upload/logo',
  flash_swf_url : '/plugins/plupload/js/Moxie.swf',
  silverlight_xap_url : '/plugins/plupload/js/Moxie.xap',
  multi_selection: false,
  
  filters : {
    max_file_size : '1000mb',
    mime_types: [
      {title : "Image files", extensions : "jpg,gif,png,jpeg,bmp"}
    ]
  },

  init: {
    PostInit: function() {
      document.getElementById('filelist').innerHTML = '';
      document.getElementById('uploadfiles').onclick = function() {
        uploader.start();
        return false;
      };
    },

    FilesAdded: function(up, files) {
      plupload.each(files, function(file) {
        document.getElementById('filelist').innerHTML += '<div id="' + file.id + '">' + file.name + ' (' + plupload.formatSize(file.size) + ') <b></b><div class="progress"><div class="progress-bar" style="width: 0%"></div></div></div>';
      });
      uploader.start(); //自动开始上传
      return false;
    },

    UploadProgress: function(up, file) {
      var d = document.getElementById(file.id);
      d.getElementsByTagName('b')[0].innerHTML = '<span>' + file.percent + "%</span>";
            var prog = d.getElementsByTagName('div')[0];
      var progBar = prog.getElementsByTagName('div')[0]
      progBar.style.width= 2*file.percent+'px';
      progBar.setAttribute('aria-valuenow', file.percent);
    },

    FileUploaded: function(up, file, info) {
      //console.log(info.response);
      if (info.status == 200){
        var json = $.parseJSON(info.response);
        document.getElementById("console").innerHTML += json.info.name +',#,'+ json.info.path +',#,'+ json.info.size +',#,'+ json.info.extension +',#,'+ json.info.oldname +'<br>';
        $("#detail_form").find("input[name='logo']").val(json.info.path_s);
        $("#logopreview").html('<img src="'+ json.info.path_s +'" style="width: 40px; height: 40px; border-radius: 50%;">');
      }else{
        document.getElementById("console").innerHTML += file.name +'上传失败<br>';
      }
    },

    UploadComplete: function(up, files) {
      console.log('complete');
    },

    Error: function(up, err) {
      document.getElementById('console').appendChild(document.createTextNode("\nError #" + err.code + ": " + err.message));
    }
  }
});

uploader.init();