$(document).ready(function(){  
  //全选
  var form = layui.form;
  form.on('checkbox(allChoose)', function(data){
    var child = $(data.elem).parents('table').find('tbody input[type="checkbox"]');
    child.each(function(index, item){
      item.checked = data.elem.checked;
    });
    form.render('checkbox');
  });
  //筛选
  form.on('select(changecondition)', function(data){
    $("#search_form").submit();
  });

  //分页
  var laypage = layui.laypage;
  laypage.render({
    elem: 'pagelinkbox',
    count: allsize,
    limit: pagesize,
    layout: ['count', 'prev', 'page', 'next', 'skip'],
    jump: function(obj){
      $("#gotopage_form").find("input[name='curpage']").val(obj.curr);
      $("#gotopage_form").find("input[name='rnum']").val(Math.random());
      $("#gotopage_form").ajaxSubmit({
    		url: '/glxzclass/archive/index', 
    		type: 'POST',
    		dataType: 'html',
    		beforeSend: function(){
          $("#waitingtipsbox").show();
        },
    		success: function(data){
    			if(data==""){
    				//layer.msg("已经到最后一页了", {icon: 2});
    			}else{
    				$("#pagelistbox").html(data);
    				form.render('checkbox'); //重新渲染复选框
    			}
    			$("#waitingtipsbox").hide();
    		},
    		error: function(){
    			layer.msg("系统错误，请联系管理员", {icon: 2});
    		}
  	  });
      return false;
    }
  });

  //恢复
  $("#archive_button").on("click", function(){
    var checkednum = $("#list_form").find("input[name='xzclassid[]']:checked").length;
    if(checkednum==0){
      layer.msg("您还没有选择", {icon: 2});
      return false;
    }
    var layerbox = layer.confirm('与班级相关的用户和考试也将恢复，<br>确认要恢复吗？', {
      area: ['400px', '230px'],
      icon: 0,
      btn: ['确定','取消'] //按钮
    }, function(){
      $("#list_form").ajaxSubmit({
        url: '/glxzclass/archive/recover', 
        type: 'POST',
        dataType: "json", 
        beforeSend: function(){
          layer.load(0, {shade: [0.2, '#393D49']});
        },
        success: function(data){
          if(data.code=="success"){
            layer.msg("成功", {icon:1}, function(){window.location.reload();});
          }else{
            layer.msg(data.msg, {icon:2});
          }
        },
        error: function(){
          layer.msg("系统错误，请联系管理员", {icon:2});
        },
        complete: function(){
          layer.closeAll('loading');
        }
      });
    }, function(){
      //do nothing
    });
    return false;
  });

  //删除
  $("#delete_button").on("click", function(){
    var checkednum = $("#list_form").find("input[name='xzclassid[]']:checked").length;
    if(checkednum==0){
      layer.msg("您还没有选择", {icon: 2});
      return false;
    }
    var layerbox = layer.confirm('与班级相关的用户也将删除，<br>确认要删除吗？', {
      area: ['400px', '230px'],
      icon: 0,
      btn: ['确定','取消'] //按钮
    }, function(){
      $("#list_form").ajaxSubmit({
        url: '/glxzclass/archive/delete', 
        type: 'POST',
        dataType: "json", 
        beforeSend: function(){
          layer.load(0, {shade: [0.2, '#393D49']});
        },
        success: function(data){
          if(data.code=="success"){
            layer.msg("成功", {icon:1}, function(){window.location.reload();});
          }else{
            layer.msg(data.msg, {icon:2});
          }
        },
        error: function(){
          layer.msg("系统错误，请联系管理员", {icon:2});
        },
        complete: function(){
          layer.closeAll('loading');
        }
      });
    }, function(){
      //do nothing
    });
    return false;
  });

});

//弹出层索引
var index11, index12;

//编辑班级
function showXzclassEditBox(specialid, xzclassid){
  layer.load(0, {shade: [0.2, '#393D49']});
  index11 = layer.open({
    id: 'onedialog',
    type: 2,
    title: '编辑',
    area: ['600px', '400px'],
    fixed: false, //不固定
    content: '/glxzclass/basic/index?id='+ xzclassid +'&specialid='+ specialid
  });
  layer.closeAll('loading');
}

//关闭班级窗口
function closeXzclassListBox(){
  layer.close(index11);
}

//重新统计学生数量
function calcStudentnumAgain(specialid, xzclassid){
  $("#progressbox").show();
  $("#calcStudentnumbox").attr("src", "/glxzclass/default/calcstudentnum?specialid="+ specialid +"&xzclassid="+ xzclassid);
}