<?php
use app\models\Config;
use app\components\AccessControl;
$config = Config::find()->where("id=1")->one();
$userobj = AccessControl::isLogin();
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<title><?php echo $this->params["meta_title"]; ?><?php echo $config->name; ?></title>
  <meta name="renderer" content="webkit">
  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
  <meta name="apple-mobile-web-app-status-bar-style" content="black"> 
  <meta name="apple-mobile-web-app-capable" content="yes">
  <meta name="format-detection" content="telephone=no">
  <meta name="keywords" content="<?php echo $config->keywords; ?>">
  <meta name="description" content="<?php echo $config->description; ?>">
  <link rel="stylesheet" href="/plugins/layui/css/layui.css">
  <link rel="stylesheet" href="/plugins/fontawesome/css/font-awesome.min.css" />
  <link rel="stylesheet" href="/public/css/global.css">
  <script src="/public/js/jquery-1.11.3.min.js"></script>
  <script src="/public/js/jquery.form-3.36.0.min.js"></script>
</head>
<body>

<div class="layui-layout layui-layout-admin">

  <div class="layui-header">
    <div class="layui-logo"><?php if(!empty($config->logo)){echo '<img class="layui-logo-img" src="'. $config->logo .'">';} ?></div>
    <ul class="layui-nav layui-layout-left">
    </ul>
    <ul class="layui-nav layui-layout-right">
      <li class="layui-nav-item<?php if($this->params["navicode"]=="home"){echo ' layui-this';} ?>"><a href="/">首页</a></li>
      <?php if(empty($userobj)){ ?>
      <li class="layui-nav-item<?php if($this->params["navicode"]=="login"){echo ' layui-this';} ?>"><a href="<?php echo Yii::$app->params["login_url"]; ?>">登录</a></li>
      <?php if($config->isregist==1){ ?><li class="layui-nav-item<?php if($this->params["navicode"]=="register"){echo ' layui-this';} ?>"><a href="<?php echo Yii::$app->params["regist_url"]; ?>">注册</a></li><?php } ?>
      <?php } ?>
      <li class="layui-nav-item">
        <a href="javascript:;">使用手册</a>
        <dl class="layui-nav-child">
          <dd><a href="/public/manual/admin.pdf" target="_blank">管理员</a></dd>
          <dd><a href="/public/manual/teacher.pdf" target="_blank">教师</a></dd>
          <dd><a href="/public/manual/student.pdf" target="_blank">学生</a></dd>
          <dd><a href="/public/manual/mobile_tea.pdf" target="_blank">手机端_教师</a></dd>
          <dd><a href="/public/manual/mobile_stu.pdf" target="_blank">手机端_学生</a></dd>
        </dl>
      </li>
      <li class="layui-nav-item"><a href="/yidong/default/index">手机端</a></li>
      <?php if(!empty($userobj)){ ?>
      <li class="layui-nav-item">
        <a href="javascript:;">
          <img src="<?php echo $userobj->logo; ?>" class="layui-nav-img">
          <?php echo $userobj->realname; ?>
        </a>
        <dl class="layui-nav-child">
          <dd><a href="/user/default/index">进入后台</a></dd>
          <dd><a href="/user/profile/index">个人资料</a></dd>
          <dd><a href="/user/chanpass/index">修改密码</a></dd>
          <dd><a href="<?php echo Yii::$app->params["logout_url"]; ?>">注销</a></dd>
        </dl>
      </li>
      <?php } ?>
    </ul>
  </div>

  <div style="margin: 0 auto; width: 100%;">
  <?php echo $content; ?>
  </div>

  <div class="footer" style="text-align: center;">
    <!-- 底部固定区域 -->
    Copyright © <?php echo date("Y"); ?> <?php echo $config->copyright; ?>
    <br><?php if(!empty($config->icpno)){echo $config->icpno;} ?>
  </div>

</div>

<script src="/plugins/layui/layui.all.js"></script>

</body>
</html>
