﻿<%
 ' FCKeditor - The text editor for Internet - http://www.fckeditor.net
 ' Copyright (C) 2003-2008 Frederico Caldeira Knabben
 '
 ' == BEGIN LICENSE ==
 '
 ' Licensed under the terms of any of the following licenses at your
 ' choice:
 '
 '  - GNU General Public License Version 2 or later (the "GPL")
 '    http://www.gnu.org/licenses/gpl.html
 '
 '  - GNU Lesser General Public License Version 2.1 or later (the "LGPL")
 '    http://www.gnu.org/licenses/lgpl.html
 '
 '  - Mozilla Public License Version 1.1 or later (the "MPL")
 '    http://www.mozilla.org/MPL/MPL-1.1.html
 '
 ' == END LICENSE ==
 '
 ' This file include the functions that handle the Command requests
 ' in the ASP Connector.
%>
<%
'--------------------------------------------------------------------------
   Public Function GetNewFileName()
     dim ranNum
     dim dtNow
     dtNow=Now()
     randomize
     ranNum=int(90*rnd)+10
     GetNewFileName=year(dtNow) & right("0" & month(dtNow),2) & right("0" & day(dtNow),2) & right("0" & hour(dtNow),2) & right("0" & minute(dtNow),2) & right("0" & second(dtNow),2) & ranNum
    End Function
	
'----------------------------------------------------------------------------

Function CheckFileSafe(sFilePath)
 
Dim CheckFso,ObjReadFile,sFileTextAll,IsFileSafe,sNotSafe,NotSafeList,ListLoop
 
sNotSafe=".getfolder|.createfolder|.deletefolder|.createdirectory|.deletedirectory|.saveas|wscript.shell|script.encode|server.|.createobject|execute|activexobject|language="
NotSafeList=Split(sNotSafe,"|")
IsFileSafe=True
Set CheckFso=Server.CreateObject( "Scripting.FileSystemObject" )
 
If CheckFso.FileExists(sFilePath) then
 
   Set ObjReadFile = CheckFso.OpenTextFile(sFilePath, 1)
   sFileTextAll=Lcase(ObjReadFile.ReadAll)
   ObjReadFile.Close
 
   For ListLoop=0 to Ubound(NotSafeList)
    If Instr(sFileTextAll,NotSafeList(ListLoop))>0 then
     IsFileSafe=False
	 
	 CreateServerFolder Server.MapPath("/UploadFiles/cracker/")
	 dim sFilePath_ct                     
	 sFilePath_ct=split(sFilePath,"\")     
	 'CheckFso.DeleteFile sFilePath          
	 CheckFso.MoveFile   sFilePath,Server.MapPath("/UploadFiles/cracker/"&"hack_"&sFilePath_ct(ubound(sFilePath_ct))) 	 
	 
     Exit For
    End If
   Next  
End If
Set CheckFso=Nothing
CheckFileSafe=IsFileSafe
End Function

'----------------------------------------------------------------------------	
	

Sub GetFolders( resourceType, currentFolder )
	' Map the virtual path to the local server path.
	Dim sServerDir
	sServerDir = ServerMapFolder( resourceType, currentFolder, "GetFolders" )

	' Open the "Folders" node.
	Response.Write "<Folders>"

	Dim oFSO, oCurrentFolder, oFolders, oFolder
	Set oFSO = Server.CreateObject( "Scripting.FileSystemObject" )
	if not (oFSO.FolderExists( sServerDir ) ) then
		Set oFSO = Nothing
		SendError 102, currentFolder
	end if

	Set oCurrentFolder = oFSO.GetFolder( sServerDir )
	Set oFolders = oCurrentFolder.SubFolders

	For Each oFolder in oFolders
		Response.Write "<Folder name=""" & ConvertToXmlAttribute( oFolder.name ) & """ />"
	Next

	Set oFSO = Nothing

	' Close the "Folders" node.
	Response.Write "</Folders>"
End Sub

Sub GetFoldersAndFiles( resourceType, currentFolder )
	' Map the virtual path to the local server path.
	Dim sServerDir
	sServerDir = ServerMapFolder( resourceType, currentFolder, "GetFoldersAndFiles" )

	Dim oFSO, oCurrentFolder, oFolders, oFolder, oFiles, oFile
	Set oFSO = Server.CreateObject( "Scripting.FileSystemObject" )
	if not (oFSO.FolderExists( sServerDir ) ) then
		Set oFSO = Nothing
		SendError 102, currentFolder
	end if

	Set oCurrentFolder = oFSO.GetFolder( sServerDir )
	Set oFolders	= oCurrentFolder.SubFolders
	Set oFiles		= oCurrentFolder.Files

	' Open the "Folders" node.
	Response.Write "<Folders>"

	For Each oFolder in oFolders
		Response.Write "<Folder name=""" & ConvertToXmlAttribute( oFolder.name ) & """ />"
	Next

	' Close the "Folders" node.
	Response.Write "</Folders>"

	' Open the "Files" node.
	Response.Write "<Files>"

	For Each oFile in oFiles
		Dim iFileSize
		iFileSize = Round( oFile.size / 1024 )
		If ( iFileSize < 1 AND oFile.size <> 0 ) Then iFileSize = 1

		Response.Write "<File name=""" & ConvertToXmlAttribute( oFile.name ) & """ size=""" & iFileSize & """ />"
	Next

	' Close the "Files" node.
	Response.Write "</Files>"
End Sub

Sub CreateFolder( resourceType, currentFolder )
	Dim sErrorNumber

	Dim sNewFolderName
	sNewFolderName = Request.QueryString( "NewFolderName" )
	sNewFolderName = SanitizeFolderName( sNewFolderName )    

	If ( sNewFolderName = "" OR InStr( 1, sNewFolderName, ".." ) > 0  ) Then
		sErrorNumber = "102"
	Else
		' Map the virtual path to the local server path of the current folder.
		Dim sServerDir
		sServerDir = ServerMapFolder( resourceType, CombineLocalPaths(currentFolder, sNewFolderName), "CreateFolder" )

		On Error Resume Next

		CreateServerFolder sServerDir

		Dim iErrNumber, sErrDescription
		iErrNumber		= err.number
		sErrDescription	= err.Description

		On Error Goto 0

		Select Case iErrNumber
			Case 0
				sErrorNumber = "0"
			Case 52
				sErrorNumber = "102"	' Invalid Folder Name.
			Case 70
				sErrorNumber = "103"	' Security Error.
			Case 76
				sErrorNumber = "102"	' Path too long.
			Case Else
				sErrorNumber = "110"
		End Select
	End If

	' Create the "Error" node.
	Response.Write "<Error number=""" & sErrorNumber & """ originalNumber=""" & iErrNumber & """ originalDescription=""" & ConvertToXmlAttribute( sErrDescription ) & """ />"
End Sub

Sub FileUpload( resourceType, currentFolder, sCommand )
	Dim oUploader
	Set oUploader = New NetRube_Upload
	oUploader.MaxSize	= 0
	oUploader.Allowed	= ConfigAllowedExtensions.Item( resourceType )
	oUploader.Denied	= ConfigDeniedExtensions.Item( resourceType )
	oUploader.HtmlExtensions = ConfigHtmlExtensions
	oUploader.GetData

	Dim sErrorNumber
	sErrorNumber = "0"

	Dim sFileName, sOriginalFileName, sExtension
	sFileName = ""

	If oUploader.ErrNum > 0 Then
		sErrorNumber = "202"
	Else
		' Map the virtual path to the local server path.
		Dim sServerDir
		sServerDir = ServerMapFolder( resourceType, currentFolder, sCommand )

		Dim oFSO
		Set oFSO = Server.CreateObject( "Scripting.FileSystemObject" )
		if not (oFSO.FolderExists( sServerDir ) ) then
			sErrorNumber = "102"
		else
			' Get the uploaded file name.
			'sFileName	= oUploader.File( "NewFile" ).Name
			'sFileName   = GetNewFileName() &"."& split(oUploader.File( "NewFile" ).Name,".")(1)
			sFileName   = GetNewFileName() &"."& oUploader.File( "NewFile" ).Ext
			sExtension	= oUploader.File( "NewFile" ).Ext
			sFileName = SanitizeFileName( sFileName )     
			sOriginalFileName = sFileName
			
			
'------------------------------------------------- 		
   Dim  dFileSize,UploadLimitMaxsize,IsLimitOk   
   dFileSize=oUploader.File( "NewFile" ).Size/1024   
   
   select case resourceType     
   case "File"
    UploadLimitMaxsize=1024   
   case "Image"
    UploadLimitMaxsize=200
   case "Flash"
    UploadLimitMaxsize=10240
   case "Media"
    UploadLimitMaxsize=10240  
   case "Attach"
    UploadLimitMaxsize=1024
   case else
    '默认设定限制上传，最大为1M
    UploadLimitMaxsize=200
   end select
	
   if session("AM_Name")<>"" then UploadLimitMaxsize=1024*100   	
			
 
   IsLimitOk = True
    if dFileSize > UploadLimitMaxsize then
     IsLimitOk = False
     sErrorNumber = "206"  
    end if   
 
			
			

			Dim iCounter
			iCounter = 0

			'Do While ( True )
			Do While ( IsLimitOk )     
				Dim sFilePath
				sFilePath = CombineLocalPaths(sServerDir, sFileName)

				If ( oFSO.FileExists( sFilePath ) ) Then            
					iCounter = iCounter + 1
					sFileName = RemoveExtension( sOriginalFileName ) & "(" & iCounter & ")." & sExtension
					sErrorNumber = "201"
				Else
					oUploader.SaveAs "NewFile", sFilePath
					If oUploader.ErrNum > 0 Then sErrorNumber = "202"
 
     if Not CheckFileSafe(sFilePath) then 
       sErrorNumber = "205"
     End If    					
 					
					Exit Do
				End If
			Loop
		end if
	End If

	Set oUploader	= Nothing

	dim sFileUrl
	sFileUrl = CombinePaths( GetResourceTypePath( resourceType, sCommand ) , currentFolder )
	sFileUrl = CombinePaths( sFileUrl, sFileName )

	SendUploadResults sErrorNumber, sFileUrl, sFileName, ""
End Sub

%>
