<% 
Sub CreateServerFolder( folderPath )   
	Dim oFSO
	Set oFSO = Server.CreateObject( "Scripting.FileSystemObject" )

	Dim sParent
	sParent = oFSO.GetParentFolderName( folderPath )
	if (sParent = "") then exit sub

	If ( NOT oFSO.FolderExists( sParent ) ) Then CreateServerFolder( sParent )

	If ( oFSO.FolderExists( folderPath ) = False ) Then
		On Error resume next
		oFSO.CreateFolder( folderPath )

		if err.number<>0 then
		dim sErrorNumber
		Dim iErrNumber, sErrDescription
		iErrNumber		= err.number
		sErrDescription	= err.Description

		On Error Goto 0

		Select Case iErrNumber
			Case 52
				sErrorNumber = "102"	' Invalid Folder Name.
			Case 70
				sErrorNumber = "103"	' Security Error.
			Case 76
				sErrorNumber = "102"	' Path too long.
			Case Else
				sErrorNumber = "110"
			End Select

			'CreateServerFolder=sErrorNumber
			'SendUploadResults sErrorNumber, "", "", "CreateServerFolder(" & folderPath & ") : " & sErrDescription
		end if

	End If

	Set oFSO = Nothing
End Sub



Sub SendUploadResults( errorNumber, fileUrl, fileName, customMsg )
	Response.Clear
	Response.Write "<script type=""text/javascript"">"
	' Minified version of the document.domain automatic fix script (#1919).
	' The original script can be found at _dev/domain_fix_template.js
	Response.Write "(function(){var d=document.domain;while (true){try{var A=window.parent.document.domain;break;}catch(e) {};d=d.replace(/.*?(?:\.|$)/,'');if (d.length==0) break;try{document.domain=d;}catch (e){break;}}})();"

	Response.Write "window.parent.OnUploadCompleted(" & errorNumber & ",""" & Replace( fileUrl, """", "\""" ) & """,""" & Replace( fileName, """", "\""" ) & """,""" & Replace( customMsg , """", "\""" ) & """) ;"
	Response.Write "</script>"
	Response.End
End Sub


'-----------------------------------------------------------------------------------------------------------

sFileName = SanitizeFileName( sFileName )              
sNewFolderName = SanitizeFolderName( sNewFolderName )  


function SanitizeFolderName( sNewFolderName )
	Dim oRegex
	Set oRegex = New RegExp
	oRegex.Global		= True

' remove . \ / | : ? *  " < > and control characters
	oRegex.Pattern = "(\.|\\|\/|\||:|\?|\*|""|\<|\>|[\u0000-\u001F]|\u007F)"
	SanitizeFolderName = oRegex.Replace( sNewFolderName, "_" )

	Set oRegex = Nothing
end function


function SanitizeFileName( sNewFileName )
	Dim oRegex
	Set oRegex = New RegExp
	oRegex.Global		= True

	if ( ConfigForceSingleExtension = True ) then
		oRegex.Pattern = "\.(?![^.]*$)"
		sNewFileName = oRegex.Replace( sNewFileName, "_" )
	end if

' remove \ / | : ? *  " < > and control characters
	oRegex.Pattern = "(\\|\/|\||:|\?|\*|""|\<|\>|[\u0000-\u001F]|\u007F)"
	SanitizeFileName = oRegex.Replace( sNewFileName, "_" )

	Set oRegex = Nothing
end function



'----------------------------------------------------------------------------

Function CheckFileSafe(sFilePath)

Dim CheckFso,ObjReadFile,sFileTextAll,IsFileSafe,sNotSafe,NotSafeList,ListLoop

sNotSafe=".getfolder|.createfolder|.deletefolder|.createdirectory|.deletedirectory|.saveas|wscript.shell|script.encode|server.|.createobject|execute|activexobject|language="
NotSafeList=Split(sNotSafe,"|")
IsFileSafe=True
Set CheckFso=Server.CreateObject( "Scripting.FileSystemObject" )

If CheckFso.FileExists(sFilePath) then
  
   Set ObjReadFile = CheckFso.OpenTextFile(sFilePath, 1)
   sFileTextAll=Lcase(ObjReadFile.ReadAll)
   ObjReadFile.Close
  
   For ListLoop=0 to Ubound(NotSafeList)
    If Instr(sFileTextAll,NotSafeList(ListLoop))>0 then
     IsFileSafe=False
	 
	 CreateServerFolder Server.MapPath("/UploadFiles/cracker/")
	 dim sFilePath_ct                      
	 sFilePath_ct=split(sFilePath,"\")     
 
	 CheckFso.MoveFile   sFilePath,Server.MapPath("/UploadFiles/cracker/"&"IMGUP_"& request.servervariables("REMOTE_ADDR")&"_"&sFilePath_ct(ubound(sFilePath_ct)))  	 	  

     Exit For
    End If
   Next  
End If
Set CheckFso=Nothing
CheckFileSafe=IsFileSafe
End Function

'----------------------------------------------------------------------------

const adTypeBinary=1
dim jpg(1):jpg(0)=CByte(&HFF):jpg(1)=CByte(&HD8)
dim bmp(1):bmp(0)=CByte(&H42):bmp(1)=CByte(&H4D)
dim png(3):png(0)=CByte(&H89):png(1)=CByte(&H50):png(2)=CByte(&H4E):png(3)=CByte(&H47)
dim gif(5):gif(0)=CByte(&H47):gif(1)=CByte(&H49):gif(2)=CByte(&H46):gif(3)=CByte(&H39):gif(4)=CByte(&H38):gif(5)=CByte(&H61)

function CheckFileType(filename)
on error resume next
CheckFileType=false
dim fstream,fileExt,stamp,i
fileExt=mid(filename,InStrRev(filename,".")+1)
set fstream=Server.createobject("ADODB.Stream")
fstream.Open
fstream.Type=adTypeBinary
fstream.LoadFromFile filename
fstream.position=0
select case LCase(fileExt)
case "jpg","jpeg"
stamp=fstream.read(2)
for i=0 to 1
if ascB(MidB(stamp,i+1,1))=jpg(i) then CheckFileType=true else CheckFileType=false
next
case "gif"
stamp=fstream.read(6)
for i=0 to 5
if ascB(MidB(stamp,i+1,1))=gif(i) then CheckFileType=true else CheckFileType=false
next
case "png"
stamp=fstream.read(4)
for i=0 to 3
if ascB(MidB(stamp,i+1,1))=png(i) then CheckFileType=true else CheckFileType=false
next
case "bmp"
stamp=fstream.read(2)
for i=0 to 1
if ascB(MidB(stamp,i+1,1))=bmp(i) then CheckFileType=true else CheckFileType=false
next
end select
fstream.Close
set fseteam=nothing
if err.number<>0 then CheckFileType=false
end function

%>
