if(typeof GoogleMap === 'undefined'){
    var GoogleMap = {};
}
(function(){
    if (!document.getElementById("map_canvas")) {
        return false;
    }
    else {
         if (GBrowserIsCompatible()) {
            var mapContainer = document.getElementById("map_canvas");
             var map = new GMap2(mapContainer);
             var perviewLevel = 16;
             var largeMapControl = new GLargeMapControl();
             var overviewMapControl = new GOverviewMapControl();
             var scaleControl = new GScaleControl();
             var mapTypeControl = new GMapTypeControl();
             var geocoder = new GClientGeocoder();
             var lastAddress = '';
             var lastPoint = null;
             var lastMarker = null;
             var cusLastPoint = null;
 
            GoogleMap.mapMsg = [];
 
             GoogleMap.Map = function(lat, lng){
                var point = new GLatLng(lat, lng);        
                map.addMapType(G_PHYSICAL_MAP);
                map.setCenter(point, perviewLevel);
 
                map.enableDoubleClickZoom();
                map.enableScrollWheelZoom();
                map.enableContinuousZoom();
 
                //map.addControl(largeMapControl)
                //map.addControl(overviewMapControl);
                //map.addControl(mapTypeControl);
                //map.addControl(scaleControl);
				
				map.addControl(new GMapTypeControl());
				var customUI = map.getDefaultUI();
				// Remove MapType.G_HYBRID_MAP
				customUI.maptypes.hybrid = false;
				map.setUI(customUI);				
            };
 
             GoogleMap.createMarker = function(latlng, markerOptions){
                var marker = markerOptions ? new GMarker(latlng, markerOptions) : new GMarker(latlng);
                lastMarker = marker;
                return marker;
            };
 

            GoogleMap.setCustomIcon = function(IconOptions){
                var myIcon = new GIcon(G_DEFAULT_ICON), i;
                for (i in IconOptions) {
                    switch (i) {
                        case 'iconSize':
                        case 'shadowSize':
                        case 'dragCrossSize':
                            myIcon[i] = new GSize(IconOptions[i][0], IconOptions[i][1]);
                            break;
                        case 'iconAnchor':    
                        case 'infoWindowAnchor':
                        case 'infoShadowAnchor':
                        case 'dragCrossAnchor':
                            myIcon.iconAnchor = new GPoint(IconOptions[i][0], IconOptions[i][1]);
                            break;
                        default:
                            myIcon[i] = IconOptions[i];
                            break;
                    }    
 
                }    
                return myIcon;
            };
 
             GoogleMap.customMarkPoint = function(){
                var marker = null;
				var center = map.getCenter(); 
				var markPoint = new GLatLng(center.lat(),center.lng());
 				map.clearOverlays();                                
				map.setCenter(markPoint);
				
                var markOptions = {
                    icon: GoogleMap.setCustomIcon({
                        image: '/images/gmark1.png'
                    }),
                    draggable: true,bouncy:true
                };
 
                marker = GoogleMap.createMarker(markPoint, markOptions);
                GEvent.addListener(marker, "dragstart", function(){
                    map.closeInfoWindow();
                });
                GEvent.addListener(marker, "dragend", function(){
                    var custPoint = marker.getPoint();
                    var markTip = '<div class="fgmap_markerMsg" id="cusMarkTip">';
                    markTip += '<h4>ͼע</h4>';
                    //markTip += '<div id="mapTips"><p>ǰγȣ(' + custPoint.lat() + ',' + custPoint.lng() + ')<br />';
                    markTip += 'Ƿ񽫸ΪĬλã</p>';
                    markTip += '<div class="MDB" style="text-align:center;"><button id="MapOK" onclick="GoogleMap.MapOk()"> ȷ  </button>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<button id="MapCancel" onclick="GoogleMap.MapCancel()"> ȡ  </button></div></div></div>';
                    marker.openInfoWindowHtml(markTip);
                });
                map.addOverlay(marker);
            };
 
             GoogleMap.MapOk = function(){
                var savedPoint = lastMarker.getPoint();
                var lat = savedPoint.lat(), lng = savedPoint.lng();
                var markTip = document.getElementById('cusMarkTip');
                markTip.innerHTML = '<h4>ڱϢ...</h4>';
                if (timer) {
                    clearTimeout(timer);
                }
                var timer = setTimeout(function(){
                    map.clearOverlays();
					
					 var markOptions = {
						icon: GoogleMap.setCustomIcon({
							image: '/images/gmark1.png'
						}),
						draggable: false,bouncy:true
					};					
					
                    var marker = GoogleMap.createMarker(savedPoint,markOptions);
                    if (GoogleMap.mapMsg) {
                        GEvent.addListener(marker, "click", function(){
                            var msg = '<span class="fgmap_markerMsg">', j;
                            msg += '<h4>' + GoogleMap.mapMsg[2][0] + '</h4>';
							//if(GoogleMap.mapMsg[1][0]!=''){msg += '<h8><img border=0 width=150 height=150 src=' + GoogleMap.mapMsg[1][0] + '></h4>';}
                            for (var j = 1; j < GoogleMap.mapMsg[2].length; j++) {
                                msg += GoogleMap.mapMsg[2][j] + "<br />";
                            }
                            msg += "</span>";
                            map.openInfoWindowHtml(savedPoint, msg);
                        });
                    }
                    map.addOverlay(marker);
                    map.setCenter(savedPoint);
                    cusLastPoint = [lat,lng];
					indiv(cz_url+'&jd='+lat+'&wd='+lng,'mapcz_info');	
					//window.location=url_bk;
                }, 500);
            };
 
             GoogleMap.MapCancel = function(){
                map.removeOverlay(lastMarker);
                map.closeInfoWindow();
            };
 
             GoogleMap.getAddresslatlng = function(response){
                var place = response.Placemark[0];
                var point = new GLatLng(place.Point.coordinates[1], place.Point.coordinates[0]);
                return [place.Point.coordinates[1], place.Point.coordinates[0], point, place];
            };
 
             GoogleMap.MarkerMap = function(lat, lng){
                var marker = null;
                var point = new GLatLng(lat, lng);
                GoogleMap.Map(lat, lng);
 
                 var markOptions = {
                    icon: GoogleMap.setCustomIcon({
                        image: '/images/gmark1.png'
                    }),
                    draggable: false,bouncy:true
                };
				
                marker = this.createMarker(point,markOptions);
                if (GoogleMap.mapMsg) {
                        var msg = '<span class="fgmap_markerMsg">', j;
                        msg += '<h4>' + GoogleMap.mapMsg[2][0] + '</h4>';
						//if(GoogleMap.mapMsg[1][0]!=''){msg += '<h8><img border=0 width=150 height=150 src=' + GoogleMap.mapMsg[1][0] + '></h4>';}
                        for (var j = 1; j < GoogleMap.mapMsg[2].length; j++) {
                            msg += GoogleMap.mapMsg[2][j] + "<br />";
                        }
                        msg += "</span>";					
                    GEvent.addListener(marker, "click", function(){marker.openInfoWindowHtml(msg);});
					
                }
                map.addOverlay(marker);
				marker.openInfoWindowHtml(msg);
            };
 
             GoogleMap.addAddressToMap = function(response){
                map.clearOverlays();
                if (!response || response.Status.code != 200) {
                    alert("Բ, ǽõַľγ꣡");
                }
                else {
                    var marker = null, point = GoogleMap.getAddresslatlng(response);
                    var address = point[3].address, lat = point[0], lng = point[1];
                    GoogleMap.mapMsg = (GoogleMap.mapMsg !== '' && (lastAddress === GoogleMap.mapMsg[0])) ? GoogleMap.mapMsg : [address, [point[3].address, ('ȣ' + point[1]), ('γȣ' + point[0])]];
                    GoogleMap.MarkerMap(lat, lng);
                    lastPoint = [lat,lng];
                }
            };
 
             GoogleMap.addPointToMap = function(cPoint){
                map.clearOverlays();
                var marker = null, lat = cPoint[0], lng = cPoint[1];
                GoogleMap.MarkerMap(lat, lng);
                lastPoint = [lat,lng];
            };
 
             GoogleMap.showLocation = function(cPoint){
                if (typeof cPoint === 'string') {
                    geocoder.getLocations(cPoint, this.addAddressToMap);
                    lastAddress = cPoint;
                }
                else{
                    GoogleMap.addPointToMap(cPoint);
                }
            };
 
            GEvent.addListener(window, 'unload', GUnload);
        }
        else {
            alert("Բִ֧ͼ");
        }
    }
})();