﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using mymvc.Models;
using System.Data.Linq.SqlClient;

namespace mymvc.Controllers
{
    public class AdminController : Controller
    {
        //
        // GET: /Recycle/
        private mymvc.Models.MyMvcEntities db = new Models.MyMvcEntities();
        public ActionResult Recycle(int? id, int? page)
        {
            if (!Check.CheckPower(this.ControllerContext)) return View("Message");

            int PageSize = 15;
            int PageIndex = page ?? 1;
            if (PageIndex < 1) PageIndex = 1;
            //List<Models.GuestBook> gb =(from m in db.GuestBook where m.G_Recycle == 2 orderby m.Id descending select m).ToList();

            var list = db.GuestBook.Where(e => e.G_Recycle == 2).OrderByDescending(e => e.Id);
            ViewData["PageIndex"] = PageIndex;
            ViewData["PageSize"] = PageSize;
            ViewData["ReCordCount"] = list.Count();
            //if (list.Count() == 0) return View(list);
            return View(FPage.GetPageList(list, PageIndex, PageSize));
        }
        public ActionResult Restore(int id)
        {
            Models.GuestBook gb = (from m in db.GuestBook where m.Id == id select m).First();
            if (!ModelState.IsValid)
                return View(gb);
            gb.G_Recycle = 1;
            db.SaveChanges();
            ViewData["Message"] = "该留言已成功还原!";
            ViewData["Message1"] = "主页面";
            ViewData["Url"] = "/Home/Index";
            return View("Message");
        }
        public ActionResult Delete(int id)
        {

            Models.GuestBook gb = (from m in db.GuestBook where m.Id == id select m).First();
            List<Models.Comment> cm = (from m in db.Comment where m.GuestBookId == id select m).ToList();
            db.DeleteObject(gb);
            foreach (var delcm in cm)
            {
                db.DeleteObject(delcm);
            }
            db.SaveChanges();
            ViewData["Message"] = "操作成功!该留言已彻底删除!";
            ViewData["Message1"] = "主页面";
            ViewData["Url"] = "/Home/Index";
            return View("Message");
        }
        public ActionResult Columns()
        {
            if (!Check.CheckPower(this.ControllerContext)) return View("Message");
            List<Models.Columns> col = (from m in db.Columns select m).ToList();
            return View(col);
        }
        public ActionResult Add_Columns()
        {
            if (!Check.CheckPower(this.ControllerContext)) return View("Message");
            return View();
        }
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult Add_Columns(Columns colu)
        {
            if (!Check.CheckPower(this.ControllerContext)) return View("Message");

            Check.IsNull(colu.Column_Name, "Column_Name", "栏目名不能为空！", this);
            Check.IsNull(colu.Info, "Info", "栏目名不能为空！", this);
            if (!ModelState.IsValid) return View();

            Check.IsLength(colu.Column_Name, 15, "Column_Name", "栏目名字数超过规定字数！", this);
            Check.IsLength(colu.Info, 30, "Info", "描述字数超过规定字数！", this);
            if (!ModelState.IsValid) return View();

            Models.Columns col = (from m in db.Columns where m.Column_Name == colu.Column_Name select m).FirstOrDefault();
            if (col == null)
            {
                db.AddToColumns(colu);
                db.SaveChanges();
                return RedirectToAction("Columns");
            }
            else
            {
                ModelState.AddModelError("Column_Name", "数据库已存在改栏目名！");
                return View();
            }
        }
        public ActionResult Del_Columns(int id)
        {
            var iscol = from m in db.GuestBook where m.Column_Id == id select m;
            if (iscol.Count() != 0)
            {
                ViewData["Message"] = "该栏目已经存在留言,请先处理留言,再进行此操作！";
                ViewData["Message1"] = "栏目管理面";
                ViewData["Url"] = "/Admin/Columns";
                return View("Message");
            }

            Models.Columns col = (from m in db.Columns where m.Id == id select m).First();
            db.DeleteObject(col);
            db.SaveChanges();
            return RedirectToAction("Columns");
        }
        public ActionResult Edit_Columns(int id)
        {
            if (!Check.CheckPower(this.ControllerContext)) return View("Message");
            Models.Columns col = (from m in db.Columns where m.Id == id select m).First();
            return View(col);
        }
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult Edit_Columns(int id, Columns colu)
        {
            Columns c = (from m in db.Columns where m.Id == id select m).FirstOrDefault();

            Check.IsNull(colu.Column_Name, "Column_Name", "栏目名不能为空！", this);
            Check.IsNull(colu.Info, "Info", "栏目名不能为空！", this);
            if (!ModelState.IsValid) return View();

            Check.IsLength(colu.Column_Name, 15, "Column_Name", "栏目名字数超过规定字数！", this);
            Check.IsLength(colu.Info, 30, "Info", "描述字数超过规定字数！", this);
            if (!ModelState.IsValid) return View();

            Models.Columns col = (from m in db.Columns where m.Column_Name == colu.Column_Name && m.Id != id select m).FirstOrDefault();
            if (col == null)
            {
                c.Info = colu.Info;
                c.Column_Name = colu.Column_Name;
                db.SaveChanges();
                return RedirectToAction("Columns");
            }
            else
            {
                ModelState.AddModelError("Column_Name", "数据库已存在改栏目名！");
                return View();
            }
        }
        public ActionResult Admin_GBook(int? id, int? page)
        {
            if (!Check.CheckPower(this.ControllerContext)) return View("Message");
            int PageSize = 15;
            int PageIndex = page ?? 1;

            var list = db.GuestBook.Where(e => e.G_Recycle == 1).OrderByDescending(e => e.Id);
            ViewData["PageIndex"] = PageIndex;
            ViewData["PageSize"] = PageSize;
            ViewData["ReCordCount"] = list.Count();

            return View(FPage.GetPageList(list, PageIndex, PageSize));
        }
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult Admin_GBook(string KeyWord, int? page)
        {
            if (!Check.CheckPower(this.ControllerContext)) return View("Message");
            int PageSize = 15;
            int PageIndex = page ?? 1;

            var list = db.GuestBook.Where(e => e.G_Recycle == 1 && e.G_Title.IndexOf(KeyWord) > -1).OrderByDescending(e => e.Id);
            var NewUser = (from m in db.Member orderby m.Id descending select m).First();
            ViewData["PageIndex"] = PageIndex;
            ViewData["PageSize"] = PageSize;
            ViewData["ReCordCount"] = list.Count();

            ViewData["NewUser"] = NewUser.UserName;
            ViewData["MemberCount"] = db.Member.Count();
            ViewData["CommentCount"] = db.Comment.Count();

            return View(FPage.GetPageList(list, PageIndex, PageSize));
        }

        public ActionResult Move(int id)
        {
            if (!Check.CheckPower(this.ControllerContext)) return View("Message");
            IEnumerable<Models.Columns> col = from m in db.Columns select m;
            ViewData["PList"] = col.Select(e => new SelectListItem() { Text = e.Column_Name, Value = e.Id.ToString() });
            Models.GuestBook gb = (from m in db.GuestBook where m.Id == id select m).First();
            return View(gb);
        }
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult Move(int id, int Column_Id)
        {
            Models.GuestBook gb = (from m in db.GuestBook where m.Id == id select m).First();
            gb.Column_Id = Column_Id;
            db.SaveChanges();
            ViewData["Message"] = "该留言移动成功！";
            ViewData["Message1"] = "留言管理页面";
            ViewData["Url"] = "/Admin/Admin_GBook";
            return View("Message");
        }

        public ActionResult Users(int? page)
        {
            if (!Check.CheckPower(this.ControllerContext)) return View("Message");
            var list = db.Member.OrderBy(e => e.Id);
            int PageSize = 10;
            int PageIndex = page ?? 1;

            ViewData["PageIndex"] = PageIndex;
            ViewData["PageSize"] = PageSize;
            ViewData["ReCordCount"] = list.Count();

            return View(FPage.GetPageList(list, PageIndex, PageSize));
        }

        public ActionResult Del_User(int? id)
        {
            if (!Check.CheckPower(this.ControllerContext)) return View("Message");
            var us = db.Member.Where(e => e.Id == id).FirstOrDefault();
            if (int.Parse(us.Power) == 1)
            {
                ViewData["Message"] = "管理员无法删除！";
                ViewData["Message1"] = "会员管理页面";
                ViewData["Url"] = "/Admin/Users";
                return View("Message");
            }
            var gb = db.GuestBook.Where(e => e.MemberId == id).ToList();
            int?[] Ids = gb.Select(e => (int?)e.Id).ToArray();
            var com = db.Comment.Where(e => e.MemberId == id || Ids.Contains(e.GuestBookId)).ToList();
            if (com.Count() != 0) foreach (var c in com) db.DeleteObject(c);
            if (gb.Count() != 0) foreach (var g in gb) db.DeleteObject(g);
            db.DeleteObject(us);
            db.SaveChanges();
            return RedirectToAction("Users");
        }
    }
}
