﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using mymvc.Models;

namespace mymvc.Controllers
{
    public class MemberController : Controller
    {
        //
        // GET: /Member/
        private mymvc.Models.MyMvcEntities db = new Models.MyMvcEntities();
        public ActionResult SetAtt()
        {
            if (!Check.IsLogin(this.ControllerContext)) return View("Message");
            int uid = (int)Session["UID"];
            Models.Member user = (from m in db.Member where m.Id == uid select m).First();
            return View(user);
        }
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult SetAtt(string SetAtt)
        {
            if (!Check.IsLogin(this.ControllerContext)) return View("Message");
            int uid = (int)Session["UID"];
            Models.Member user = (from m in db.Member where m.Id == uid select m).First();
            if (SetAtt.Length > 50)
            {
                ModelState.AddModelError("SetAtt", "个性签名不得大于50字！");
                return View();
            }
            if (!ModelState.IsValid)
                return View(user);
            user.SetAtt = SetAtt;
            db.SaveChanges();

            ViewData["Message"] = "个性签名保存成功!";
            ViewData["Message1"] = "主页面";
            ViewData["Url"] = "/Home/Index";
            return View("Message");

        }
        public ActionResult Login()
        {
            return View();
        }
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult Login(Models.Member use, string UserName, string PassWord)
        {
            Check.IsNull(UserName, "UserName", "用户名不得为空！", this);
            Check.IsNull(PassWord, "PassWord", "密码不得为空！", this);
            if (Request.Form["YanZheng"].ToUpper() != Session["GoogleCode"].ToString())
            {
                ModelState.AddModelError("YanZhengError", "验证码错误！");
                return View();
            }
            if (!ModelState.IsValid)
                return View();

            if (ModelState.IsValid)
            {
                Member u = Check.yanzhengyonghu(use);
                if (u != null)
                {
                    Session["User_qx"] = u.Power;
                    Session["UID"] = u.Id;
                    Session["username"] = u.UserName;
                    return RedirectToAction("Index","Home");
                }
                else
                {
                    ModelState.AddModelError("PassWord", "用户名或密码错误!");
                }

            }
            return View();
        }
        public ActionResult Register()
        {
            return View();
        }
        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult Register(Models.Member use, string ConfirmPassword)
        {
            if (ModelState.IsValid)
            {
                Check.IsNull(use.UserName, "UserName", "用户名不得为空！", this);
                Check.IsNull(use.PassWord, "PassWord", "密码不能为空！", this);

                if (!string.Equals(use.PassWord, ConfirmPassword))
                {
                    ModelState.AddModelError("ConfirmPassword", "两次输入密码不相同!");
                    return View();
                }
                Member u = Check.yanzhengyonghu(use);
                if (u != null)
                {
                    ModelState.AddModelError("UserName", "该用户名已经存在!");
                }
                else
                {
                    if (Request.Form["YanZheng"].ToUpper() != Session["GoogleCode"].ToString())
                    {
                        ModelState.AddModelError("YanZhengError", "验证码错误！");
                        return View();
                    }
                    use.Head = Request.Form["User_img"];
                    use.Sex = Request.Form["Sex"];
                    use.Power = "2";
                    db.AddToMember(use);
                    db.SaveChanges();

                    ViewData["Message"] = "恭喜您,注册成功!";
                    ViewData["Message1"] = "登录页面";
                    ViewData["Url"] = "/Member/Login";
                    return View("Message");
                }

            }
            return View();
        }

        public ActionResult Comment(int? id, int? page)
        {
            var list = db.GuestBook.Where(e => e.Id == id);
            var gb = list.FirstOrDefault();
            
            if (gb == null)
            {
                ViewData["Message"] = "不存在该留言!";
                ViewData["Message1"] = "主页面";
                ViewData["Url"] = "/Home/Index";
                return View("Message");
            }
            ViewData["Column_Name"] = gb.Columns.Column_Name;
            int PageSize = 10;
            int PageIndex = page ?? 1;
            if (PageIndex < 1) PageIndex = 1;

            var CommList = db.Comment.Where(e => e.GuestBookId == gb.Id).OrderBy(e => e.Id);
            ViewData["PageIndex"] = PageIndex;
            ViewData["PageSize"] = PageSize;
            ViewData["ReCordCount"] = CommList.Count();
            ViewData["col"] = FPage.GetPageList(CommList, PageIndex, PageSize);            

            ViewData["floor"] = ((PageIndex - 1) * PageSize) + 1;
            return View(gb);

        }

        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult Comment(Models.Comment com, int id, string Comments, int? page)
        {
            var list = db.GuestBook.Where(e => e.Id == id);
            var gb = list.FirstOrDefault();
            if (!Check.IsLogin(this.ControllerContext)) return View("Message");

            ViewData["Column_Name"] = gb.Columns.Column_Name;

            int PageSize = 10;
            int PageIndex = page ?? 1;
            if (PageIndex < 1) PageIndex = 1;
            var CommList = db.Comment.Where(e => e.GuestBookId == gb.Id).OrderBy(e => e.Id);
            ViewData["PageIndex"] = PageIndex;
            ViewData["PageSize"] = PageSize;
            ViewData["ReCordCount"] = CommList.Count();
            ViewData["col"] = FPage.GetPageList(CommList, PageIndex, PageSize);            


            ViewData["floor"] = ((PageIndex - 1) * PageSize) + 1;

            if (Comments.Length > 100)
            {
                ModelState.AddModelError("Comment_Messages", "回复内容不得超过100字！");
                return View(gb);
            }
            if (Request.Form["YanZheng"].ToUpper() != Session["GoogleCode"].ToString())
            {
                ModelState.AddModelError("YanZhengError", "验证码错误！");
                return View(gb);
            }

            com.Comments = Comments;
            com.GuestBookId = id;
            com.C_Time = DateTime.Now;
            com.MemberId = (int)Session["UID"];
            db.AddToComment(com);
            db.SaveChanges();
            return RedirectToAction("Comment", "Member", new { id = id });
        }

        public ActionResult ChangePassWord()
        {
            if (!Check.IsLogin(this.ControllerContext)) return View("Message");
            return View();
        }

        [AcceptVerbs(HttpVerbs.Post)]
        public ActionResult ChangePassWord(string PassWord, string NewPassWord, string ConfirmNewPassWord)
        {
            //if (!Check.CheckPower(this.ControllerContext)) return View("Message");
            if (PassWord == "" || NewPassWord == "" || ConfirmNewPassWord == "")
            {
                ModelState.AddModelError("ErrorMessage", "操作错误,以上三项必须不得为空！");
                return View();
            }
            int UserID = (int)Session["UID"];
            Models.Member a = db.Member.Where(e => e.Id == UserID).First();

            if (a.PassWord!=PassWord)
            {
                ModelState.AddModelError("PassWord", "原始密码错误！");
                return View();
            }
            if (NewPassWord != ConfirmNewPassWord)
            {
                ModelState.AddModelError("ConfirmNewPassWord", "两次密码不相符！");
                return View();
            }
            if (Request.Form["YanZheng"].ToUpper() != Session["GoogleCode"].ToString())
            {
                ModelState.AddModelError("YanZhengError", "验证码错误！");
                return View();
            }
            a.PassWord = NewPassWord;
            db.SaveChanges();
            Session["User_qx"] = null;
            Session["UID"] = null;
            Session["username"] = null;
            ViewData["Message"] = "恭喜您,密码修改成功!";
            ViewData["Message1"] = "登录页面";
            ViewData["Url"] = "/Member/Login";
            return View("Message");
        }
    }
}
