/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionHelper {
    private CollectionHelper() {
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> newHashMap(int size) {
        return new HashMap(size);
    }

    public static <T> HashSet<T> newHashSet() {
        return new HashSet();
    }

    public static <T> HashSet<T> newHashSet(int size) {
        return new HashSet(size);
    }

    public static <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }

    public static <T> ArrayList<T> newArrayList(int size) {
        return new ArrayList(size);
    }

    public static <T> ArrayList<T> newArrayList(Iterable<T> ... iterables) {
        ArrayList<T> resultList = CollectionHelper.newArrayList();
        for (Iterable<T> oneIterable : iterables) {
            for (T oneElement : oneIterable) {
                resultList.add(oneElement);
            }
        }
        return resultList;
    }

    public static <T> Set<T> asSet(T ... ts) {
        return new HashSet<T>(Arrays.asList(ts));
    }

    public static <K, V> Map<K, List<V>> partition(List<V> list, Partitioner<K, V> partitioner) {
        HashMap theValue = CollectionHelper.newHashMap();
        for (V v : list) {
            K key = partitioner.getPartition(v);
            ArrayList partition = (ArrayList)theValue.get(key);
            if (partition == null) {
                partition = CollectionHelper.newArrayList();
                theValue.put(key, partition);
            }
            partition.add(v);
        }
        return theValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Partitioner<K, V> {
        public K getPartition(V var1);
    }
}

