/*
 * Decompiled with CFR 0.152.
 */
package com.blade;

import com.blade.Environment;
import com.blade.event.Event;
import com.blade.event.EventListener;
import com.blade.event.EventManager;
import com.blade.event.EventType;
import com.blade.ioc.Ioc;
import com.blade.ioc.SimpleIoc;
import com.blade.kit.Assert;
import com.blade.kit.BladeKit;
import com.blade.kit.StringKit;
import com.blade.kit.reload.FileChangeDetector;
import com.blade.loader.BladeLoader;
import com.blade.mvc.Const;
import com.blade.mvc.handler.DefaultExceptionHandler;
import com.blade.mvc.handler.ExceptionHandler;
import com.blade.mvc.handler.WebSocketHandler;
import com.blade.server.Server;
import com.blade.server.netty.NettyServer;
import com.zeto.Zen;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.BindException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardWatchEventKinds;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Blade {
    private static final Logger log = LoggerFactory.getLogger(Blade.class);
    private List<BladeLoader> loaders = new ArrayList<BladeLoader>();
    private Set<String> packages = new LinkedHashSet<String>(Const.PLUGIN_PACKAGE_NAME);
    private Set<String> statics = new HashSet<String>(Const.DEFAULT_STATICS);
    private Ioc ioc = new SimpleIoc();
    private EventManager eventManager = new EventManager();
    private CountDownLatch latch = new CountDownLatch(1);
    private Server server = new NettyServer();
    private Environment environment = Environment.empty();
    private Consumer<Exception> startupExceptionHandler = e -> log.error("Start blade failed", (Throwable)e);
    private ExceptionHandler exceptionHandler = new DefaultExceptionHandler();
    private boolean started = false;
    private Class<?> bootClass = null;
    private String bannerText;
    private String threadName;

    public static Blade of() {
        return new Blade();
    }

    public Ioc ioc() {
        return this.ioc;
    }

    public Blade register(@NonNull Object bean) {
        if (bean == null) {
            throw new NullPointerException("bean is marked non-null but is null");
        }
        this.ioc.addBean(bean);
        return this;
    }

    public Blade register(@NonNull Class<?> cls) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        this.ioc.addBean(cls);
        return this;
    }

    public <T> T getBean(@NonNull Class<T> cls) {
        if (cls == null) {
            throw new NullPointerException("cls is marked non-null but is null");
        }
        return this.ioc.getBean(cls);
    }

    public ExceptionHandler exceptionHandler() {
        return this.exceptionHandler;
    }

    public Blade exceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    public boolean devMode() {
        return this.environment.getBoolean("app.devMode", false);
    }

    public Blade devMode(boolean devMode) {
        this.environment.set("app.devMode", devMode);
        return this;
    }

    public boolean isAutoRefreshDir() {
        return this.environment.get("app.auto.refresh.dir").isPresent();
    }

    public void setAutoRefreshDir(String dir) {
        this.environment.set("app.auto.refresh.dir", dir);
    }

    public Class<?> bootClass() {
        return this.bootClass;
    }

    public Set<String> getStatics() {
        return this.statics;
    }

    public Blade webSocket(@NonNull String path, @NonNull WebSocketHandler handler) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (handler == null) {
            throw new NullPointerException("handler is marked non-null but is null");
        }
        return this;
    }

    public Blade scanPackages(String ... packages) {
        if (packages == null) {
            throw new NullPointerException("packages is marked non-null but is null");
        }
        this.packages.addAll(Arrays.asList(packages));
        return this;
    }

    public Set<String> scanPackages() {
        return this.packages;
    }

    public Blade bootConf(@NonNull String bootConf) {
        if (bootConf == null) {
            throw new NullPointerException("bootConf is marked non-null but is null");
        }
        this.environment.set("boot_conf", bootConf);
        return this;
    }

    @Deprecated
    public Blade environment(@NonNull String key, @NonNull Object value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.environment.set(key, value);
        return this;
    }

    public Environment environment() {
        return this.environment;
    }

    public Optional<String> env(String key) {
        return this.environment.get(key);
    }

    public String env(String key, String defaultValue) {
        return this.environment.get(key, defaultValue);
    }

    public Blade listen(int port) {
        Assert.greaterThan(port, 0.0, "server port not is negative number.");
        this.environment.set("server.port", port);
        return this;
    }

    public Blade listen(@NonNull String address, int port) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        Assert.greaterThan(port, 0.0, "server port not is negative number.");
        this.environment.set("server.address", address);
        this.environment.set("server.port", port);
        return this;
    }

    public Blade appName(@NonNull String appName) {
        if (appName == null) {
            throw new NullPointerException("appName is marked non-null but is null");
        }
        this.environment.set("app.name", appName);
        return this;
    }

    public Blade event(@NonNull EventType eventType, @NonNull EventListener eventListener) {
        if (eventType == null) {
            throw new NullPointerException("eventType is marked non-null but is null");
        }
        if (eventListener == null) {
            throw new NullPointerException("eventListener is marked non-null but is null");
        }
        this.eventManager.addEventListener(eventType, eventListener);
        return this;
    }

    public Blade on(@NonNull EventType eventType, @NonNull EventListener eventListener) {
        if (eventType == null) {
            throw new NullPointerException("eventType is marked non-null but is null");
        }
        if (eventListener == null) {
            throw new NullPointerException("eventListener is marked non-null but is null");
        }
        this.eventManager.addEventListener(eventType, eventListener);
        return this;
    }

    public Blade addLoader(@NonNull BladeLoader loader) {
        if (loader == null) {
            throw new NullPointerException("loader is marked non-null but is null");
        }
        this.loaders.add(loader);
        return this;
    }

    public List<BladeLoader> loaders() {
        return this.loaders;
    }

    public EventManager eventManager() {
        return this.eventManager;
    }

    public Blade watchEnvChange(boolean watchEnvChange) {
        this.environment.set("app.watch-env", watchEnvChange);
        return this;
    }

    public Blade start(Class<?> mainCls, String ... args) {
        try {
            this.loadConfig(args);
            this.bootClass = mainCls;
            this.eventManager.fireEvent(EventType.SERVER_STARTING, new Event().attribute("blade", this));
            Thread thread = new Thread(() -> {
                try {
                    this.server.start(this);
                    this.latch.countDown();
                    this.server.join();
                }
                catch (BindException e) {
                    log.error("Bind address error\n", (Throwable)e);
                    System.exit(0);
                }
                catch (Exception e) {
                    this.startupExceptionHandler.accept(e);
                }
            });
            String threadName = null != this.threadName ? this.threadName : this.environment.get("app.thread-name", null);
            threadName = null != threadName ? threadName : "_(:3\u300d\u2220)_";
            thread.setName(threadName);
            thread.start();
            this.started = true;
            Thread resourceFilesRefreshThread = new Thread(() -> {
                try {
                    FileChangeDetector fileChangeDetector = new FileChangeDetector(this.environment.get("app.auto.refresh.dir").get());
                    fileChangeDetector.processEvent((event, filePath) -> {
                        try {
                            if (event.equals(StandardWatchEventKinds.ENTRY_MODIFY)) {
                                Path destPath = FileChangeDetector.getDestPath(filePath, this.environment);
                                Files.copy(filePath, destPath, StandardCopyOption.REPLACE_EXISTING);
                            }
                        }
                        catch (IOException e) {
                            log.error("Exception when trying to copy updated file");
                            this.startupExceptionHandler.accept(e);
                        }
                    });
                }
                catch (IOException e) {
                    this.startupExceptionHandler.accept(e);
                }
            });
            if (this.devMode() && this.isAutoRefreshDir()) {
                resourceFilesRefreshThread.start();
            }
        }
        catch (Exception e) {
            this.startupExceptionHandler.accept(e);
        }
        return this;
    }

    @Deprecated
    public Blade start(Class<?> bootClass, @NonNull String address, int port, String ... args) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        return this;
    }

    public Blade await() {
        if (!this.started) {
            throw new IllegalStateException("Server hasn't been started. Call start() before calling this method.");
        }
        try {
            this.latch.await();
        }
        catch (Exception e) {
            log.error("Blade start await error", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return this;
    }

    public void stop() {
        Zen.distory();
        this.eventManager.fireEvent(EventType.SERVER_STOPPING, new Event().attribute("blade", this));
        this.server.stopAndWait();
        this.eventManager.fireEvent(EventType.SERVER_STOPPED, new Event().attribute("blade", this));
    }

    public String bannerText() {
        if (null != this.bannerText) {
            return this.bannerText;
        }
        String bannerPath = this.environment.get("app.banner-path", null);
        if (StringKit.isEmpty(bannerPath) || Files.notExists(Paths.get(bannerPath, new String[0]), new LinkOption[0])) {
            return null;
        }
        try {
            BufferedReader bufferedReader = Files.newBufferedReader(Paths.get(bannerPath, new String[0]));
            this.bannerText = bufferedReader.lines().collect(Collectors.joining("\r\n"));
        }
        catch (Exception e) {
            log.error("Load Start Banner file error", (Throwable)e);
        }
        return this.bannerText;
    }

    public Blade threadName(String threadName) {
        this.threadName = threadName;
        return this;
    }

    public Blade contextPath(String contextPath) {
        this.environment.set("app.context-path", contextPath);
        return this;
    }

    private void loadConfig(String[] args) {
        Map<String, String> argsMap;
        String bootConf = this.environment().get("boot_conf", "classpath:application.properties");
        Environment bootEnv = Environment.of(bootConf);
        String envName = "default";
        if (null == bootEnv || bootEnv.isEmpty()) {
            bootEnv = Environment.of("classpath:app.properties");
        }
        if (!Objects.requireNonNull(bootEnv).isEmpty()) {
            Map<String, String> bootEnvMap = bootEnv.toMap();
            Set<Map.Entry<String, String>> entrySet = bootEnvMap.entrySet();
            entrySet.forEach(entry -> this.environment.set((String)entry.getKey(), entry.getValue()));
        }
        if (StringKit.isNotEmpty((argsMap = BladeKit.parseArgs(args)).get("app.env"))) {
            envName = argsMap.get("app.env");
            String evnFileName = "application-" + envName + ".properties";
            Environment customEnv = Environment.of(evnFileName);
            if (customEnv != null && !customEnv.isEmpty()) {
                customEnv.props().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.environment.set(key.toString(), value)));
            } else {
                evnFileName = "app-" + envName + ".properties";
                customEnv = Environment.of(evnFileName);
                if (customEnv != null && !customEnv.isEmpty()) {
                    for (Map.Entry<Object, Object> next : customEnv.props().entrySet()) {
                        this.environment.set(next.getKey().toString(), next.getValue());
                    }
                }
            }
            argsMap.remove("app.env");
        }
        this.environment.set("app.env", envName);
        this.register(this.environment);
        if (BladeKit.isEmpty(args)) {
            return;
        }
        for (Map.Entry<String, String> next : argsMap.entrySet()) {
            this.environment.set(next.getKey(), next.getValue());
        }
    }

    private Blade() {
    }
}

