/*
 * Decompiled with CFR 0.152.
 */
package com.blade.kit;

import com.google.common.base.Strings;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public final class DateKit {
    private static final String pattern = "yyyy-MM-dd HH:mm:ss";
    private static final String simplePattern = "yyyy-MM-dd";
    private static final int spanLength = 12;
    public static final DateTimeFormatter GMT_FMT = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    private static final ZoneId GMT_ZONE_ID = ZoneId.of("GMT");

    public static String gmtDate() {
        return GMT_FMT.format(LocalDateTime.now().atZone(GMT_ZONE_ID));
    }

    public static String gmtDate(LocalDateTime localDateTime) {
        return GMT_FMT.format(localDateTime.atZone(GMT_ZONE_ID));
    }

    public static String gmtDate(Date date) {
        return GMT_FMT.format(LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()).atZone(GMT_ZONE_ID));
    }

    public static String toString(long unixTime, String pattern) {
        return Instant.ofEpochSecond(unixTime).atZone(ZoneId.systemDefault()).format(DateTimeFormatter.ofPattern(pattern));
    }

    public static String toString(long date) {
        return DateKit.toString(date, pattern);
    }

    public static String toShortString(long date) {
        return DateKit.toString(date, simplePattern);
    }

    public static String toString(Date date) {
        long time = date.getTime() / 1000L;
        return DateKit.toString(time, pattern);
    }

    public static String toString(Date date, String pattern) {
        long time = date.getTime() / 1000L;
        return DateKit.toString(time, pattern);
    }

    public static long toDate(String time) {
        LocalDateTime formatted;
        if (Strings.isNullOrEmpty((String)time)) {
            return 0L;
        }
        if (time.length() > 12) {
            formatted = LocalDateTime.parse(time, DateTimeFormatter.ofPattern(pattern));
        } else {
            LocalDate localDate = LocalDate.parse(time, DateTimeFormatter.ofPattern(simplePattern));
            formatted = localDate.atStartOfDay();
        }
        return formatted.atZone(ZoneId.systemDefault()).toInstant().getEpochSecond();
    }

    public static long now() {
        return Instant.now().getEpochSecond();
    }

    public static long today() {
        Calendar calendar = DateKit.getCalendar();
        Date start = calendar.getTime();
        return start.getTime() / 1000L;
    }

    public static long today(int span) {
        return DateKit.today() + (long)(span * 3600 * 24);
    }

    public static long month() {
        Calendar calendar = DateKit.getCalendar();
        calendar.set(5, 0);
        Date start = calendar.getTime();
        return start.getTime() / 1000L;
    }

    public static long month(int month) {
        if (--month < 0 || month > 11) {
            return 0L;
        }
        Calendar calendar = DateKit.getCalendar();
        calendar.set(5, month);
        Date start = calendar.getTime();
        return start.getTime() / 1000L;
    }

    public static long week() {
        Calendar calendar = DateKit.getCalendar();
        calendar.set(7, 2);
        Date start = calendar.getTime();
        return start.getTime() / 1000L;
    }

    private static Calendar getCalendar() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar;
    }

    private DateKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

