/*
 * Decompiled with CFR 0.152.
 */
package com.blade.kit;

import com.blade.kit.GsonKit;
import com.blade.kit.reload.HttpClientFactory;
import com.google.common.io.ByteStreams;
import com.zeto.ZenData;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpKit {
    private static final Logger log = LoggerFactory.getLogger(HttpKit.class);
    private static final int timeout = 8000;
    private static final int retryExecutionCount = 2;
    private static final int maxTotal = 100;
    private static final int maxPerRoute = 10;

    public static String get(String url) {
        return HttpKit.send(url, null, false);
    }

    public static String get(String url, ZenData params) {
        return HttpKit.send(url, params, false);
    }

    public static String post(String url, ZenData data) {
        return HttpKit.send(url, data, true);
    }

    public static Map<String, Object> getAsMap(String url) {
        String content = HttpKit.send(url, null, false);
        return GsonKit.parseMap(content);
    }

    public static Map<String, Object> getAsMap(String url, ZenData params) {
        String content = HttpKit.send(url, params, false);
        return GsonKit.parseMap(content);
    }

    public static Map<String, Object> postAsMap(String url, ZenData data) {
        String content = HttpKit.send(url, data, true);
        return GsonKit.parseMap(content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] download(String url) {
        RequestBuilder requestBuilder = RequestBuilder.get((String)url).addParameter("lang", "zh_CN");
        CloseableHttpClient httpClient = HttpClientFactory.createHttpClient(100, 10, 8000, 2);
        try {
            CloseableHttpResponse response = httpClient.execute(requestBuilder.build());
            HttpEntity entity = response.getEntity();
            InputStream inputStream = entity.getContent();
            byte[] in2b = ByteStreams.toByteArray((InputStream)inputStream);
            inputStream.close();
            byte[] byArray = in2b;
            return byArray;
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                log.error("download", (Throwable)e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String send(String url, ZenData params, boolean isPost) {
        RequestBuilder requestBuilder;
        if (isPost) {
            requestBuilder = RequestBuilder.post((String)url).addParameter("lang", "zh_CN");
            if (params != null) {
                ArrayList nvps = new ArrayList();
                for (String name : params.getKeys()) {
                    nvps.add(new BasicNameValuePair(name, params.get(name)));
                }
                try {
                    requestBuilder.setEntity((HttpEntity)new UrlEncodedFormEntity((List)nvps));
                }
                catch (UnsupportedEncodingException e) {
                    log.error("", (Throwable)e);
                    return null;
                }
            }
        } else {
            requestBuilder = RequestBuilder.get((String)url).addParameter("lang", "zh_CN");
            if (params != null) {
                for (String key : params.getKeys()) {
                    requestBuilder.addParameter(key, params.get(key));
                }
            }
        }
        HttpUriRequest httpUriRequest = requestBuilder.build();
        CloseableHttpClient httpClient = HttpClientFactory.createHttpClient(100, 10, 8000, 2);
        try {
            CloseableHttpResponse response = httpClient.execute(httpUriRequest);
            HttpEntity entity = response.getEntity();
            String string = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            return string;
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
            }
        }
        return null;
    }
}

