/*
 * Decompiled with CFR 0.152.
 */
package com.blade.kit;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOKit {
    private static final Logger log = LoggerFactory.getLogger(IOKit.class);

    public static void closeQuietly(Closeable closeable) {
        try {
            if (null == closeable) {
                return;
            }
            closeable.close();
        }
        catch (Exception e) {
            log.error("Close closeable error", (Throwable)e);
        }
    }

    public static String readToString(String file) throws IOException {
        return IOKit.readToString(Paths.get(file, new String[0]));
    }

    public static String readToString(BufferedReader bufferedReader) {
        return bufferedReader.lines().collect(Collectors.joining(System.lineSeparator()));
    }

    public static String readToString(Path path) throws IOException {
        BufferedReader bufferedReader = Files.newBufferedReader(path);
        return bufferedReader.lines().collect(Collectors.joining(System.lineSeparator()));
    }

    public static String readToString(InputStream input) throws IOException {
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(input, "UTF-8"));){
            String string = buffer.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }

    public static void copyFile(File source, File dest) throws IOException {
        try (FileChannel in = new FileInputStream(source).getChannel();
             FileChannel out = new FileOutputStream(dest).getChannel();){
            out.transferFrom(in, 0L, in.size());
        }
    }

    public static void compressGZIP(File input, File output) throws IOException {
        try (GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream(output));
             FileInputStream in = new FileInputStream(input);){
            int len;
            byte[] buffer = new byte[1024];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
        }
    }

    public static byte[] compressGZIP(byte[] data) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzip = new GZIPOutputStream(out);
            gzip.write(data);
            gzip.close();
            return out.toByteArray();
        }
        catch (IOException e) {
            log.error("gzip", (Throwable)e);
            return null;
        }
    }

    public static byte[] compressGZIP(String content) {
        return IOKit.compressGZIP(content, Charset.forName("utf-8"));
    }

    public static byte[] compressGZIP(String content, Charset charset) {
        if (content == null || content.length() == 0) {
            return null;
        }
        return IOKit.compressGZIP(content.getBytes(charset));
    }

    private IOKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

