/*
 * Decompiled with CFR 0.152.
 */
package com.blade.kit;

import com.blade.kit.GsonKit;
import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.zeto.ZenEnvironment;
import com.zeto.dal.DBHelper;
import com.zeto.executor.EnjoyExecutor;
import com.zeto.util.TemplateUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TemplateKit {
    private final String str;
    private final Map<String, Object> arguments = new HashMap<String, Object>();
    private static final Map<String, String> htmlCache = new HashMap<String, String>();

    private TemplateKit(String str) {
        this.str = str;
    }

    public static String loadSkin(String skinId, String path) {
        String sql = "select content from skin where name=? AND parentId=?";
        return TemplateKit.queryFromDB(sql, skinId, path);
    }

    public static void removeCache(String cacheKey) {
        EnjoyExecutor.removeCache(cacheKey);
    }

    public static String load(String templateId) {
        if (ZenEnvironment.isDev()) {
            String appName = ZenEnvironment.getAppName();
            return TemplateKit.loadFromDB(templateId, appName);
        }
        return TemplateKit.loadFromDisk(templateId);
    }

    public static String loadData(String parent, String filename, boolean isSkin) {
        String sql = isSkin ? "select data from skin where name=? AND parentId=?" : "select data from template where template_id=? AND app_name=?";
        return TemplateKit.queryFromDB(sql, parent, filename);
    }

    public static String loadFromDB(String templateId, String appName) {
        String sql = "select content from template where template_id=? AND app_name=?";
        return TemplateKit.queryFromDB(sql, appName, templateId);
    }

    public static Map<String, Object> getSkinBlocks(String skinId, String name) {
        String sql = "select blocks from skin where name=? AND parentId=?";
        String result = TemplateKit.queryFromDB(sql, skinId, name);
        if (Strings.isNullOrEmpty((String)result)) {
            return null;
        }
        return GsonKit.parseMap(result);
    }

    public static Map<String, Object> getTemplateBlocks(String name) {
        String sql = "select blocks from template where template_id=? AND app_name=?";
        String result = TemplateKit.queryFromDB(sql, ZenEnvironment.getAppName(), name);
        if (Strings.isNullOrEmpty((String)result)) {
            return null;
        }
        return GsonKit.parseMap(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String queryFromDB(String sql, String parent, String path) {
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        ResultSet resultSet = null;
        try {
            statement.setString(1, path);
            statement.setString(2, parent);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                String string = resultSet.getString(1);
                dbHelper.close(resultSet);
                return string;
            }
            dbHelper.close(resultSet);
        }
        catch (SQLException e) {
            dbHelper.close(e);
        }
        finally {
            dbHelper.close(resultSet);
        }
        return null;
    }

    public static String loadFromDisk(String path) {
        if (htmlCache.containsKey(path)) {
            return htmlCache.get(path);
        }
        String localPath = ZenEnvironment.getPath() + "/res/" + path;
        File file = new File(localPath);
        if (!file.exists()) {
            return "404";
        }
        try {
            List lines = Files.readLines((File)file, (Charset)Charsets.UTF_8);
            String content = TemplateUtil.setMode(String.join((CharSequence)"", lines));
            htmlCache.put(path, content);
            return content;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static TemplateKit create(String name) {
        String content;
        if (ZenEnvironment.isLocalApp()) {
            String path = ZenEnvironment.getPath() + "/res" + name;
            content = TemplateKit.loadFromDisk(path);
        } else {
            content = TemplateKit.loadFromDisk(name);
        }
        return new TemplateKit(content);
    }

    public TemplateKit put(String name, Object value) {
        this.arguments.put(name, value);
        return this;
    }

    public TemplateKit put(Map<String, Object> args) {
        for (String key : args.keySet()) {
            this.arguments.put(key, args.get(key));
        }
        return this;
    }

    public String render() {
        StringBuilder result = new StringBuilder(this.str.length());
        StringBuilder param = new StringBuilder(16);
        State state = State.FREE_TEXT;
        block6: for (int i = 0; i < this.str.length(); ++i) {
            char chr = this.str.charAt(i);
            state = this.nextState(state, i);
            switch (state) {
                case FREE_TEXT: {
                    result.append(chr);
                    continue block6;
                }
                case PARAM_START: {
                    ++i;
                    continue block6;
                }
                case PARAM: {
                    param.append(chr);
                    continue block6;
                }
                case PARAM_END: {
                    this.appendParamValue(param, result);
                    continue block6;
                }
            }
        }
        return result.toString();
    }

    private State nextState(State currentState, int i) {
        switch (currentState) {
            case FREE_TEXT: {
                return TemplateKit.jumpFromFreeText(this.str, i);
            }
            case PARAM_START: {
                return TemplateKit.jumpFromParamStart(this.str, i);
            }
            case PARAM: {
                return TemplateKit.jumpFromParam(this.str, i);
            }
            case PARAM_END: {
                return TemplateKit.jumpFromParamEnd(this.str, i);
            }
            case ESCAPE_CHAR: {
                return State.FREE_TEXT;
            }
        }
        return State.FREE_TEXT;
    }

    private void appendParamValue(StringBuilder param, StringBuilder result) {
        String objectName = TemplateKit.takeUntilDotOrEnd(param);
        Object objectValue = this.arguments.get(objectName);
        Object toAppend = param.length() != 0 ? TemplateKit.valueInChain(objectValue, param) : TemplateKit.evaluateIfArray(objectValue);
        if (null != toAppend) {
            result.append(toAppend);
        }
    }

    private static Object evaluateIfArray(Object o) {
        if (null != o && o.getClass().isArray()) {
            return TemplateKit.arrayToString(o);
        }
        return o;
    }

    private static String arrayToString(Object array) {
        StringBuilder buff = new StringBuilder("[");
        for (int i = 0; i < Array.getLength(array); ++i) {
            buff.append(Array.get(array, i)).append(", ");
        }
        return TemplateKit.clearLastComma(buff).append("]").toString();
    }

    private static StringBuilder clearLastComma(StringBuilder buff) {
        int lastComma = buff.lastIndexOf(", ");
        if (-1 != lastComma) {
            buff.delete(lastComma, buff.length());
        }
        return buff;
    }

    private static String takeUntilDotOrEnd(StringBuilder buff) {
        String result;
        int firstPointIdx = buff.indexOf(".");
        if (-1 == firstPointIdx) {
            result = buff.toString();
            buff.setLength(0);
        } else {
            result = buff.substring(0, firstPointIdx);
            buff.delete(0, firstPointIdx + 1);
        }
        return result;
    }

    private static Object valueInChain(Object object, StringBuilder paramBuffer) {
        if (object == null || paramBuffer.length() == 0) {
            return TemplateKit.evaluateIfArray(object);
        }
        String methodName = TemplateKit.takeUntilDotOrEnd(paramBuffer);
        try {
            Object newObject;
            if (object instanceof Map) {
                newObject = ((Map)object).get(methodName);
            } else {
                Method method = TemplateKit.getMethodOrGetter(object, methodName);
                if (null == method) {
                    return null;
                }
                newObject = method.invoke(object, new Object[0]);
            }
            return TemplateKit.valueInChain(newObject, paramBuffer);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return null;
        }
    }

    private static Method getMethodOrGetter(Object object, String methodName) {
        Method method;
        try {
            method = object.getClass().getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                String capital = methodName.substring(0, 1).toUpperCase();
                String nameCapitalized = "get" + capital + methodName.substring(1);
                method = object.getClass().getMethod(nameCapitalized, new Class[0]);
            }
            catch (NoSuchMethodException e1) {
                return null;
            }
        }
        return method;
    }

    private static State jumpFromFreeText(String fmt, int idx) {
        if (TemplateKit.isEscapeChar(fmt, idx)) {
            return State.ESCAPE_CHAR;
        }
        if (TemplateKit.isParamStart(fmt, idx)) {
            return State.PARAM_START;
        }
        return State.FREE_TEXT;
    }

    private static State jumpFromParamStart(String fmt, int idx) {
        if (TemplateKit.isParamEnd(fmt, idx)) {
            return State.PARAM_END;
        }
        return State.PARAM;
    }

    private static State jumpFromParam(String fmt, int idx) {
        if (TemplateKit.isParamEnd(fmt, idx)) {
            return State.PARAM_END;
        }
        return State.PARAM;
    }

    private static State jumpFromParamEnd(String fmt, int idx) {
        if (TemplateKit.isEscapeChar(fmt, idx)) {
            return State.ESCAPE_CHAR;
        }
        if (TemplateKit.isParamStart(fmt, idx)) {
            return State.PARAM_START;
        }
        return State.FREE_TEXT;
    }

    private static boolean isParamStart(String fmt, int idx) {
        return '$' == fmt.charAt(idx) && idx + 1 < fmt.length() && '{' == fmt.charAt(idx + 1);
    }

    private static boolean isParamEnd(String fmt, int idx) {
        return '}' == fmt.charAt(idx);
    }

    private static boolean isEscapeChar(String fmt, int idx) {
        return '`' == fmt.charAt(idx);
    }

    protected static enum State {
        FREE_TEXT,
        PARAM,
        PARAM_START,
        PARAM_END,
        ESCAPE_CHAR;

    }
}

