/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc;

import com.blade.Blade;
import com.blade.Environment;
import com.blade.mvc.http.Request;
import com.blade.mvc.http.Response;
import com.blade.server.netty.HttpServerHandler;
import com.zeto.ZenEnvironment;
import com.zeto.domain.ZenSite;
import io.netty.channel.ChannelHandlerContext;
import java.util.Optional;

public class WebContext {
    private static Blade blade;
    private static String contextPath;
    private static String sessionKey;
    private Request request;
    private Response response;
    private ChannelHandlerContext channelHandlerContext;
    private ZenSite zenSite;

    public void setZenSite(ZenSite app) {
        this.zenSite = app;
    }

    public ZenSite getZenSite() {
        return this.zenSite;
    }

    public WebContext(Request request, Response response, ChannelHandlerContext channelHandlerContext) {
        this.request = request;
        this.response = response;
        this.channelHandlerContext = channelHandlerContext;
    }

    public String getAppNameFromRequest() {
        String host = this.getRequest().host();
        int idx = host.indexOf("-");
        if (idx == -1) {
            return ZenEnvironment.getAppName();
        }
        return host.substring(0, idx);
    }

    public Request getRequest() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }

    public Environment environment() {
        return blade.environment();
    }

    public static String sessionKey() {
        return sessionKey;
    }

    public Optional<String> env(String key) {
        return WebContext.blade().env(key);
    }

    public String env(String key, String defaultValue) {
        return WebContext.blade().env(key, defaultValue);
    }

    public ChannelHandlerContext getChannelHandlerContext() {
        return this.channelHandlerContext;
    }

    public ChannelHandlerContext getHandlerContext() {
        return this.channelHandlerContext;
    }

    public static void init(Blade blade, String contextPath) {
        WebContext.blade = blade;
        WebContext.contextPath = contextPath;
        sessionKey = blade.environment().get("http.session.key", "SESSION");
    }

    public static WebContext get() {
        return (WebContext)HttpServerHandler.WEB_CONTEXT_THREAD_LOCAL.get();
    }

    public static Request request() {
        WebContext webContext = WebContext.get();
        return null != webContext ? webContext.request : null;
    }

    public static Response response() {
        WebContext webContext = WebContext.get();
        return null != webContext ? webContext.response : null;
    }

    public static void create(ZenSite site) {
        WebContext webContext = new WebContext();
        webContext.setZenSite(site);
        HttpServerHandler.WEB_CONTEXT_THREAD_LOCAL.set((Object)webContext);
    }

    public static WebContext create(Request request, Response response, ChannelHandlerContext ctx) {
        WebContext webContext = new WebContext();
        webContext.request = request;
        webContext.response = response;
        webContext.channelHandlerContext = ctx;
        HttpServerHandler.WEB_CONTEXT_THREAD_LOCAL.set((Object)webContext);
        return webContext;
    }

    public static void set(WebContext webContext) {
        HttpServerHandler.WEB_CONTEXT_THREAD_LOCAL.set((Object)webContext);
    }

    public static void remove() {
        HttpServerHandler.WEB_CONTEXT_THREAD_LOCAL.remove();
    }

    public static Blade blade() {
        return blade;
    }

    public static String contextPath() {
        return contextPath;
    }

    public static void clean() {
        HttpServerHandler.WEB_CONTEXT_THREAD_LOCAL.remove();
        blade = null;
    }

    public WebContext() {
    }
}

