/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.handler;

import com.blade.Blade;
import com.blade.exception.BladeException;
import com.blade.exception.ValidatorException;
import com.blade.kit.BladeCache;
import com.blade.kit.BladeKit;
import com.blade.mvc.WebContext;
import com.blade.mvc.handler.ExceptionHandler;
import com.blade.mvc.http.Request;
import com.blade.mvc.http.Response;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExceptionHandler
implements ExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(DefaultExceptionHandler.class);

    @Override
    public void handle(Exception e) {
        if (!ExceptionHandler.isResetByPeer(e)) {
            Response response = WebContext.response();
            Request request = WebContext.request();
            if (e instanceof BladeException) {
                this.handleBladeException((BladeException)e, request, response);
            } else if (ValidatorException.class.isInstance(e)) {
                this.handleValidators((ValidatorException)ValidatorException.class.cast(e), request, response);
            } else {
                this.handleException(e, request, response);
            }
        }
    }

    protected void handleValidators(ValidatorException validatorException, Request request, Response response) {
        this.handleException(validatorException, request, response);
    }

    protected void handleException(Exception e, Request request, Response response) {
        log.error("", (Throwable)e);
        if (null == response) {
            return;
        }
        response.status(500);
        request.attribute("title", "500 Internal Server Error");
        request.attribute("message", e.getMessage());
        request.attribute("stackTrace", this.getStackTrace(e));
        this.render500(request, response);
    }

    protected void handleBladeException(BladeException e, Request request, Response response) {
        response.status(e.getStatus());
        if (null != e.getCause()) {
            request.attribute("stackTrace", this.getStackTrace(e));
        }
        if (e.getStatus() == 500) {
            log.error("", (Throwable)e);
            this.render500(request, response);
        }
        String paddingMethod = BladeCache.getPaddingMethod(request.method());
        if (e.getStatus() == 405) {
            BladeKit.log405(log, paddingMethod, request.uri());
            response.text(e.getMessage());
        }
    }

    protected void render500(Request request, Response response) {
        Blade blade = WebContext.blade();
        response.html("<center><h1>500 Internal Server Error</h1><hr/></center>");
    }

    protected String getStackTrace(Throwable exception) {
        StringWriter errors = new StringWriter();
        exception.printStackTrace(new PrintWriter(errors));
        return errors.toString();
    }
}

