/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.handler;

import com.blade.kit.DateKit;
import com.blade.kit.StringKit;
import com.blade.mvc.http.BodyWriter;
import com.blade.mvc.http.RawBody;
import com.blade.mvc.http.Request;
import com.blade.mvc.http.Response;
import com.blade.mvc.multipart.MimeType;
import com.blade.server.netty.HttpConst;
import com.blade.server.netty.HttpServerInitializer;
import com.blade.server.netty.ProgressiveFutureListener;
import com.zeto.ZenEnvironment;
import com.zeto.util.TemplateUtil;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseHandler {
    private static final Logger log = LoggerFactory.getLogger(ResponseHandler.class);
    private static final int HTTP_CACHE_SECONDS = 120;
    private static final String AVATOR_PATH = "/avator";
    private static final String UPLOAD_PATH = "/upload";
    private static final String CONTENT_TYPE = "text/html;charset=utf-8";

    public FullHttpResponse handleResponse(final Request request, final Response response, final ChannelHandlerContext context) {
        FullHttpResponse fullHttpResponse = response.body().write(new BodyWriter(){

            @Override
            public FullHttpResponse onByteBuf(ByteBuf byteBuf) {
                return ResponseHandler.this.createResponseByByteBuf(response, byteBuf);
            }

            @Override
            public FullHttpResponse onStream(Closeable closeable) {
                return null;
            }

            @Override
            public FullHttpResponse onRawBody(RawBody body) {
                return body.httpResponse();
            }

            @Override
            public FullHttpResponse onByteBuf(Object byteBuf) {
                DefaultHttpResponse httpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)response.statusCode()));
                for (Map.Entry<String, String> next : response.headers().entrySet()) {
                    httpResponse.headers().set(next.getKey(), (Object)next.getValue());
                }
                if (request.keepAlive()) {
                    httpResponse.headers().set((CharSequence)HttpConst.CONNECTION, (Object)HttpConst.KEEP_ALIVE);
                }
                context.write((Object)httpResponse, context.voidPromise());
                ChannelFuture lastContentFuture = context.writeAndFlush(byteBuf);
                if (!request.keepAlive()) {
                    lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                }
                return null;
            }
        });
        if (request.keepAlive()) {
            fullHttpResponse.headers().set((CharSequence)HttpConst.CONNECTION, (Object)HttpConst.KEEP_ALIVE);
        }
        return fullHttpResponse;
    }

    private void setDefaultHeaders(HttpHeaders headers) {
        headers.set((CharSequence)HttpConst.DATE, (Object)HttpServerInitializer.date);
        headers.set((CharSequence)HttpConst.X_POWER_BY, (Object)HttpConst.HEADER_VERSION);
    }

    public boolean staticFile(ChannelHandlerContext ctx, Request request) {
        long fileLength;
        RandomAccessFile raf;
        String path;
        String uri = request.uri();
        String ext = StringKit.fileExt(uri);
        String contentType = MimeType.get(ext);
        boolean isGzip = false;
        if (uri.startsWith(AVATOR_PATH)) {
            path = ZenEnvironment.getPath() + UPLOAD_PATH + uri;
        } else if (uri.startsWith(UPLOAD_PATH)) {
            path = ZenEnvironment.getPath() + uri;
        } else {
            if (uri.contains(ZenEnvironment.getTag())) {
                uri = uri.substring(ZenEnvironment.getTag().length() + 1);
            }
            path = ZenEnvironment.getPath() + TemplateUtil.getPrefix() + uri;
            if ("js".equals(ext) || "css".equals(ext) || "xml".equals(ext)) {
                path = path + ".gz";
                isGzip = true;
            }
        }
        File file = new File(path);
        if (file.isHidden() || !file.exists()) {
            return false;
        }
        try {
            raf = new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException ignore) {
            return false;
        }
        try {
            fileLength = raf.length();
        }
        catch (IOException e) {
            return false;
        }
        DefaultHttpResponse httpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        if (request.keepAlive()) {
            httpResponse.headers().set((CharSequence)HttpConst.CONNECTION, (Object)HttpConst.KEEP_ALIVE);
        }
        if (contentType != null) {
            httpResponse.headers().set((CharSequence)HttpConst.CONTENT_TYPE, (Object)contentType);
        }
        this.setDateAndCacheHeaders((HttpResponse)httpResponse, file);
        if (isGzip) {
            httpResponse.headers().set("Content-Encoding", (Object)"gzip");
        }
        httpResponse.headers().set((CharSequence)HttpConst.CONTENT_LENGTH, (Object)fileLength);
        ctx.write((Object)httpResponse);
        ChannelFuture sendFileFuture = ctx.write((Object)new DefaultFileRegion(raf.getChannel(), 0L, fileLength), (ChannelPromise)ctx.newProgressivePromise());
        ChannelFuture lastContentFuture = ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        sendFileFuture.addListener((GenericFutureListener)ProgressiveFutureListener.build(raf));
        if (!request.keepAlive()) {
            lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        return true;
    }

    private void setDateAndCacheHeaders(HttpResponse response, File fileToCache) {
        LocalDateTime localTime = LocalDateTime.now();
        String date = DateKit.gmtDate(localTime);
        response.headers().set((CharSequence)HttpConst.DATE, (Object)date);
        String lastModifed = date;
        LocalDateTime newTime = localTime.plusSeconds(120L);
        date = DateKit.gmtDate(newTime);
        response.headers().set((CharSequence)HttpConst.EXPIRES, (Object)date);
        response.headers().set((CharSequence)HttpConst.CACHE_CONTROL, (Object)"private, max-age=120");
        if (null != fileToCache) {
            lastModifed = DateKit.gmtDate(new Date(fileToCache.lastModified()));
        }
        response.headers().set((CharSequence)HttpConst.LAST_MODIFIED, (Object)lastModifed);
    }

    private FullHttpResponse createResponseByByteBuf(Response response, ByteBuf byteBuf) {
        Map<String, String> headers = response.headers();
        DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)response.statusCode()), byteBuf);
        httpResponse.headers().set((CharSequence)HttpConst.CONTENT_LENGTH, (Object)httpResponse.content().readableBytes());
        this.setDefaultHeaders(httpResponse.headers());
        if (response.cookiesRaw().size() > 0) {
            this.appendCookie(response, httpResponse);
        }
        for (Map.Entry<String, String> next : headers.entrySet()) {
            httpResponse.headers().set((CharSequence)HttpConst.getAsciiString(next.getKey()), (Object)next.getValue());
        }
        return httpResponse;
    }

    private void appendCookie(Response response, DefaultFullHttpResponse httpResponse) {
        for (Cookie next : response.cookiesRaw()) {
            httpResponse.headers().add((CharSequence)HttpConst.SET_COOKIE, (Object)ServerCookieEncoder.LAX.encode(next));
        }
    }
}

