/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.http;

import com.blade.exception.NotFoundException;
import com.blade.kit.StringKit;
import com.blade.mvc.http.Body;
import com.blade.mvc.http.Cookie;
import com.blade.mvc.http.EmptyBody;
import com.blade.mvc.http.Response;
import com.blade.mvc.http.StreamBody;
import com.blade.mvc.wrapper.OutputStreamWrapper;
import com.blade.server.netty.HttpConst;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponse
implements Response {
    private static final Logger log = LoggerFactory.getLogger(HttpResponse.class);
    private Map<String, String> headers = new HashMap<String, String>();
    private Set<io.netty.handler.codec.http.cookie.Cookie> cookies = new HashSet<io.netty.handler.codec.http.cookie.Cookie>();
    private int statusCode = 200;
    private Body body;

    @Override
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    public Response status(int status) {
        this.statusCode = status;
        return this;
    }

    @Override
    public Response contentType(@NonNull String contentType) {
        if (contentType == null) {
            throw new NullPointerException("contentType is marked non-null but is null");
        }
        this.headers.put("Content-Type", contentType);
        return this;
    }

    @Override
    public String contentType() {
        return this.headers.get("Content-Type");
    }

    @Override
    public Map<String, String> headers() {
        return this.headers;
    }

    @Override
    public Response header(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    @Override
    public Response cookie(@NonNull Cookie cookie) {
        if (cookie == null) {
            throw new NullPointerException("cookie is marked non-null but is null");
        }
        DefaultCookie nettyCookie = new DefaultCookie(cookie.name(), cookie.value());
        if (cookie.domain() != null) {
            nettyCookie.setDomain(cookie.domain());
        }
        if (cookie.maxAge() > 0L) {
            nettyCookie.setMaxAge(cookie.maxAge());
        }
        nettyCookie.setPath(cookie.path());
        nettyCookie.setHttpOnly(cookie.httpOnly());
        nettyCookie.setSecure(cookie.secure());
        this.cookies.add((io.netty.handler.codec.http.cookie.Cookie)nettyCookie);
        return this;
    }

    @Override
    public Response cookie(String name, String value) {
        this.cookies.add((io.netty.handler.codec.http.cookie.Cookie)new DefaultCookie(name, value));
        return this;
    }

    @Override
    public Response cookie(@NonNull String name, @NonNull String value, int maxAge) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        DefaultCookie nettyCookie = new DefaultCookie(name, value);
        nettyCookie.setPath("/");
        nettyCookie.setMaxAge((long)maxAge);
        this.cookies.add((io.netty.handler.codec.http.cookie.Cookie)nettyCookie);
        return this;
    }

    @Override
    public Response cookie(@NonNull String name, @NonNull String value, int maxAge, boolean secured) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        DefaultCookie nettyCookie = new DefaultCookie(name, value);
        nettyCookie.setPath("/");
        nettyCookie.setMaxAge((long)maxAge);
        nettyCookie.setSecure(secured);
        this.cookies.add((io.netty.handler.codec.http.cookie.Cookie)nettyCookie);
        return this;
    }

    @Override
    public Response cookie(@NonNull String path, @NonNull String name, @NonNull String value, int maxAge, boolean secured) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        DefaultCookie nettyCookie = new DefaultCookie(name, value);
        nettyCookie.setMaxAge((long)maxAge);
        nettyCookie.setSecure(secured);
        nettyCookie.setPath(path);
        this.cookies.add((io.netty.handler.codec.http.cookie.Cookie)nettyCookie);
        return this;
    }

    @Override
    public Response removeCookie(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        Optional<io.netty.handler.codec.http.cookie.Cookie> cookieOpt = this.cookies.stream().filter(cookie -> cookie.name().equals(name)).findFirst();
        cookieOpt.ifPresent(cookie -> {
            cookie.setValue("");
            cookie.setMaxAge(-1L);
        });
        DefaultCookie nettyCookie = new DefaultCookie(name, "");
        nettyCookie.setMaxAge(-1L);
        this.cookies.add((io.netty.handler.codec.http.cookie.Cookie)nettyCookie);
        return this;
    }

    @Override
    public Map<String, String> cookies() {
        HashMap<String, String> map = new HashMap<String, String>(8);
        this.cookies.forEach(cookie -> map.put(cookie.name(), cookie.value()));
        return map;
    }

    @Override
    public Set<io.netty.handler.codec.http.cookie.Cookie> cookiesRaw() {
        return this.cookies;
    }

    @Override
    public void download(@NonNull String fileName, @NonNull File file) throws Exception {
        if (fileName == null) {
            throw new NullPointerException("fileName is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        if (!file.exists() || !file.isFile()) {
            throw new NotFoundException("Not found file: " + file.getPath());
        }
        String contentType = StringKit.mimeType(file.getName());
        this.headers.put("Content-Disposition", "attachment; filename=" + new String(fileName.getBytes("UTF-8"), "ISO8859_1"));
        this.headers.put(HttpConst.CONTENT_LENGTH.toString(), String.valueOf(file.length()));
        this.headers.put("Content-Type", contentType);
        this.body = new StreamBody(new FileInputStream(file));
    }

    @Override
    public OutputStreamWrapper outputStream() throws IOException {
        File file = Files.createTempFile("blade", ".temp", new FileAttribute[0]).toFile();
        FileOutputStream outputStream = new FileOutputStream(file);
        return new OutputStreamWrapper(outputStream, file);
    }

    @Override
    public void redirect(@NonNull String newUri) {
        if (newUri == null) {
            throw new NullPointerException("newUri is marked non-null but is null");
        }
        this.headers.put(HttpConst.LOCATION.toString(), newUri);
        this.status(302);
    }

    public HttpResponse(Response response) {
        this.statusCode = response.statusCode();
        if (null != response.headers()) {
            response.headers().forEach(this.headers::put);
        }
        if (null != response.cookies()) {
            response.cookies().forEach((k, v) -> this.cookies.add((io.netty.handler.codec.http.cookie.Cookie)new DefaultCookie(k, v)));
        }
    }

    public HttpResponse() {
    }

    @Override
    public Body body() {
        if (null == this.body) {
            return EmptyBody.empty();
        }
        return this.body;
    }

    @Override
    public Response body(Body body) {
        this.body = body;
        return this;
    }
}

