/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.http;

import com.blade.kit.GsonKit;
import com.blade.kit.StringKit;
import com.blade.kit.WebKit;
import com.blade.mvc.WebContext;
import com.blade.mvc.http.Cookie;
import com.blade.mvc.http.HttpMethod;
import com.blade.mvc.multipart.FileItem;
import com.zeto.ZenData;
import io.netty.buffer.ByteBuf;
import io.netty.util.CharsetUtil;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;

public interface Request {
    public String host();

    public String remoteAddress();

    public String uri();

    public String url();

    default public String userAgent() {
        return this.header("User-Agent");
    }

    public String protocol();

    default public String contextPath() {
        return WebContext.contextPath();
    }

    public Map<String, String> pathParams();

    default public String pathString(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.pathParams().get(name);
    }

    default public Integer pathInt(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        String val = this.pathString(name);
        return StringKit.isNotEmpty(val) ? Integer.valueOf(Integer.parseInt(val)) : null;
    }

    default public Long pathLong(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        String val = this.pathString(name);
        return StringKit.isNotEmpty(val) ? Long.valueOf(Long.parseLong(val)) : null;
    }

    public String queryString();

    public ZenData parameters();

    public String[] parameterNames();

    public String[] parameterValues(String var1);

    default public Optional<String> query(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        String values = this.parameters().get(name);
        if (null != values) {
            return Optional.of(values);
        }
        return Optional.empty();
    }

    default public String query(@NonNull String name, @NonNull String defaultValue) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        Optional<String> value = this.query(name);
        return value.orElse(defaultValue);
    }

    default public Optional<Integer> queryInt(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        Optional<String> value = this.query(name);
        return value.map(Integer::parseInt);
    }

    default public int queryInt(@NonNull String name, int defaultValue) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        Optional<String> value = this.query(name);
        return value.map(Integer::parseInt).orElse(defaultValue);
    }

    default public Optional<Long> queryLong(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        Optional<String> value = this.query(name);
        return value.map(Long::parseLong);
    }

    default public long queryLong(@NonNull String name, long defaultValue) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        Optional<String> value = this.query(name);
        return value.map(Long::parseLong).orElse(defaultValue);
    }

    default public Optional<Double> queryDouble(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        Optional<String> value = this.query(name);
        return value.map(Double::parseDouble);
    }

    default public double queryDouble(@NonNull String name, Double defaultValue) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        Optional<String> value = this.query(name);
        return value.map(Double::parseDouble).orElse(defaultValue);
    }

    default public Optional<Boolean> queryBoolean(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        Optional<String> value = this.query(name);
        return value.map(Boolean::valueOf);
    }

    default public boolean queryBoolean(@NonNull String name, Boolean defaultValue) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        Optional<String> value = this.query(name);
        return value.map(Boolean::valueOf).orElse(defaultValue);
    }

    public String method();

    public HttpMethod httpMethod();

    public boolean useGZIP();

    default public String address() {
        String address = WebKit.ipAddress(this);
        if (StringKit.isBlank(address) || "unknown".equalsIgnoreCase(address)) {
            address = this.remoteAddress().split(":")[0].substring(1);
        }
        if (StringKit.isBlank(address)) {
            address = "Unknown";
        }
        return address;
    }

    default public String contentType() {
        String contentType = this.header("Content-Type");
        return null != contentType ? contentType : "Unknown";
    }

    public boolean isSecure();

    default public boolean isAjax() {
        return "XMLHttpRequest".equals(this.header("X-Requested-With")) || "XMLHttpRequest".equals(this.header("x-requested-with"));
    }

    default public boolean isFormRequest() {
        return this.header("Content-Type").toLowerCase().contains("form");
    }

    default public boolean isJsonRequest() {
        return this.header("Content-Type").toLowerCase().contains("json");
    }

    default public boolean isIE() {
        String ua = this.userAgent();
        return ua.contains("MSIE") || ua.contains("TRIDENT");
    }

    public Map<String, Cookie> cookies();

    default public String cookie(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        Cookie cookie = this.cookies().get(name);
        return null != cookie ? cookie.value() : null;
    }

    public Cookie cookieRaw(String var1);

    default public String cookie(@NonNull String name, @NonNull String defaultValue) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        String cookie = this.cookie(name);
        return null != cookie ? cookie : defaultValue;
    }

    public Request cookie(Cookie var1);

    public Map<String, String> headers();

    default public String header(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        String header = "";
        if (this.headers().containsKey(name)) {
            header = this.headers().get(name);
        } else if (this.headers().containsKey(name.toLowerCase())) {
            header = this.headers().get(name.toLowerCase());
        }
        return header;
    }

    default public String header(@NonNull String name, @NonNull String defaultValue) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        String value = this.header(name);
        return value.length() > 0 ? value : defaultValue;
    }

    public boolean keepAlive();

    default public <T> T bindWithBody(Class<T> modelClass) {
        String json = this.bodyToString();
        return StringKit.isNotEmpty(json) ? (T)GsonKit.parse(json, modelClass) : null;
    }

    public Map<String, Object> attributes();

    default public Request attribute(@NonNull String name, Object value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.attributes().put(name, value);
        return this;
    }

    default public <T> T attribute(String name) {
        if (null == name) {
            return null;
        }
        Object object = this.attributes().get(name);
        return (T)(null != object ? object : null);
    }

    public Map<String, FileItem> fileItems();

    default public Optional<FileItem> fileItem(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return Optional.ofNullable(this.fileItems().get(name));
    }

    public boolean chunkIsEnd();

    public boolean isMultipart();

    public ByteBuf body();

    default public String bodyToString() {
        return this.body().toString(CharsetUtil.UTF_8);
    }
}

