/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.multipart;

import java.util.HashMap;
import java.util.Map;

public interface MimeType {
    public static final String APPLICATION = "application/octet-stream";
    public static final Map<String, String> mimeTypes = new HashMap<String, String>(){
        {
            this.put("kar", "audio/midi");
            this.put("mid", "audio/midi");
            this.put("midi", "audio/midi");
            this.put("aac", "audio/mp4");
            this.put("f4a", "audio/mp4");
            this.put("f4b", "audio/mp4");
            this.put("m4a", "audio/mp4");
            this.put("mp3", "audio/mpeg");
            this.put("oga", "audio/ogg");
            this.put("ogg", "audio/ogg");
            this.put("opus", "audio/ogg");
            this.put("ra", "audio/x-realaudio");
            this.put("wav", "audio/x-wav");
            this.put("bmp", "image/bmp");
            this.put("gif", "image/gif");
            this.put("jpeg", "image/jpeg");
            this.put("jpg", "image/jpeg");
            this.put("png", "image/png");
            this.put("svg", "image/svg+xml");
            this.put("svgz", "image/svg+xml");
            this.put("tif", "image/tiff");
            this.put("tiff", "image/tiff");
            this.put("wbmp", "image/vnd.wap.wbmp");
            this.put("webp", "image/webp");
            this.put("ico", "image/x-icon");
            this.put("cur", "image/x-icon");
            this.put("jng", "image/x-jng");
            this.put("js", "application/javascript; charset=utf-8");
            this.put("json", "application/json");
            this.put("webapp", "application/x-web-app-manifest+json");
            this.put("manifest", "text/cache-manifest");
            this.put("appcache", "text/cache-manifest");
            this.put("doc", "application/msword");
            this.put("xls", "application/vnd.ms-excel");
            this.put("ppt", "application/vnd.ms-powerpoint");
            this.put("docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
            this.put("xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            this.put("pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
            this.put("3gpp", "video/3gpp");
            this.put("3gp", "video/3gpp");
            this.put("mp4", "video/mp4");
            this.put("m4v", "video/mp4");
            this.put("f4v", "video/mp4");
            this.put("f4p", "video/mp4");
            this.put("mpeg", "video/mpeg");
            this.put("mpg", "video/mpeg");
            this.put("ogv", "video/ogg");
            this.put("mov", "video/quicktime");
            this.put("webm", "video/webm");
            this.put("flv", "video/x-flv");
            this.put("mng", "video/x-mng");
            this.put("asx", "video/x-ms-asf");
            this.put("asf", "video/x-ms-asf");
            this.put("wmv", "video/x-ms-wmv");
            this.put("avi", "video/x-msvideo");
            this.put("atom", "application/xml");
            this.put("rdf", "application/xml");
            this.put("rss", "application/xml");
            this.put("xml", "text/xml");
            this.put("woff", "application/font-woff");
            this.put("woff2", "application/font-woff2");
            this.put("eot", "application/vnd.ms-fontobject");
            this.put("ttc", "application/x-font-ttf");
            this.put("ttf", "application/x-font-ttf");
            this.put("otf", "font/opentype");
            this.put("jar", "application/java-archive");
            this.put("war", "application/java-archive");
            this.put("ear", "application/java-archive");
            this.put("hqx", "application/mac-binhex40");
            this.put("pdf", "application/pdf");
            this.put("ps", "application/postscript");
            this.put("eps", "application/postscript");
            this.put("ai", "application/postscript");
            this.put("rtf", "application/rtf");
            this.put("wmlc", "application/vnd.wap.wmlc");
            this.put("xhtml", "application/xhtml+xml");
            this.put("kml", "application/vnd.google-earth.kml+xml");
            this.put("kmz", "application/vnd.google-earth.kmz");
            this.put("7z", "application/x-7z-compressed");
            this.put("crx", "application/x-chrome-extension");
            this.put("oex", "application/x-opera-extension");
            this.put("xpi", "application/x-xpinstall");
            this.put("cco", "application/x-cocoa");
            this.put("jardiff", "application/x-java-archive-diff");
            this.put("jnlp", "application/x-java-jnlp-file");
            this.put("run", "application/x-makeself");
            this.put("pl", "application/x-perl");
            this.put("pm", "application/x-perl");
            this.put("prc", "application/x-pilot");
            this.put("pdb", "application/x-pilot");
            this.put("rar", "application/x-rar-compressed");
            this.put("rpm", "application/x-redhat-package-manager");
            this.put("sea", "application/x-sea");
            this.put("swf", "application/x-shockwave-flash");
            this.put("sit", "application/x-stuffit");
            this.put("tcl", "application/x-tcl");
            this.put("tk", "application/x-tcl");
            this.put("der", "application/x-x509-ca-cert");
            this.put("pem", "application/x-x509-ca-cert");
            this.put("crt", "application/x-x509-ca-cert");
            this.put("torrent", "application/x-bittorrent");
            this.put("zip", "application/zip");
            this.put("bin", MimeType.APPLICATION);
            this.put("exe", MimeType.APPLICATION);
            this.put("dll", MimeType.APPLICATION);
            this.put("deb", MimeType.APPLICATION);
            this.put("dmg", MimeType.APPLICATION);
            this.put("iso", MimeType.APPLICATION);
            this.put("img", MimeType.APPLICATION);
            this.put("msi", MimeType.APPLICATION);
            this.put("msp", MimeType.APPLICATION);
            this.put("msm", MimeType.APPLICATION);
            this.put("safariextz", MimeType.APPLICATION);
            this.put("css", "text/css; charset=utf-8");
            this.put("html", "text/html; charset=utf-8");
            this.put("htm", "text/html; charset=utf-8");
            this.put("shtml", "text/html");
            this.put("mml", "text/mathml");
            this.put("txt", "text/plain");
            this.put("jad", "text/vnd.sun.j2me.app-descriptor");
            this.put("wml", "text/vnd.wap.wml");
            this.put("vtt", "text/vtt");
            this.put("htc", "text/x-component");
            this.put("vcf", "text/x-vcard");
        }
    };

    public static String get(String ext) {
        if (mimeTypes.containsKey(ext)) {
            return mimeTypes.get(ext);
        }
        return APPLICATION;
    }
}

