/*
 * Decompiled with CFR 0.152.
 */
package com.blade.server.netty;

import com.blade.mvc.WebContext;
import com.blade.mvc.handler.ExceptionHandler;
import com.blade.mvc.handler.ResponseHandler;
import com.blade.mvc.http.HttpRequest;
import com.blade.mvc.http.HttpResponse;
import com.blade.mvc.http.Response;
import com.zeto.executor.Invoke;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HttpServerHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private static final Logger log = LoggerFactory.getLogger(HttpServerHandler.class);
    public static final FastThreadLocal<WebContext> WEB_CONTEXT_THREAD_LOCAL = new FastThreadLocal();
    private final ResponseHandler responseHandler = new ResponseHandler();

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest httpRequest) {
        String remoteAddress = ctx.channel().remoteAddress().toString();
        httpRequest.init(remoteAddress);
        WebContext context = WebContext.create(httpRequest, new HttpResponse(), ctx);
        Invoke invoke = new Invoke();
        Response response = invoke.handle(context);
        if (response == null) {
            if (this.responseHandler.staticFile(ctx, httpRequest)) {
                return;
            }
            response = new HttpResponse();
            response.status(404);
        }
        FullHttpResponse fullHttpResponse = this.responseHandler.handleResponse(httpRequest, context.getResponse(), ctx);
        ctx.writeAndFlush((Object)fullHttpResponse);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!ExceptionHandler.isResetByPeer(cause)) {
            log.error(cause.getMessage(), cause);
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)500));
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

