/*
 * Decompiled with CFR 0.152.
 */
package com.blade.server.netty;

import com.blade.Blade;
import com.blade.kit.DateKit;
import com.blade.server.netty.HttpServerHandler;
import com.blade.server.netty.MergeRequestHandler;
import com.blade.server.netty.WebSocketHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerExpectContinueHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServerInitializer
extends ChannelInitializer<SocketChannel> {
    private static final Logger log = LoggerFactory.getLogger(HttpServerInitializer.class);
    private final HttpServerHandler httpServerHandler;
    private final Blade blade;
    private final boolean isWebSocket;
    public static volatile String date = DateKit.gmtDate();

    public HttpServerInitializer(Blade blade, ScheduledExecutorService service) {
        this.blade = blade;
        this.isWebSocket = false;
        this.httpServerHandler = new HttpServerHandler();
        service.scheduleWithFixedDelay(() -> {
            date = DateKit.gmtDate();
        }, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    protected void initChannel(SocketChannel ch) {
        ChannelPipeline pipeline = ch.pipeline();
        try {
            pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
            pipeline.addLast(new ChannelHandler[]{new HttpServerExpectContinueHandler()});
            if (this.isWebSocket) {
                pipeline.addLast(new ChannelHandler[]{new WebSocketHandler(this.blade)});
            }
            pipeline.addLast(new ChannelHandler[]{new MergeRequestHandler()});
            pipeline.addLast(new ChannelHandler[]{this.httpServerHandler});
        }
        catch (Exception e) {
            log.error("Add channel pipeline error", (Throwable)e);
        }
    }
}

