/*
 * Decompiled with CFR 0.152.
 */
package com.blade.server.netty;

import com.blade.Blade;
import com.blade.Environment;
import com.blade.event.Event;
import com.blade.event.EventType;
import com.blade.ioc.DynamicContext;
import com.blade.ioc.Ioc;
import com.blade.ioc.annotation.Bean;
import com.blade.ioc.annotation.Value;
import com.blade.ioc.bean.BeanDefine;
import com.blade.ioc.bean.ClassInfo;
import com.blade.ioc.bean.OrderComparator;
import com.blade.kit.Ansi;
import com.blade.kit.BladeKit;
import com.blade.kit.IocKit;
import com.blade.kit.NamedThreadFactory;
import com.blade.kit.ReflectKit;
import com.blade.kit.StringKit;
import com.blade.loader.BladeLoader;
import com.blade.mvc.WebContext;
import com.blade.mvc.annotation.WebSocket;
import com.blade.mvc.handler.DefaultExceptionHandler;
import com.blade.mvc.handler.ExceptionHandler;
import com.blade.mvc.handler.WebSocketHandler;
import com.blade.mvc.handler.WebSocketHandlerWrapper;
import com.blade.server.Server;
import com.blade.server.netty.EpollKit;
import com.blade.server.netty.HttpServerInitializer;
import com.blade.server.netty.NettyServerGroup;
import com.blade.task.Task;
import com.blade.task.TaskContext;
import com.blade.task.TaskManager;
import com.blade.task.TaskStruct;
import com.blade.task.annotation.Schedule;
import com.blade.task.cron.CronExecutorService;
import com.blade.task.cron.CronExpression;
import com.blade.task.cron.CronThreadPoolExecutor;
import com.zeto.ZenEnvironment;
import com.zeto.annotation.AccessRole;
import com.zeto.executor.DoExecutor;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.DefaultEventLoop;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.ResourceLeakDetector;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServer
implements Server {
    private static final Logger log = LoggerFactory.getLogger(NettyServer.class);
    private Blade blade;
    private Environment environment;
    private EventLoopGroup bossGroup;
    private EventLoop scheduleEventLoop;
    private EventLoopGroup workerGroup;
    private Channel channel;
    private List<BladeLoader> loaders;
    private List<TaskStruct> taskStruts = new ArrayList<TaskStruct>();
    private volatile boolean isStop;

    @Override
    public void start(Blade blade) throws Exception {
        this.blade = blade;
        this.environment = blade.environment();
        this.loaders = blade.loaders();
        this.initConfig();
        String contextPath = this.environment.get("app.context-path", "/");
        WebContext.init(blade, contextPath);
        this.initIoc();
        this.startServer();
        this.startTask();
        String controllerPackage = "com.zeto." + ZenEnvironment.getAppName() + ".controller";
        DoExecutor.init(controllerPackage, blade.ioc().getBeans());
    }

    private void initIoc() {
        this.blade.scanPackages().stream().flatMap(DynamicContext::recursionFindClasses).map(ClassInfo::getClazz).filter(ReflectKit::isNormalClass).forEach(this::parseAndCreate);
        this.loaders.stream().sorted(new OrderComparator()).forEach(b -> b.preLoad(this.blade));
        Ioc ioc = this.blade.ioc();
        List<BeanDefine> beanDefines = ioc.getBeanDefines();
        if (BladeKit.isNotEmpty(beanDefines)) {
            beanDefines.forEach(b -> {
                IocKit.initInjection(ioc, b);
                IocKit.injectionValue(this.environment, b);
                List<TaskStruct> cronExpressions = BladeKit.getTasks(b.getType());
                if (null != cronExpressions) {
                    this.taskStruts.addAll(cronExpressions);
                }
            });
        }
        this.loaders.stream().sorted(new OrderComparator()).forEach(b -> b.load(this.blade));
    }

    private void startServer() throws Exception {
        ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.DISABLED);
        ServerBootstrap bootstrap = new ServerBootstrap();
        int acceptThreadCount = this.environment.getInt("server.netty.accept-thread-count", 1);
        int ioThreadCount = this.environment.getInt("server.netty.io-thread-count", 0);
        if (BladeKit.epollIsAvailable()) {
            bootstrap.option(EpollChannelOption.SO_REUSEPORT, (Object)true);
            NettyServerGroup nettyServerGroup = EpollKit.group(acceptThreadCount, ioThreadCount);
            this.bossGroup = nettyServerGroup.getBoosGroup();
            this.workerGroup = nettyServerGroup.getWorkerGroup();
            bootstrap.group(this.bossGroup, this.workerGroup).channel(nettyServerGroup.getSocketChannel());
        } else {
            this.bossGroup = new NioEventLoopGroup(acceptThreadCount, (ThreadFactory)new NamedThreadFactory("boss@"));
            this.workerGroup = new NioEventLoopGroup(ioThreadCount, (ThreadFactory)new NamedThreadFactory("worker@"));
            bootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class);
        }
        this.scheduleEventLoop = new DefaultEventLoop();
        bootstrap.childHandler((ChannelHandler)new HttpServerInitializer(this.blade, (ScheduledExecutorService)this.scheduleEventLoop));
        String address = this.environment.get("server.address", "0.0.0.0");
        Integer port = this.environment.getInt("server.port", 9000);
        this.channel = bootstrap.bind(address, port.intValue()).sync().channel();
        this.blade.eventManager().fireEvent(EventType.SERVER_STARTED, new Event().attribute("blade", this.blade));
    }

    private void startTask() {
        if (this.taskStruts.isEmpty()) {
            return;
        }
        int corePoolSize = this.environment.getInt("app.task.thread-count", Runtime.getRuntime().availableProcessors() + 1);
        CronExecutorService executorService = TaskManager.getExecutorService();
        if (null == executorService) {
            executorService = new CronThreadPoolExecutor(corePoolSize, new NamedThreadFactory("task@"));
            TaskManager.init(executorService);
        }
        AtomicInteger jobCount = new AtomicInteger();
        for (TaskStruct taskStruct : this.taskStruts) {
            this.addTask(executorService, jobCount, taskStruct);
        }
    }

    private void addTask(CronExecutorService executorService, AtomicInteger jobCount, TaskStruct taskStruct) {
        try {
            Schedule schedule = taskStruct.getSchedule();
            String jobName = StringKit.isBlank(schedule.name()) ? "task-" + jobCount.getAndIncrement() : schedule.name();
            Task task = new Task(jobName, new CronExpression(schedule.cron()), schedule.delay());
            TaskContext taskContext = new TaskContext(task);
            task.setTask(() -> {
                Object target = this.blade.ioc().getBean(taskStruct.getType());
                Method method = taskStruct.getMethod();
                try {
                    if (method.getParameterCount() == 1 && method.getParameterTypes()[0].equals(TaskContext.class)) {
                        taskStruct.getMethod().invoke(target, taskContext);
                    } else {
                        taskStruct.getMethod().invoke(target, new Object[0]);
                    }
                }
                catch (Exception e) {
                    log.error("Task method error", (Throwable)e);
                }
            });
            ScheduledFuture<?> future = executorService.submit(task);
            task.setFuture(future);
            TaskManager.addTask(task);
        }
        catch (Exception e) {
            log.warn("{}Add task fail: {}", (Object)BladeKit.getPrefixSymbol(), (Object)e.getMessage());
        }
    }

    private void parseAndCreate(Class<?> clazz) {
        WebSocket webSocket;
        if (null != clazz.getAnnotation(Bean.class) || null != clazz.getAnnotation(Value.class)) {
            this.blade.register(clazz);
        }
        if (null != clazz.getAnnotation(AccessRole.class)) {
            this.blade.register(clazz);
        }
        if (ReflectKit.hasInterface(clazz, BladeLoader.class) && null != clazz.getAnnotation(Bean.class)) {
            this.loaders.add((BladeLoader)this.blade.getBean(clazz));
        }
        if (this.isExceptionHandler(clazz)) {
            ExceptionHandler exceptionHandler = (ExceptionHandler)this.blade.getBean(clazz);
            this.blade.exceptionHandler(exceptionHandler);
        }
        if (null != (webSocket = clazz.getAnnotation(WebSocket.class))) {
            if (null == this.blade.getBean(clazz)) {
                this.blade.register(clazz);
            }
            if (ReflectKit.hasInterface(clazz, WebSocketHandler.class)) {
                this.blade.webSocket(webSocket.value(), (WebSocketHandler)this.blade.getBean(clazz));
            } else {
                WebSocketHandlerWrapper wrapper = this.blade.getBean(WebSocketHandlerWrapper.class);
                if (wrapper == null) {
                    wrapper = WebSocketHandlerWrapper.init(this.blade);
                    this.blade.register(wrapper);
                }
                this.blade.webSocket(webSocket.value(), wrapper);
                wrapper.wrapHandler(webSocket.value(), clazz);
            }
        }
    }

    private boolean isExceptionHandler(Class<?> clazz) {
        return null != clazz.getAnnotation(Bean.class) && (ReflectKit.hasInterface(clazz, ExceptionHandler.class) || clazz.getSuperclass().equals(DefaultExceptionHandler.class));
    }

    private void initConfig() {
        if (null != this.blade.bootClass()) {
            this.blade.scanPackages(this.blade.bootClass().getPackage().getName());
        }
        this.printBanner();
    }

    private void shutdownHook() {
        Thread shutdownThread = new Thread(this::stop);
        shutdownThread.setName("shutdown@thread");
        Runtime.getRuntime().addShutdownHook(shutdownThread);
    }

    @Override
    public void stop() {
        if (this.isStop) {
            return;
        }
        this.isStop = true;
        System.out.println();
        try {
            WebContext.clean();
            if (this.bossGroup != null) {
                this.bossGroup.shutdownGracefully();
            }
            if (this.workerGroup != null) {
                this.workerGroup.shutdownGracefully();
            }
        }
        catch (Exception e) {
            log.error("Blade shutdown error", (Throwable)e);
        }
    }

    @Override
    public void stopAndWait() {
        if (this.isStop) {
            return;
        }
        this.isStop = true;
        System.out.println();
        try {
            if (this.bossGroup != null) {
                this.bossGroup.shutdownGracefully().sync();
            }
            if (this.workerGroup != null) {
                this.workerGroup.shutdownGracefully().sync();
            }
        }
        catch (Exception e) {
            log.error("Blade shutdown error", (Throwable)e);
        }
    }

    @Override
    public void join() throws InterruptedException {
        this.channel.closeFuture().sync();
    }

    private void printBanner() {
        if (null != this.blade.bannerText()) {
            System.out.println(this.blade.bannerText());
        } else {
            Integer port = this.environment.getInt("server.port", 9000);
            String text = ZenEnvironment.getAppName() + " Started:" + port;
            System.out.println(Ansi.Magenta.format(text, new Object[0]));
        }
    }
}

