/*
 * Decompiled with CFR 0.152.
 */
package com.blade.task;

import com.blade.kit.BladeKit;
import com.blade.task.Task;
import com.blade.task.cron.CronExecutorService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TaskManager {
    private static final Logger log = LoggerFactory.getLogger(TaskManager.class);
    private static final Map<String, Task> TASK_MAP = new HashMap<String, Task>(8);
    private static final ReentrantReadWriteLock rrw = new ReentrantReadWriteLock();
    private static final Lock readLock = rrw.readLock();
    private static final Lock writeLock = rrw.writeLock();
    private static CronExecutorService cronExecutorService;

    public static void init(CronExecutorService cronExecutorService) {
        if (null != TaskManager.cronExecutorService) {
            throw new RuntimeException("Don't re-initialize the task thread pool.");
        }
        TaskManager.cronExecutorService = cronExecutorService;
        Runtime.getRuntime().addShutdownHook(new Thread(cronExecutorService::shutdown));
    }

    public static CronExecutorService getExecutorService() {
        return cronExecutorService;
    }

    public static void addTask(Task task) {
        writeLock.lock();
        try {
            TASK_MAP.put(task.getName(), task);
        }
        finally {
            writeLock.unlock();
        }
        log.info("{}Add task [{}]", (Object)BladeKit.getStartedSymbol(), (Object)task.getName());
    }

    public static List<Task> getTasks() {
        Collection<Task> values;
        readLock.lock();
        try {
            values = Optional.ofNullable(TASK_MAP.values()).orElse(Collections.EMPTY_LIST);
        }
        finally {
            readLock.unlock();
        }
        return new ArrayList<Task>(values);
    }

    public static Task getTask(String name) {
        readLock.lock();
        try {
            Task task = TASK_MAP.get(name);
            return task;
        }
        finally {
            readLock.unlock();
        }
    }

    public static boolean stopTask(String name) {
        Task task;
        readLock.lock();
        try {
            task = TASK_MAP.get(name);
        }
        finally {
            readLock.unlock();
        }
        return task == null ? Boolean.FALSE.booleanValue() : task.stop();
    }

    private TaskManager() {
    }
}

