/*
 * Decompiled with CFR 0.152.
 */
package com.zeto;

import com.blade.Blade;
import com.blade.kit.HttpKit;
import com.google.common.base.Strings;
import com.zaxxer.hikari.HikariDataSource;
import com.zeto.ZenData;
import com.zeto.ZenEnvironment;
import com.zeto.ZenUserKit;
import com.zeto.dal.DBHelper;
import com.zeto.driver.ZenLoggerEngine;
import com.zeto.driver.ZenStorageEngine;
import com.zeto.driver.mongodb.MClient;
import com.zeto.eventbus.EventBiz;
import com.zeto.executor.DoExecutor;

public class Zen {
    private static final ZenStorageEngine zenStorageEngine = new ZenStorageEngine();
    private static final ZenLoggerEngine zenLoggerEngine = new ZenLoggerEngine();
    private static final DoExecutor doAction = new DoExecutor();
    private static Blade instance;

    public static ZenStorageEngine getStorageEngine() {
        return zenStorageEngine;
    }

    public static ZenLoggerEngine getLoggerEngine() {
        return zenLoggerEngine;
    }

    public static DoExecutor getDoAction() {
        return doAction;
    }

    public static Blade start(String[] args, String appName, Integer port, Class<?> mainCls) {
        if (args.length > 0 && args[0].equals("multi")) {
            ZenEnvironment.setMulti(true);
        }
        EventBiz.init();
        ZenEnvironment.loadConfig(appName);
        instance = Blade.of().listen("0.0.0.0", port).appName(appName).start(mainCls, new String[0]);
        instance.ioc().addBean(zenLoggerEngine);
        instance.ioc().addBean(zenStorageEngine);
        EventBiz.createPid();
        if (ZenEnvironment.isNoSetup()) {
            return instance;
        }
        Zen.loadDB();
        return instance;
    }

    public static void reload() {
        ZenEnvironment.loadConfig(ZenEnvironment.getAppName());
        Zen.loadDB();
    }

    private static void loadDB() {
        zenStorageEngine.init();
        ZenUserKit.load();
        if (ZenEnvironment.isCloudApp()) {
            MClient.init();
        }
    }

    public static void setLoginURL(String url) {
        ZenEnvironment.setLoginURL(url);
    }

    public static void distory() {
        MClient.close();
        HikariDataSource ds = DBHelper.getDatasource();
        if (!ds.isClosed()) {
            ds.close();
        }
    }

    public static void upgrade() {
        EventBiz.upgrade();
    }

    public static boolean checkVersion() {
        if (ZenEnvironment.isCloudApp() || ZenEnvironment.isUpgrade()) {
            return ZenEnvironment.isUpgrade();
        }
        ZenData params = ZenData.create("app", ZenEnvironment.getAppName());
        params.put("type", "upgrade");
        params.put("version", ZenEnvironment.getVersion());
        String content = HttpKit.get("https://www.kooteam.com/home/download.do", params);
        if (Strings.isNullOrEmpty((String)content) || content.equals("newly")) {
            return false;
        }
        ZenEnvironment.setUpgrade(true);
        return true;
    }
}

