/*
 * Decompiled with CFR 0.152.
 */
package com.zeto;

import com.blade.kit.GsonKit;
import com.blade.kit.StringKit;
import com.google.common.base.Strings;
import com.zeto.ZenEnvironment;
import com.zeto.driver.cache.CacheMapper;
import com.zeto.driver.cache.GuavaCache;
import com.zeto.driver.cache.ICache;
import com.zeto.driver.cache.Memcache;

public class ZenCache {
    private static final Integer defaultTime = 120;
    private static ICache cache = null;

    static void init() {
        String memcacheConfig;
        if (cache != null && !ZenEnvironment.isNoSetup()) {
            return;
        }
        cache = ZenEnvironment.isLocalApp() || ZenEnvironment.isNoSetup() ? new GuavaCache() : (ZenEnvironment.isOnline() ? (Strings.isNullOrEmpty((String)(memcacheConfig = ZenEnvironment.get("memcache"))) ? new GuavaCache() : new Memcache(memcacheConfig)) : CacheMapper.I());
    }

    public static void close() {
        cache.close();
    }

    public static String get(String cacheId) {
        if (StringKit.isBlank(cacheId)) {
            return null;
        }
        return cache.get(cacheId);
    }

    public static <T> T get(String cacheId, Class<T> classOfT) {
        String content = ZenCache.get(cacheId);
        if (StringKit.isBlank(content)) {
            return null;
        }
        return GsonKit.parse(content, classOfT);
    }

    public static void setToUnit(String cacheId, Object data) {
        ZenCache.setToUnit(cacheId, data, 30);
    }

    public static void setToUnit(String cacheId, Object data, int second) {
        if (data == null) {
            return;
        }
        String content = String.class.isInstance(data) ? data.toString() : GsonKit.stringify(data);
        if (ZenEnvironment.isLocalApp()) {
            cache.set(cacheId, content, second);
        } else {
            CacheMapper.I().set(cacheId, content, second);
        }
    }

    public static String getFromUnit(String cacheId) {
        if (ZenEnvironment.isLocalApp()) {
            return cache.get(cacheId);
        }
        return CacheMapper.I().get(cacheId);
    }

    public static String getFromUnitWithClean(String cacheId) {
        String content = ZenCache.getFromUnit(cacheId);
        if (content == null) {
            return null;
        }
        if (ZenEnvironment.isLocalApp()) {
            cache.remove(cacheId);
        } else {
            CacheMapper.I().remove(cacheId);
        }
        return content;
    }

    public static <T> T getFromUnit(String cacheId, Class<T> classOfT) {
        String content = ZenCache.getFromUnit(cacheId);
        if (content == null) {
            return null;
        }
        return GsonKit.parse(content, classOfT);
    }

    public static <T> T getFromUnitWithClean(String cacheId, Class<T> classOfT) {
        String content = ZenCache.getFromUnitWithClean(cacheId);
        if (content == null) {
            return null;
        }
        return GsonKit.parse(content, classOfT);
    }

    public static void set(String cacheId, Object data) {
        ZenCache.set(cacheId, data, defaultTime);
    }

    public static void set(String cacheId, Object data, Integer minutes) {
        if (data == null) {
            return;
        }
        String content = String.class.isInstance(data) ? data.toString() : GsonKit.stringify(data);
        cache.set(cacheId, content, minutes);
    }

    public static void set(String cacheId, String content) {
        cache.set(cacheId, content, defaultTime);
    }

    public static void set(String cacheId, String content, Integer minutes) {
        cache.set(cacheId, content, minutes);
    }

    public static void remove(String cacheId) {
        cache.remove(cacheId);
    }

    public static String getWithClean(String cacheId) {
        String content = ZenCache.get(cacheId);
        if (content == null) {
            return null;
        }
        ZenCache.remove(cacheId);
        return content;
    }

    public static <T> T getWithClean(String cacheId, Class<T> classOfT) {
        String content = ZenCache.getWithClean(cacheId);
        if (content == null) {
            return null;
        }
        return GsonKit.parse(content, classOfT);
    }
}

