/*
 * Decompiled with CFR 0.152.
 */
package com.zeto;

import com.blade.kit.DateKit;
import com.blade.kit.GsonKit;
import com.google.common.base.Strings;
import com.zeto.util.ClassWrap;
import com.zeto.util.Converter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ZenData
implements Serializable {
    private static final long serialVersionUID = 137287009023733036L;
    private static final int DEFAULT_CAPACITY = 10;
    private static final int MAX_ARRAY_SIZE = 100;
    private static final String primaryKey = "_id";
    private String[] values = new String[10];
    private String[] keys = new String[10];
    private int size = 0;

    public ZenData() {
    }

    public ZenData(ZenData data) {
        for (String key : data.getKeys()) {
            this.put(key, data.get(key));
        }
    }

    public static ZenData parse(String content) {
        Map<String, Object> parseData = GsonKit.parseMap(content);
        ZenData data = new ZenData();
        for (String key : parseData.keySet()) {
            data.put(key, parseData.get(key).toString());
        }
        return data;
    }

    public static ZenData parse(Object data) {
        if (data instanceof Map) {
            ZenData result = new ZenData();
            HashMap params = (HashMap)data;
            for (String key : params.keySet()) {
                Object value = params.get(key);
                if (value == null) continue;
                result.put(key, value.toString());
            }
            return result;
        }
        return ZenData.parse(GsonKit.stringify(data));
    }

    public String toJSON() {
        HashMap<String, String> data = new HashMap<String, String>();
        for (int i = 0; i < this.size; ++i) {
            data.put(this.keys[i], this.values[i]);
        }
        return GsonKit.stringify(data);
    }

    public static ZenData create(String key, String val) {
        ZenData data = new ZenData();
        return data.put(key, val);
    }

    public static ZenData create(String key, Object val) {
        return ZenData.create(key, val.toString());
    }

    private void grow() {
        int newCapacity = this.size + 10;
        if (newCapacity > 100) {
            return;
        }
        this.values = Arrays.copyOf(this.values, newCapacity);
        this.keys = Arrays.copyOf(this.keys, newCapacity);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean isEmpty(String key) {
        return Strings.isNullOrEmpty((String)this.get(key));
    }

    public boolean isEmptyPrimary() {
        return !this.contains(primaryKey) || Strings.isNullOrEmpty((String)this.get(primaryKey));
    }

    public boolean contains(String key) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.keys[i].equals(key)) continue;
            return true;
        }
        return false;
    }

    public String getKey(int index) {
        return this.keys[index];
    }

    public String getValue(int index) {
        return this.values[index];
    }

    public String get(String key) {
        if (Strings.isNullOrEmpty((String)key)) {
            return null;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.keys[i] == null || !key.equals(this.keys[i])) continue;
            return this.values[i];
        }
        return null;
    }

    public String get(String key, String defVal) {
        String result = this.get(key);
        return result == null ? defVal : result;
    }

    public String[] getParameters(String key) {
        String value = this.get(key);
        return Strings.isNullOrEmpty((String)value) ? null : GsonKit.parse(value, String[].class);
    }

    public List<String> getStringList(String key) {
        String value = this.get(key);
        return Strings.isNullOrEmpty((String)value) ? null : GsonKit.parseList(value, String.class);
    }

    public String[] getValues() {
        String[] result = new String[this.size];
        System.arraycopy(this.values, 0, result, 0, this.size);
        return result;
    }

    public String[] getKeys() {
        String[] result = new String[this.size];
        System.arraycopy(this.keys, 0, result, 0, this.size);
        return result;
    }

    public Integer getInt(String key) {
        return this.getInt(key, 0);
    }

    public Integer getInt(String key, Integer defaultVal) {
        String value = this.get(key);
        if (Strings.isNullOrEmpty((String)value)) {
            return defaultVal;
        }
        return Integer.parseInt(value);
    }

    public Double getDouble(String key) {
        return Converter.getDouble(this.get(key));
    }

    public BigDecimal getDecimal(String key) {
        return Converter.getDecimal(this.get(key));
    }

    public Float getFloat(String key) {
        return Converter.getFloat(this.get(key));
    }

    public Character getCharacter(String key) {
        return Converter.getCharacter(this.get(key));
    }

    public Boolean getBoolean(String key) {
        return Converter.getBoolean(this.get(key));
    }

    public Long getLong(String key) {
        return this.getLong(key, null);
    }

    public Long getLong(String key, Long defaultVal) {
        String value = this.get(key);
        if (Strings.isNullOrEmpty((String)value)) {
            return defaultVal;
        }
        return Long.parseLong(value);
    }

    public Date getDate(String key) {
        return Converter.getDate(this.get(key));
    }

    public Long getTime(String key) {
        return DateKit.toDate(this.get(key));
    }

    public ZenData put(String key, String value) {
        int index;
        if (this.keys.length - 1 == this.size) {
            this.grow();
        }
        if ((index = this.indexOf(key)) > -1) {
            this.values[index] = value;
            return this;
        }
        this.keys[this.size] = key;
        this.values[this.size] = value;
        ++this.size;
        return this;
    }

    public ZenData getByNamespace(String key) {
        ZenData data = new ZenData();
        int keyLength = key.length() + 1;
        for (int i = 0; i < this.size; ++i) {
            String current = this.keys[i];
            if (current.indexOf(key) != 0) continue;
            current = current.substring(keyLength);
            data.put(current, this.values[i]);
        }
        return data;
    }

    public String getMapByNamespace(String key) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int keyLength = key.length() + 1;
        for (int i = 0; i < this.size; ++i) {
            String current = this.keys[i];
            if (current.indexOf(key) != 0) continue;
            current = current.substring(keyLength);
            hashMap.put(current, this.values[i]);
        }
        return GsonKit.stringify(hashMap);
    }

    public ZenData put(String key, List<String> value) {
        if (value.size() == 1) {
            this.put(key, value.get(0));
        }
        if (value.size() > 1) {
            this.put(key, String.join((CharSequence)",", value));
        }
        return this;
    }

    public ZenData put(String key, Object value) {
        if (value == null) {
            return this;
        }
        return this.put(key, value.toString());
    }

    private int indexOf(String key) {
        for (int i = 0; i < this.size; ++i) {
            if (!key.equals(this.keys[i])) continue;
            return i;
        }
        return -1;
    }

    public void remove(String key) {
        int index;
        if (!this.contains(key)) {
            return;
        }
        for (int i = index = this.indexOf(key); i < this.size; ++i) {
            this.keys[i] = this.keys[i + 1];
            this.values[i] = this.values[i + 1];
        }
        --this.size;
    }

    public <T> T getInstance(Class<T> classOfT) {
        Constructor<?> ctor1;
        Constructor<?>[] ctors = classOfT.getConstructors();
        Constructor<?> ctor = null;
        Constructor<?>[] constructorArray = ctors;
        int n = constructorArray.length;
        for (int i = 0; i < n && (ctor = (ctor1 = constructorArray[i])).getGenericParameterTypes().length != 0; ++i) {
        }
        if (ctor == null) {
            return null;
        }
        try {
            ctor.setAccessible(true);
            Object instance = ctor.newInstance(new Object[0]);
            Class<T> des = classOfT;
            while (!des.getName().equals("java.lang.Object")) {
                Field[] fields = des.getDeclaredFields();
                this.setFields(fields, instance);
                des = des.getSuperclass();
            }
            return ClassWrap.toJavaObject(instance, classOfT);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void setFields(Field[] fieldsDes, Object desc) {
        String[] names = this.getKeys();
        block2: for (Field field : fieldsDes) {
            for (String name : names) {
                if (!field.getName().equals(name)) continue;
                try {
                    field.setAccessible(true);
                    Class<?> type = field.getType();
                    Object value = this.getValueByType(type, name);
                    if (value == null) continue block2;
                    field.set(desc, value);
                    continue block2;
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
    }

    public Object getValueByType(Class t, String name) {
        if (String.class.equals((Object)t)) {
            return this.get(name);
        }
        if (Integer.class.equals((Object)t) || Integer.TYPE.equals(t)) {
            return this.getInt(name);
        }
        if (Long.class.equals((Object)t) || Long.TYPE.equals(t)) {
            return this.getLong(name);
        }
        if (BigDecimal.class.equals((Object)t)) {
            return this.getDecimal(name);
        }
        if (Boolean.class.equals((Object)t) || Boolean.TYPE.equals(t)) {
            return this.getBoolean(name);
        }
        if (Date.class.equals((Object)t)) {
            return this.getDate(name);
        }
        if (Character.class.equals((Object)t) || Character.TYPE.equals(t)) {
            return this.getCharacter(name);
        }
        if (Float.class.equals((Object)t) || Float.TYPE.equals(t)) {
            return this.getFloat(name);
        }
        if (Double.class.equals((Object)t) || Double.TYPE.equals(t)) {
            return this.getDouble(name);
        }
        return null;
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.keys[i] = null;
            this.values[i] = null;
        }
        this.size = 0;
    }
}

