/*
 * Decompiled with CFR 0.152.
 */
package com.zeto;

import com.blade.kit.DateKit;
import com.blade.kit.GsonKit;
import com.blade.kit.IOKit;
import com.blade.kit.TemplateKit;
import com.google.common.base.Strings;
import com.zeto.ZenCache;
import com.zeto.ZenData;
import com.zeto.dal.ApiMapper;
import com.zeto.dal.DBHelper;
import com.zeto.domain.ZenApp;
import com.zeto.driver.domain.Table;
import com.zeto.eventbus.EventBiz;
import com.zeto.kit.ConfigKit;
import com.zeto.kit.driver.ConfigVO;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.SimpleLogger;

public class ZenEnvironment {
    private static final Logger log = LoggerFactory.getLogger(ZenEnvironment.class);
    private static ZenApp app;
    private static boolean dailyStatus;
    private static boolean preStatus;
    private static boolean onlineStatus;
    private static boolean devStatus;
    private static boolean upgrade;
    private static String homeURI;
    private static int mode;
    private static List<Table> tables;
    private static String _appName;
    private static final String schemaName = "_dbConfig_";
    private static boolean multi;
    private static String loginURL;
    private static String path;
    private static String _tag;
    private static String _version;
    private static Map<String, String> data;
    private static Map<String, List<Table>> schemaCache;

    public static String getVersion() {
        return _version;
    }

    public static ZenApp getApp() {
        return app;
    }

    public static String getTag() {
        return _tag;
    }

    public static String getPath() {
        return path;
    }

    public static void setPath(String _path) {
        path = _path;
    }

    public static void setLoginURL(String url) {
        loginURL = url;
    }

    public static String getLoginURL() {
        return loginURL;
    }

    public static boolean isLocalApp() {
        return ZenEnvironment.isMysqlPrivate() || ZenEnvironment.isSqlitePrivate() || ZenEnvironment.isNoSetup();
    }

    public static boolean isCloudApp() {
        return mode < 2;
    }

    public static boolean isMulti() {
        return multi;
    }

    public static void setMulti(boolean _multi) {
        multi = _multi;
    }

    public static int getMode() {
        return mode;
    }

    public static boolean isNoSetup() {
        return mode == 9;
    }

    public static boolean isPersonCloud() {
        return mode == 0;
    }

    public static boolean isEnterpriseCloud() {
        return mode == 1;
    }

    public static boolean isMysqlPrivate() {
        return mode == 3;
    }

    public static boolean isSqlitePrivate() {
        return mode == 4;
    }

    public static boolean isUpgrade() {
        return upgrade;
    }

    public static String getHomeURI() {
        return homeURI;
    }

    public static void setHomeURI(String url) {
        homeURI = url;
    }

    public static void setUpgrade(boolean upgrade) {
        ZenEnvironment.upgrade = upgrade;
    }

    public static void set(String key, String val) {
        if ((key = key.trim()).indexOf("#") == 0 || val == null) {
            return;
        }
        val = val.trim();
        data.put(key, val);
    }

    public static String getAppName() {
        return _appName;
    }

    public static String get(String key) {
        return ZenEnvironment.get(key, "");
    }

    public static String get(String key, String defaultVal) {
        if (data.containsKey(key)) {
            return data.get(key);
        }
        return defaultVal;
    }

    public static Boolean has(String key) {
        return data.containsKey(key);
    }

    public static void syncTableSchema(String content) {
        if (Strings.isNullOrEmpty((String)content)) {
            content = "[]";
        }
        tables = GsonKit.parseList(content, Table.class);
    }

    public static List<Table> getTables() {
        return tables;
    }

    public static Table getTable(String name) {
        for (Table table : tables) {
            if (!table.getName().equals(name)) continue;
            return table;
        }
        return null;
    }

    public static Table getTableByApp(String name, String appName) {
        List<Table> tableList = schemaCache.get(appName);
        if (tableList == null) {
            String content = TemplateKit.loadFromDB(schemaName, appName);
            if (Strings.isNullOrEmpty((String)content)) {
                content = "[]";
            }
            if ((tableList = GsonKit.parseList(content, Table.class)).size() > 0) {
                schemaCache.put(appName, tableList);
            }
        }
        for (Table table : tableList) {
            if (!table.getName().endsWith(name)) continue;
            return table;
        }
        return null;
    }

    private static void initSchema() {
        String content = "";
        if (ZenEnvironment.isDev()) {
            content = TemplateKit.load(schemaName);
        } else {
            String filePath = path + "/config/schema.json";
            try {
                content = IOKit.readToString(filePath);
            }
            catch (Exception e) {
                log.error("schema error", (Throwable)e);
                e.printStackTrace();
            }
        }
        ZenEnvironment.syncTableSchema(content);
    }

    public static boolean isDaily() {
        return dailyStatus;
    }

    public static boolean isPre() {
        return preStatus;
    }

    public static boolean isOnline() {
        return onlineStatus;
    }

    public static boolean isDev() {
        return devStatus;
    }

    static void loadConfig(String appName) {
        _appName = appName;
        path = System.getProperty("user.dir");
        String logDir = path + "/log";
        File file = new File(logDir);
        if (!file.isDirectory()) {
            file.mkdir();
        }
        SimpleLogger.zenSet(appName, logDir);
        ConfigKit.init(path);
        String env = ZenEnvironment.get("env", "dev");
        if (env.equals("dev")) {
            devStatus = true;
        }
        if (env.equals("daily")) {
            dailyStatus = true;
        }
        if (env.equals("pre")) {
            preStatus = true;
        }
        if (env.equals("online")) {
            onlineStatus = true;
            try {
                String tagFile = path + "/config/tag";
                _tag = IOKit.readToString(tagFile);
            }
            catch (Exception e) {
                log.error("tag file", (Throwable)e);
            }
        }
        try {
            String versionFile = path + "/config/version";
            File versionPath = new File(versionFile);
            if (versionPath.exists()) {
                _version = IOKit.readToString(versionFile);
            }
        }
        catch (Exception e) {
            log.error("version file", (Throwable)e);
        }
        String modeStr = ZenEnvironment.get("mode");
        if (Strings.isNullOrEmpty((String)modeStr) || !ZenEnvironment.isNoSetup()) {
            ZenCache.init();
            return;
        }
        mode = Integer.parseInt(modeStr);
        if (ZenEnvironment.isNoSetup()) {
            ZenEnvironment.refreshAppConfig();
            ZenEnvironment.initSchema();
            ZenCache.init();
            return;
        }
        DBHelper.init();
        ZenEnvironment.refreshAppConfig();
        ZenEnvironment.initSchema();
        if (ZenEnvironment.isLocalApp()) {
            if (mode > 2) {
                EventBiz.dbRsync();
            }
        } else {
            ZenData configList = ApiMapper.i().selectConfig(appName);
            for (String key : configList.getKeys()) {
                if (ZenEnvironment.has(key).booleanValue()) continue;
                ZenEnvironment.set(key, configList.get(key));
            }
        }
        ApiMapper.i().init(appName);
        ZenCache.init();
    }

    public static void refreshAppConfig() {
        if (ZenEnvironment.isDev() || ZenEnvironment.isDaily()) {
            app = DBHelper.getApp(ZenEnvironment.getAppName());
            return;
        }
        String appContent = ZenEnvironment.readFile("/config/app");
        if (appContent == null) {
            app = DBHelper.getApp(ZenEnvironment.getAppName());
            return;
        }
        app = GsonKit.parse(appContent, ZenApp.class);
        String configContent = ZenEnvironment.readFile("/config/app.config");
        if (configContent == null) {
            return;
        }
        List<ConfigVO> configs = GsonKit.parseList(configContent, ConfigVO.class);
        if (configs == null) {
            return;
        }
        List<ConfigVO> oldConfigs = app.getConfigs();
        block0: for (int i = 0; i < oldConfigs.size(); ++i) {
            for (int j = 0; j < configs.size(); ++j) {
                if (!oldConfigs.get(i).getName().equals(configs.get(j).getName())) continue;
                oldConfigs.set(i, configs.get(j));
                continue block0;
            }
        }
    }

    private static String readFile(String path) {
        String appConfigPath = ZenEnvironment.getPath() + path;
        File file = new File(appConfigPath);
        if (!file.isFile()) {
            return null;
        }
        Long filelength = file.length();
        byte[] filecontent = new byte[filelength.intValue()];
        try {
            FileInputStream in = new FileInputStream(file);
            in.read(filecontent);
            in.close();
            return new String(filecontent, "UTF-8");
        }
        catch (Exception e) {
            log.error(path, (Throwable)e);
            return null;
        }
    }

    public static void serialize(Map<String, String> param) {
        String profilepath = ZenEnvironment.getPath() + "/app.properties";
        try {
            File propFile = new File(profilepath);
            if (!propFile.exists()) {
                return;
            }
            Properties props = new Properties();
            props.load(new FileInputStream(profilepath));
            for (String key : param.keySet()) {
                String val = param.get(key);
                props.setProperty(key, val);
                ZenEnvironment.set(key, val);
            }
            FileOutputStream fos = new FileOutputStream(profilepath);
            props.store(fos, DateKit.gmtDate());
            ((OutputStream)fos).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        dailyStatus = false;
        preStatus = false;
        onlineStatus = false;
        devStatus = false;
        upgrade = false;
        homeURI = "/home.html";
        mode = 9;
        multi = false;
        loginURL = null;
        path = null;
        _tag = "";
        _version = "";
        data = new HashMap<String, String>();
        schemaCache = new HashMap<String, List<Table>>();
    }
}

