/*
 * Decompiled with CFR 0.152.
 */
package com.zeto;

import com.blade.kit.GsonKit;
import com.blade.mvc.WebContext;
import com.blade.mvc.http.Cookie;
import com.zeto.ZenEnvironment;
import com.zeto.domain.ZenAction;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZenResult {
    private static final Logger log = LoggerFactory.getLogger(ZenResult.class);
    private boolean isError = false;
    private String message = "";
    private Boolean isClean = false;
    private int action = ZenAction.SUCCESS.getValue();
    private List<Cookie> cookies;
    private static final String DATA_KEY = "data";
    private static final String METHOD = "POST";
    private Map<String, Object> map = new HashMap<String, Object>();

    public static ZenResult success() {
        return new ZenResult();
    }

    public static ZenResult success(String message) {
        return ZenResult.success().setAction(ZenAction.SUCCESS).setMessage(message);
    }

    public static ZenResult success(String message, ZenAction action) {
        return ZenResult.success().setAction(action).setMessage(message);
    }

    public boolean isEmpty() {
        if (this.map == null || this.map.size() == 0) {
            return true;
        }
        return this.isError;
    }

    public ZenResult emptyArray() {
        return this.setData(new ArrayList());
    }

    public boolean isSuccess() {
        return !this.isError;
    }

    public static ZenResult fail() {
        return ZenResult.success().hasError(true);
    }

    public static ZenResult fail(String message) {
        return ZenResult.fail().setAction(ZenAction.FAIL).setMessage(message);
    }

    public static ZenResult noLogin() {
        String redirectURL = ZenEnvironment.getLoginURL();
        if (redirectURL != null) {
            return ZenResult.success().setAction(ZenAction.GOLOGIN).setData(redirectURL);
        }
        return ZenResult.success().setAction(ZenAction.GOLOGIN);
    }

    public static ZenResult redirect(String uri) {
        if (WebContext.get().getRequest().method().equals(METHOD)) {
            return ZenResult.success().setAction(ZenAction.JUMP).put("uri", uri);
        }
        return ZenResult.success().setAction(ZenAction.REDIRECT).setMessage(uri);
    }

    public static ZenResult jsRedirect(String uri) {
        return ZenResult.success().setAction(ZenAction.GOTO).setMessage(uri);
    }

    public static ZenResult noPermision() {
        return ZenResult.fail().setAction(ZenAction.NOPERMISSION);
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public ZenResult setCookies(List<Cookie> cookies) {
        this.cookies = cookies;
        return this;
    }

    public static ZenResult login(Map<String, Object> profile) {
        return ZenResult.success().setAction(ZenAction.JUMP).put("profile", profile);
    }

    public static ZenResult login(String uri, Map<String, Object> profile) {
        return ZenResult.success().setAction(ZenAction.JUMP).put("uri", uri).put("profile", profile);
    }

    public ZenResult refresh() {
        return this.setAction(ZenAction.REFRESH);
    }

    public ZenResult hasError(boolean success) {
        this.isError = true;
        return this;
    }

    public static ZenResult parse(String content) {
        ZenResult result = new ZenResult();
        Map<String, Object> data = GsonKit.parseMap(content);
        result.setData(data.get(DATA_KEY));
        if (data.containsKey("hasError")) {
            result.hasError(true);
        }
        if (data.containsKey("message")) {
            result.setMessage(data.get("message").toString());
        }
        Integer action = (int)((Integer)data.get("action"));
        result.setAction(action);
        return result;
    }

    public String getMessage() {
        return this.message;
    }

    public ZenResult setMessage(String message) {
        this.message = message;
        return this;
    }

    public ZenResult setData(Object data) {
        return this.put(DATA_KEY, data);
    }

    public ZenResult setData(Object data, Boolean isClean) {
        this.isClean = isClean;
        return this.setData(data);
    }

    public ZenResult setData(Map<String, Object> data) {
        this.map = data;
        return this;
    }

    public Object getData() {
        if (this.isEmpty()) {
            return null;
        }
        if (this.map.containsKey(DATA_KEY)) {
            return this.map.get(DATA_KEY);
        }
        return this.map;
    }

    public List<Object> getList() {
        if (this.isEmpty()) {
            return null;
        }
        return (List)this.getData();
    }

    public String[] getIds(String key) {
        List<Map<String, Object>> data = this.getListWidthMap();
        if (data == null) {
            return null;
        }
        String[] result = new String[data.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = data.get(i).get(key).toString();
        }
        return result;
    }

    public List<Map<String, Object>> getListWidthMap() {
        if (this.isEmpty()) {
            return null;
        }
        return (List)this.getData();
    }

    public Map<String, Object> getMap() {
        if (this.isEmpty()) {
            return null;
        }
        return (Map)this.getData();
    }

    public Integer getAction() {
        return this.action;
    }

    public ZenResult setAction(Integer action) {
        this.action = action;
        return this;
    }

    public ZenResult setAction(ZenAction action) {
        this.action = action.getValue();
        return this;
    }

    public ZenResult put(String key, Object data) {
        this.map.put(key, data);
        return this;
    }

    public ZenResult setTotal(long number) {
        return this.put("total", number);
    }

    public <T> ZenResult setList(List<T> data) {
        return this.put("list", data);
    }

    public String toJSON() {
        if (this.isClean.booleanValue()) {
            return this.map.get(DATA_KEY).toString();
        }
        String gsonData = null;
        if (this.map.size() == 1 && this.map.containsKey(DATA_KEY)) {
            gsonData = GsonKit.stringify(this.map.get(DATA_KEY));
        } else if (!this.isEmpty()) {
            gsonData = GsonKit.stringify(this.map);
        }
        if (this.isError) {
            return String.format("{\"hasError\":true,\"message\":\"%s\",\"data\":%s,\"action\":%d}", this.message, gsonData, this.action);
        }
        return String.format("{\"message\":\"%s\",\"data\":%s,\"action\":%d}", this.message, gsonData, this.action);
    }

    public String get(String key) {
        Object data = this.getObject(key);
        if (data == null) {
            return null;
        }
        return data.toString();
    }

    public Object getObject(String key) {
        return this.map.get(key);
    }

    public int getInt() {
        return this.getInt(DATA_KEY);
    }

    public int getInt(String key) {
        Object data = this.getObject(key);
        if (data == null) {
            return 0;
        }
        if (data instanceof String) {
            return Integer.parseInt(data.toString());
        }
        if (data instanceof Long) {
            return ((Long)this.getObject(key)).intValue();
        }
        return (Integer)data;
    }

    public long getLong() {
        return this.getLong(DATA_KEY);
    }

    public long getLong(String key) {
        Object data = this.getObject(key);
        if (data == null) {
            return 0L;
        }
        return (Long)data;
    }

    public static ZenResult error(String msg) {
        log.error("\u8f93\u51fa\u5f02\u5e38", (Object)msg);
        return ZenResult.success().hasError(true).setData(msg).setAction(ZenAction.FATAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZenResult error(String msg, Exception e) {
        ZenResult result = new ZenResult();
        result.hasError(true).setAction(ZenAction.FATAL);
        log.error("\u8f93\u51fa\u5f02\u5e38", (Throwable)e);
        if (ZenEnvironment.isOnline()) {
            result.setData(e.getMessage());
        } else {
            StringWriter sw = new StringWriter();
            try (PrintWriter pw = new PrintWriter(sw);){
                e.printStackTrace(pw);
                String content = sw.toString();
                if (msg != null) {
                    content = msg + "\\n" + content;
                }
                result.setData(content);
            }
            e.printStackTrace();
        }
        return result;
    }

    public static ZenResult error(Exception e) {
        return ZenResult.error(null, e);
    }
}

