/*
 * Decompiled with CFR 0.152.
 */
package com.zeto;

import com.blade.kit.GsonKit;
import com.blade.kit.StringKit;
import com.blade.mvc.WebContext;
import com.blade.mvc.http.Cookie;
import com.blade.mvc.http.Request;
import com.google.common.base.Strings;
import com.zeto.ZenCache;
import com.zeto.ZenEnvironment;
import com.zeto.ZenUserKit;
import com.zeto.domain.ZenUser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZenTokenKit {
    private static final Logger log = LoggerFactory.getLogger(ZenTokenKit.class);
    private static final String prefix = "TK_";
    private static final String PROXY = "proxy";
    private static final String BRIDGE_APP = "bridge";
    private static final long loginTime = 1296000L;
    private static final int tokenTime = 5;
    private static final String splitDot = ".";
    private static final String[] cookieKeys = new String[]{"ukey", "zenUser"};

    public static ZenUser check(String token) {
        if (Strings.isNullOrEmpty((String)token)) {
            return null;
        }
        token = prefix + token;
        String uid = ZenCache.getWithClean(token);
        if (Strings.isNullOrEmpty((String)uid)) {
            return null;
        }
        return ZenUserKit.get(uid);
    }

    public static String getLoginURL(Request request) {
        return ZenTokenKit.getLoginURL(request, null);
    }

    public static String getLoginURL(Request request, String appName) {
        appName = appName == null ? BRIDGE_APP : appName + "-bridge";
        String url = request.parameters().get("reback");
        String host = request.host();
        String isWeixin = request.parameters().get("isWeixin");
        if (Strings.isNullOrEmpty((String)url)) {
            url = request.isSecure() ? "https://" : "http://";
            url = url + host + request.url();
        }
        String domain = ZenEnvironment.isOnline() ? "https://" + appName + ".yimiyisu.com" : (ZenEnvironment.isPre() ? "https://" + appName + ".pre.zeto.me" : (host.contains(PROXY) ? "http://" + appName + ".proxy.zeto.me" : "http://" + appName + ".zeto.me"));
        url = StringKit.urlEncode(url);
        if (Strings.isNullOrEmpty((String)isWeixin)) {
            return domain + "/home.html?reback=" + url;
        }
        return domain + "/weixinOpen/wap.do?redirect=" + url;
    }

    public static List<Cookie> cleanCookie() {
        String domain = ZenTokenKit.getDomain();
        ArrayList<Cookie> cookieList = new ArrayList<Cookie>();
        for (String key : cookieKeys) {
            Cookie current = new Cookie();
            current.maxAge(1L);
            current.name(key);
            current.value("");
            current.domain(domain);
            current.httpOnly(false);
            cookieList.add(current);
        }
        return cookieList;
    }

    public static Map<String, Object> profile(ZenUser user, String siteId) {
        HashMap<String, Object> profile = new HashMap<String, Object>();
        profile.put("uid", user.getUid());
        profile.put("ukey", user.getUkey());
        profile.put("nick", user.getNick());
        if (siteId == null) {
            profile.put("tag", user.getTag());
        } else {
            profile.put("tag", user.getTag(siteId));
            profile.put("siteId", siteId);
        }
        return profile;
    }

    public static Map<String, Object> profile(ZenUser user) {
        String siteId = null;
        if (ZenEnvironment.isCloudApp() && WebContext.get().getZenSite() != null) {
            siteId = WebContext.get().getZenSite().getId();
        }
        return ZenTokenKit.profile(user, siteId);
    }

    public static List<Cookie> cookies(ZenUser user) {
        Request request = WebContext.get().getRequest();
        String domain = request.header("Host");
        ArrayList<Cookie> cookieList = new ArrayList<Cookie>();
        Cookie uid = new Cookie();
        uid.maxAge(1296000L);
        uid.name("Uid");
        uid.value(user.getUid());
        uid.httpOnly(false);
        uid.domain(domain);
        cookieList.add(uid);
        Cookie ukeyCookie = new Cookie();
        ukeyCookie.maxAge(1296000L);
        ukeyCookie.name("Ukey");
        ukeyCookie.value(user.getUkey());
        ukeyCookie.httpOnly(false);
        ukeyCookie.domain(domain);
        cookieList.add(ukeyCookie);
        Cookie zenUser = new Cookie();
        zenUser.maxAge(1296000L);
        zenUser.name("zenUser");
        zenUser.value(GsonKit.stringify(ZenTokenKit.profile(user)));
        zenUser.httpOnly(false);
        zenUser.domain(domain);
        cookieList.add(zenUser);
        return cookieList;
    }

    public static String set(String uid) {
        String id = StringKit.objectId();
        ZenTokenKit.set(id, uid);
        return id;
    }

    public static void set(String tokenId, String uid) {
        tokenId = prefix + tokenId;
        ZenCache.set(tokenId, uid, (Integer)5);
    }

    private static String getDomain() {
        Request request = WebContext.get().getRequest();
        String domain = request.header("Host");
        if (!ZenEnvironment.isCloudApp()) {
            return null;
        }
        int start = domain.indexOf(splitDot);
        if (start != domain.lastIndexOf(splitDot)) {
            domain = domain.substring(start + 1);
        }
        return domain;
    }
}

