/*
 * Decompiled with CFR 0.152.
 */
package com.zeto;

import com.blade.kit.StringKit;
import com.blade.kit.UUID;
import com.google.common.base.Strings;
import com.zeto.ZenCache;
import com.zeto.ZenResult;
import com.zeto.dal.IUserMapper;
import com.zeto.dal.UserMysqlMapper;
import com.zeto.domain.ZenRole;
import com.zeto.domain.ZenUser;
import com.zeto.kit.TagKit;
import com.zeto.kit.driver.TagModel;
import java.util.List;
import java.util.Map;

public class ZenUserKit {
    private static IUserMapper instance = null;
    private static final String ROOT_USER = "kooteam";
    private static final String ROOT_NICK = "\u7cfb\u7edf\u7ba1\u7406\u5458";

    public static void load() {
        instance = new UserMysqlMapper();
    }

    private ZenUserKit() {
    }

    public static ZenUser insert(ZenUser user) {
        String ukey = UUID.captchaNumber(16);
        user.setUkey(ukey);
        instance.insert(user);
        return user;
    }

    public static void updateNick(String nick, String uid) {
        instance.updateNick(nick, uid);
    }

    public static void updateUionId(String uionId, String uid) {
        instance.updateUionId(uionId, uid);
    }

    public static void setTag(String uid, TagModel model) {
        ZenUser user = ZenUserKit.get(uid);
        if (user == null) {
            return;
        }
        for (int tag : model.getTags()) {
            Long tagValue = TagKit.set(user.getTag(), tag);
            user.setTag(tagValue);
        }
        instance.setTag(uid, user.getTag());
    }

    public static void setTag(String uid, ZenRole tag) {
        ZenUser user = ZenUserKit.get(uid);
        if (user == null || TagKit.contain(user.getTag(), tag.value())) {
            return;
        }
        Long tagValue = TagKit.set(user.getTag(), tag.value());
        instance.setTag(uid, tagValue);
    }

    public static void updateEmail(String email, String uid) {
        instance.updateEmail(email, uid);
    }

    public static ZenUser updateUkey(String uid) {
        return instance.updateUkey(uid);
    }

    public static void cleanCache(String uid) {
        instance.cleanCache(uid);
    }

    public static void delete(String uid) {
        instance.delete(uid);
        ZenUserKit.cleanCache(uid);
    }

    public static void changePassword(String uid, String pwd) {
        instance.changePassword(uid, pwd);
    }

    public static List<ZenUser> select(int start, int size) {
        return instance.select(start, size);
    }

    public static Long count() {
        return instance.count();
    }

    public static List<ZenUser> search(String keyword) {
        return ZenUserKit.search(keyword, 20);
    }

    public static List<ZenUser> search(String keyword, int size) {
        return instance.search(keyword, size);
    }

    public static boolean exist(String uid) {
        return instance.exist(uid);
    }

    public static boolean existByUnionId(String unionId, ZenRole tag) {
        ZenUser user = ZenUserKit.getByUnionId(unionId, tag);
        return user != null;
    }

    public static ZenUser getByUnionId(String unionId, ZenRole tag) {
        return instance.getByUnionId(unionId, tag.value());
    }

    public static ZenUser getByName(String username) {
        return instance.getByName(username);
    }

    public static ZenUser getByMobile(String phone, ZenRole tag) {
        return instance.getByMobile(phone, tag.value());
    }

    public static ZenUser get(String uid) {
        if (Strings.isNullOrEmpty((String)uid)) {
            return null;
        }
        return instance.get(uid);
    }

    public static String nick(String uid) {
        ZenUser user = ZenUserKit.get(uid);
        if (user == null) {
            return null;
        }
        return user.getNick();
    }

    public static void resetRoot() {
        String pwd = ZenCache.getWithClean("rootInit");
        if (Strings.isNullOrEmpty((String)pwd)) {
            return;
        }
        ZenUser oldRoot = ZenUserKit.getByName(ROOT_USER);
        if (oldRoot == null) {
            ZenUser zenUser = new ZenUser();
            zenUser.setUid(StringKit.objectId());
            zenUser.setNick(ROOT_NICK);
            zenUser.setUsername(ROOT_USER);
            zenUser.setPwd(pwd);
            zenUser.setTag(ZenRole.ADMIN.with(ZenRole.SUPPER).value());
            ZenUserKit.insert(zenUser);
        } else {
            String uid = oldRoot.getUid();
            ZenUserKit.setTag(uid, ZenRole.ADMIN);
            ZenUserKit.changePassword(uid, pwd);
        }
    }

    public static ZenResult selectByUids(ZenResult data) {
        return ZenUserKit.selectByUids(data, "userId");
    }

    public static ZenResult selectByUids(ZenResult data, String keyName) {
        List<Object> list = data.getList();
        if (list == null || list.size() == 0) {
            return ZenResult.success().emptyArray();
        }
        for (int i = 0; i < list.size(); ++i) {
            Map itemObj = (Map)list.get(i);
            ZenUser user = instance.get((String)itemObj.get(keyName));
            if (user == null) continue;
            itemObj.put("nick", user.getNick());
        }
        return data;
    }
}

