/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.controller;

import com.blade.kit.EncryptKit;
import com.blade.kit.GsonKit;
import com.blade.mvc.WebContext;
import com.google.common.base.Strings;
import com.zeto.ZenData;
import com.zeto.ZenEnvironment;
import com.zeto.ZenResult;
import com.zeto.ZenTokenKit;
import com.zeto.ZenUserKit;
import com.zeto.annotation.AccessRole;
import com.zeto.annotation.MethodType;
import com.zeto.domain.ZenMethod;
import com.zeto.domain.ZenRole;
import com.zeto.domain.ZenSite;
import com.zeto.domain.ZenUser;
import com.zeto.kit.ConfigKit;
import java.util.List;
import java.util.Map;

@AccessRole(value=ZenRole.ANONYMITY)
public class Zeto {
    private static final String OK = "ok";
    private static final String ENV = "env";

    @MethodType(value=ZenMethod.ALL)
    public ZenResult status() {
        return ZenResult.success(OK);
    }

    public ZenResult component(ZenData data, ZenUser user) {
        return null;
    }

    public ZenResult tcodes(ZenData data, ZenUser user) {
        String[] nameList = data.getParameters("names");
        if (nameList == null || nameList.length == 0) {
            return ZenResult.fail("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ZenResult result = ZenResult.success();
        String api = data.get("api");
        if (Strings.isNullOrEmpty((String)api)) {
            for (String name : nameList) {
                result.put(name, ConfigKit.getGroup(name));
            }
        } else if (user == null) {
            return result;
        }
        return result;
    }

    public ZenResult nick(ZenData data) {
        String uid = data.get("uid");
        ZenResult result = ZenResult.success();
        if (uid == null) {
            return result;
        }
        ZenUser user = ZenUserKit.get(uid);
        if (user != null) {
            result.setData(user.getNick());
        }
        return result;
    }

    public ZenResult nicks(ZenData data) {
        String[] uids = data.getParameters("uids");
        ZenResult result = ZenResult.success();
        if (uids == null || uids.length == 0) {
            return result;
        }
        for (String uid : uids) {
            ZenUser user = ZenUserKit.get(uid);
            if (user == null) continue;
            result.put(uid, user.getNick());
        }
        return result;
    }

    public ZenResult login(ZenData data) {
        String username = data.get("username");
        String password = data.get("password");
        ZenUser user = ZenUserKit.getByName(username);
        if (user == null || Strings.isNullOrEmpty((String)user.getPwd())) {
            return ZenResult.fail("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        if (Strings.isNullOrEmpty((String)password)) {
            return ZenResult.fail("\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!(password = EncryptKit.md5(password)).equals(user.getPwd())) {
            return ZenResult.fail("\u5bc6\u7801\u9519\u8bef");
        }
        String redirect = data.get("redirect");
        Map<String, Object> profile = ZenTokenKit.profile(user);
        if (Strings.isNullOrEmpty((String)redirect)) {
            return ZenResult.login(profile).setMessage("\u767b\u5f55\u6210\u529f");
        }
        return ZenResult.login(redirect, profile);
    }

    public ZenResult logout(ZenUser user) {
        if (user == null) {
            return ZenResult.success();
        }
        ZenUserKit.updateUkey(user.getUid());
        return ZenResult.success().setCookies(ZenTokenKit.cleanCookie());
    }

    public ZenResult checkUpdate() {
        return ZenResult.success().setData(ZenEnvironment.isUpgrade());
    }

    public ZenResult current(ZenUser user) {
        ZenSite site;
        ZenResult result = ZenResult.success().put("mode", ZenEnvironment.getMode()).put(ENV, ZenEnvironment.get(ENV)).put("app", ZenEnvironment.getAppName());
        if (ZenEnvironment.isMulti() && (site = WebContext.get().getZenSite()) != null) {
            result.put("siteId", site.getId());
        }
        if (user == null) {
            return result;
        }
        return result.put("uid", user.getUid()).put("nick", user.getNick()).put("isAdmin", user.isAdmin()).put("tag", user.getTag());
    }

    public ZenResult user(ZenData data, ZenUser user) {
        String keyword = data.get("keyword");
        if (user == null || Strings.isNullOrEmpty((String)keyword)) {
            return ZenResult.success();
        }
        return ZenResult.success().setData(ZenUserKit.search(keyword, 5));
    }

    public ZenResult tcode(ZenData data, ZenUser user) {
        if (user == null) {
            return ZenResult.fail();
        }
        String name = data.get("key");
        return ZenResult.success().setData(ConfigKit.getGroup(name));
    }

    public ZenResult setTcode(ZenData data, ZenUser user) {
        if (user == null || !user.hasTag(ZenRole.ADMIN) && !user.hasTag(ZenRole.DEVELOPER)) {
            return ZenResult.fail();
        }
        String name = data.get("key");
        ZenData map = new ZenData();
        List<Map<String, Object>> list = GsonKit.parseListMap(data.get("map"));
        for (Map<String, Object> item : list) {
            map.put(item.get("title").toString(), item.get("value"));
        }
        if (ConfigKit.getGroupBySite(name) == null) {
            ConfigKit.addBySite(user.siteId(), name, name, 2);
        }
        return ZenResult.success("\u4fdd\u5b58\u6210\u529f");
    }

    public ZenResult monitor(ZenUser user) {
        if (user == null || !user.hasTag(ZenRole.DEVELOPER)) {
            return ZenResult.fail();
        }
        return null;
    }

    public ZenResult check() {
        return null;
    }
}

