/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.controller.monitor;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadMXBean;
import java.math.BigDecimal;

public class CPUMonitorCalc {
    private static CPUMonitorCalc instance = new CPUMonitorCalc();
    private OperatingSystemMXBean osMxBean;
    private ThreadMXBean threadBean;
    private long preTime = System.nanoTime();
    private long preUsedTime = 0L;

    private CPUMonitorCalc() {
        this.osMxBean = ManagementFactory.getOperatingSystemMXBean();
        this.threadBean = ManagementFactory.getThreadMXBean();
    }

    public static CPUMonitorCalc getInstance() {
        return instance;
    }

    public double getProcessCpu() {
        long totalTime = 0L;
        for (long id : this.threadBean.getAllThreadIds()) {
            totalTime += this.threadBean.getThreadCpuTime(id);
        }
        long curtime = System.nanoTime();
        long usedTime = totalTime - this.preUsedTime;
        long totalPassedTime = curtime - this.preTime;
        this.preTime = curtime;
        this.preUsedTime = totalTime;
        return new BigDecimal((double)usedTime / (double)totalPassedTime / (double)this.osMxBean.getAvailableProcessors() * 100.0).setScale(2, 4).doubleValue();
    }
}

