/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.controller.monitor;

import com.blade.kit.ConvertKit;
import com.zeto.controller.monitor.SystemVO;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;

public class SystemUtils {
    public static void setMemoryUsage(SystemVO systemVO) {
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        long totalMemorySize = 0L;
        long freePhysicalMemorySize = 0L;
        long usedMemorySize = 0L;
        for (Method method : operatingSystemMXBean.getClass().getDeclaredMethods()) {
            Object value;
            method.setAccessible(true);
            if (!method.getName().startsWith("get") || !Modifier.isPublic(method.getModifiers())) continue;
            try {
                value = method.invoke((Object)operatingSystemMXBean, new Object[0]);
            }
            catch (Exception e) {
                value = e;
            }
            if (method.getName().equals("getFreePhysicalMemorySize")) {
                freePhysicalMemorySize = new BigDecimal(value.toString()).longValue();
            }
            if (!method.getName().equals("getTotalPhysicalMemorySize")) continue;
            totalMemorySize = new BigDecimal(value.toString()).longValue();
        }
        usedMemorySize = totalMemorySize - freePhysicalMemorySize;
        systemVO.setTotalMemory(ConvertKit.byte2FitMemorySize(totalMemorySize));
        systemVO.setFreePhysicalMemory(ConvertKit.byte2FitMemorySize(freePhysicalMemorySize));
        systemVO.setUsedMemory(ConvertKit.byte2FitMemorySize(usedMemorySize));
    }
}

