/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.dal;

import com.blade.kit.GsonKit;
import com.google.common.base.Strings;
import com.zeto.ZenData;
import com.zeto.ZenEnvironment;
import com.zeto.cache.ApiCache;
import com.zeto.dal.DBHelper;
import com.zeto.driver.domain.ApiData;
import com.zeto.driver.mix.domain.MixDO;
import java.io.File;
import java.io.FileInputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiMapper {
    private static final Logger log = LoggerFactory.getLogger(ApiMapper.class);
    private static ApiMapper apiMapper = new ApiMapper();

    private ApiMapper() {
    }

    public static ApiMapper i() {
        return apiMapper;
    }

    public void init(String appName) {
        if (ZenEnvironment.isDev()) {
            return;
        }
        String filePath = ZenEnvironment.getPath() + "/config/api.json";
        File file = new File(filePath);
        if (!file.exists()) {
            return;
        }
        this.loadApi(file, appName, false);
        filePath = ZenEnvironment.getPath() + "/config/mix.json";
        file = new File(filePath);
        if (!file.exists()) {
            return;
        }
        this.loadApi(file, appName, true);
    }

    private void loadApi(File file, String appName, boolean isMix) {
        Long filelength = file.length();
        byte[] filecontent = new byte[filelength.intValue()];
        try {
            FileInputStream in = new FileInputStream(file);
            in.read(filecontent);
            in.close();
            String content = new String(filecontent, "UTF-8");
            String[] apiList = GsonKit.parse(content, String[].class);
            if (apiList == null) {
                return;
            }
            for (String api : apiList) {
                if (Strings.isNullOrEmpty((String)api)) continue;
                if (isMix) {
                    MixDO mixDO = GsonKit.parse(api, MixDO.class);
                    if (mixDO == null) continue;
                    ApiCache.set(appName, mixDO.getName(), "mix", api);
                    continue;
                }
                ApiData apiData = GsonKit.parse(api, ApiData.class);
                if (apiData == null) continue;
                ApiCache.set(appName, apiData.getName(), apiData.getType(), api);
            }
        }
        catch (Exception e) {
            log.error("load api", (Throwable)e);
        }
    }

    public MixDO getMixDoByName(String appName, String path) {
        String[] params = path.split("/");
        String content = this.getApiContent(appName, params[0], params[1]);
        if (content != null) {
            return GsonKit.parse(content, MixDO.class);
        }
        return null;
    }

    public ApiData getApiByName(String appName, String path) {
        String[] params = path.split("/");
        String content = this.getApiContent(appName, params[0], params[1]);
        if (content != null) {
            return GsonKit.parse(content, ApiData.class);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getApiContent(String appName, String type, String name) {
        String content = ApiCache.get(appName, name, type);
        if (content != null) {
            return content;
        }
        if (!ZenEnvironment.isDev()) {
            return null;
        }
        String sql = "SELECT `content` FROM api WHERE app_name=? AND name=? AND type=? LIMIT 1";
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        ResultSet resultSet = null;
        try {
            statement.setString(1, appName);
            statement.setString(2, name);
            statement.setString(3, type);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                content = resultSet.getString(1);
            }
            dbHelper.close(resultSet);
        }
        catch (SQLException e) {
            dbHelper.close(e);
        }
        finally {
            dbHelper.close(resultSet);
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZenData selectConfig(String appName) {
        ZenData data = new ZenData();
        String sql = "SELECT `key`,`content` FROM `config` WHERE app_name=?";
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        ResultSet resultSet = null;
        try {
            statement.setString(1, appName);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String key = resultSet.getString(1);
                String val = resultSet.getString(2);
                data.put(key, val);
            }
            dbHelper.close(resultSet);
        }
        catch (SQLException e) {
            try {
                dbHelper.close(e);
                dbHelper.close(resultSet);
            }
            catch (Throwable throwable) {
                dbHelper.close(resultSet);
                throw throwable;
            }
        }
        return data;
    }
}

