/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.dal;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import com.zeto.ZenEnvironment;
import com.zeto.domain.ZenApp;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBHelper {
    private static final Logger log = LoggerFactory.getLogger(DBHelper.class);
    private static HikariDataSource ds;
    private static final int pools = 2;
    private Connection connection = null;
    private PreparedStatement statement = null;

    public static void init() {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.addDataSourceProperty("cachePrepStmts", (Object)"true");
        hikariConfig.addDataSourceProperty("useUnicode", (Object)"true");
        hikariConfig.addDataSourceProperty("characterEncoding", (Object)"utf8");
        hikariConfig.addDataSourceProperty("useSSL", (Object)"false");
        hikariConfig.addDataSourceProperty("serverTimezone", (Object)"UTC");
        if (ZenEnvironment.isSqlitePrivate()) {
            File databaseFile = new File(ZenEnvironment.getPath() + "/db/data.db");
            if (!databaseFile.exists()) {
                try {
                    if (!databaseFile.createNewFile()) {
                        log.error("sqlite", (Object)"\u65e0\u76ee\u5f55\u64cd\u4f5c\u6743\u9650");
                    }
                }
                catch (IOException exception) {
                    log.error("sqlite", (Throwable)exception);
                }
            }
            hikariConfig.setPoolName("SQLiteConnectionPool");
            hikariConfig.setDriverClassName("org.sqlite.JDBC");
            hikariConfig.setJdbcUrl("jdbc:sqlite:" + databaseFile);
            hikariConfig.addDataSourceProperty("maximumPoolSize", (Object)6);
        } else {
            hikariConfig.setDriverClassName("com.mysql.cj.jdbc.Driver");
            hikariConfig.setJdbcUrl(ZenEnvironment.get("dbHost"));
            hikariConfig.setUsername(ZenEnvironment.get("dbUser"));
            hikariConfig.setPassword(ZenEnvironment.get("dbPasswd"));
            hikariConfig.setValidationTimeout(5000L);
            hikariConfig.setConnectionTestQuery("select 1");
            hikariConfig.addDataSourceProperty("failOverReadOnly", (Object)false);
            hikariConfig.addDataSourceProperty("maxReconnects", (Object)10);
            if (ZenEnvironment.isOnline()) {
                hikariConfig.addDataSourceProperty("maximumPoolSize", (Object)20);
            } else {
                hikariConfig.addDataSourceProperty("maximumPoolSize", (Object)2);
            }
        }
        ds = new HikariDataSource(hikariConfig);
    }

    public DBHelper() {
        try {
            this.connection = ds.getConnection();
        }
        catch (SQLException e) {
            this.close(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZenApp getApp(String name) {
        String sql = "select _id,name,title,domain,config,skin,version from app where name=? limit 1";
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        ResultSet resultSet = null;
        try {
            statement.setString(1, name);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                ZenApp zenApp = new ZenApp(resultSet.getString(5));
                zenApp.setId(resultSet.getString(1));
                zenApp.setName(name);
                zenApp.setTitle(resultSet.getString(3));
                zenApp.setDomain(resultSet.getString(4));
                zenApp.setSkin(resultSet.getString(6));
                zenApp.setVersion(resultSet.getString(7));
                ZenApp zenApp2 = zenApp;
                dbHelper.close(resultSet);
                return zenApp2;
            }
            dbHelper.close(resultSet);
        }
        catch (SQLException e) {
            try {
                dbHelper.close(e);
                dbHelper.close(resultSet);
            }
            catch (Throwable throwable) {
                dbHelper.close(resultSet);
                throw throwable;
            }
        }
        return null;
    }

    public static HikariDataSource getDatasource() {
        return ds;
    }

    public PreparedStatement getStatement(String sql) {
        try {
            PreparedStatement statement = this.connection.prepareStatement(sql);
            return statement;
        }
        catch (SQLException e) {
            this.close(e);
            return null;
        }
    }

    public void close(SQLException e) {
        this.close();
        log.error("", (Throwable)e);
    }

    public void close(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                log.error("", (Throwable)e);
            }
        }
        this.close();
    }

    public void close() {
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException e) {
                log.error("", (Throwable)e);
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                log.error("", (Throwable)e);
            }
        }
    }
}

