/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.dal;

import com.blade.kit.GsonKit;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.zeto.ZenEnvironment;
import com.zeto.dal.DBHelper;
import com.zeto.domain.ZenSite;
import com.zeto.kit.TagKit;
import com.zeto.kit.driver.ConfigVO;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SiteMapper {
    private Cache<String, ZenSite> cache = CacheBuilder.newBuilder().maximumSize(2000L).initialCapacity(20).expireAfterAccess(180L, TimeUnit.MINUTES).build();
    private static final SiteMapper instance = new SiteMapper();

    public static SiteMapper i() {
        return instance;
    }

    private SiteMapper() {
    }

    public void removeCache(String cacheId) {
        this.cache.invalidate((Object)cacheId);
    }

    public void removeCache(ZenSite site) {
        this.removeCache(site.getName());
        String domain = site.getDomain();
        if (!Strings.isNullOrEmpty((String)domain)) {
            this.removeCache(domain);
        }
    }

    public void set(String cacheId, ZenSite zenSite) {
        if (zenSite == null || ZenEnvironment.isDev()) {
            return;
        }
        this.cache.put((Object)cacheId, (Object)zenSite);
    }

    public void close() {
        this.cache.invalidateAll();
    }

    public ZenSite getByName(String name) {
        ZenSite result = (ZenSite)this.cache.getIfPresent((Object)name);
        if (result == null) {
            String app = ZenEnvironment.getAppName();
            String sql = "select `name`,`domain`,`app`,`skin`,`_id`,`config`,`title`,`tag` from `site` where `name`=? and `app`='" + app + "' limit 1";
            result = this.getFromDB(name, sql);
            if (result != null) {
                this.cache.put((Object)name, (Object)result);
            }
        }
        return result;
    }

    public ZenSite getByDomain(String domain) {
        String sql;
        ZenSite result = (ZenSite)this.cache.getIfPresent((Object)domain);
        if (result == null && (result = this.getFromDB(domain, sql = "select `name`,`domain`,`app`,`skin`,`_id`,`config`,`title`,`tag` from `site` where `domain`=? limit 1")) != null) {
            this.cache.put((Object)domain, (Object)result);
        }
        return result;
    }

    public ZenSite getById(String id) {
        String sql;
        ZenSite site = (ZenSite)this.cache.getIfPresent((Object)id);
        if (site == null && (site = this.getFromDB(id, sql = "select `name`,`domain`,`app`,`skin`,`_id`,`config`,`title`,`tag` from `site` where `_id`=? limit 1")) != null) {
            this.cache.put((Object)id, (Object)site);
        }
        return site;
    }

    public ZenSite getLastSite(String app, String uid, int tagPosition) {
        Long tagValue = TagKit.getPositionValue(tagPosition);
        String sql = "select `name`,`domain`,site.app,`skin`,`_id`,`config`,`title`,site.tag from `site` left JOIN user_site on site._id=user_site.site_id where user_site.uid=? and user_site.app='" + app + "' and user_site.tag&" + tagValue + "=" + tagValue + " order by user_site.visit_time desc limit 1";
        return this.getFromDB(uid, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ZenSite> selectByIds(List<String> ids) {
        if (ids.size() == 0) {
            return null;
        }
        String sql = "select `name`,`domain`,`_id`,`title`,`tag` from `site` where `_id` in ('" + String.join((CharSequence)"','", ids) + "') limit 100";
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        ResultSet resultSet = null;
        try {
            ArrayList<ZenSite> siteList = new ArrayList<ZenSite>();
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                ZenSite zenSite = new ZenSite(null);
                zenSite.setName(resultSet.getString(1));
                zenSite.setDomain(resultSet.getString(2));
                zenSite.setId(resultSet.getString(3));
                zenSite.setTitle(resultSet.getString(4));
                zenSite.setTag(resultSet.getLong(5));
                siteList.add(zenSite);
            }
            ArrayList<ZenSite> arrayList = siteList;
            dbHelper.close(resultSet);
            return arrayList;
        }
        catch (SQLException e) {
            try {
                dbHelper.close(e);
                dbHelper.close(resultSet);
            }
            catch (Throwable throwable) {
                dbHelper.close(resultSet);
                throw throwable;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTag(ZenSite site, int tag) {
        Long result = TagKit.set(site.getTag(), tag);
        String sql = "update site set `tag`=?  where _id=?";
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        try {
            statement.setLong(1, result);
            statement.setString(2, site.getId());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            dbHelper.close(e);
        }
        finally {
            dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(ZenSite site) {
        if (site == null || Strings.isNullOrEmpty((String)site.getId())) {
            return;
        }
        String sql = "update site set `domain`=? ,`skin`=?,`title`=? where _id=?";
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        try {
            statement.setString(1, site.getDomain());
            statement.setString(2, site.getSkin());
            statement.setString(3, site.getTitle());
            statement.setString(4, site.getId());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            dbHelper.close(e);
        }
        finally {
            dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String id) {
        String sql = "delete from site where _id=? limit 1";
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        try {
            statement.setString(1, id);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            dbHelper.close(e);
        }
        finally {
            dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ZenSite site) {
        if (site == null || Strings.isNullOrEmpty((String)site.getName())) {
            return;
        }
        String sql = "insert into site(`_id`, `domain`, `app`, `name`, `skin`,`title`,`config`,`tag`)values(?, ?, ?, ?, ?,?,?,?)";
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        try {
            statement.setString(1, site.getId());
            statement.setString(2, site.getDomain());
            statement.setString(3, site.getApp());
            statement.setString(4, site.getName());
            statement.setString(5, site.getSkin());
            statement.setString(6, site.getTitle());
            statement.setString(7, "");
            statement.setLong(8, site.getTag());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            dbHelper.close(e);
        }
        finally {
            dbHelper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZenSite getFromDB(String keyword, String sql) {
        DBHelper dbHelper = new DBHelper();
        PreparedStatement statement = dbHelper.getStatement(sql);
        ResultSet resultSet = null;
        try {
            statement.setString(1, keyword);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                ZenSite zenSite = this.toSite(resultSet);
                this.set(keyword, zenSite);
                ZenSite zenSite2 = zenSite;
                dbHelper.close(resultSet);
                return zenSite2;
            }
            dbHelper.close(resultSet);
        }
        catch (SQLException e) {
            try {
                dbHelper.close(e);
                dbHelper.close(resultSet);
            }
            catch (Throwable throwable) {
                dbHelper.close(resultSet);
                throw throwable;
            }
        }
        return null;
    }

    private ZenSite toSite(ResultSet resultSet) throws SQLException {
        ZenSite zenSite = new ZenSite(resultSet.getString(6));
        zenSite.setName(resultSet.getString(1));
        zenSite.setDomain(resultSet.getString(2));
        zenSite.setApp(resultSet.getString(3));
        zenSite.setSkin(resultSet.getString(4));
        zenSite.setId(resultSet.getString(5));
        zenSite.setTitle(resultSet.getString(7));
        zenSite.setTag(resultSet.getLong(8));
        String configs = resultSet.getString(6);
        if (!Strings.isNullOrEmpty((String)configs)) {
            zenSite.setConfigs(GsonKit.parseList(configs, ConfigVO.class));
        }
        return zenSite;
    }
}

