/*
 * Decompiled with CFR 0.152.
 */
package com.zeto.dal;

import com.blade.kit.EncryptKit;
import com.blade.kit.PatternKit;
import com.blade.kit.UUID;
import com.google.common.base.Strings;
import com.mongodb.BasicDBObject;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import com.zeto.Zen;
import com.zeto.ZenCache;
import com.zeto.dal.IUserMapper;
import com.zeto.domain.ZenUser;
import com.zeto.driver.ZenStorageEngine;
import com.zeto.driver.mongodb.MClient;
import com.zeto.kit.TagKit;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.bson.Document;
import org.bson.conversions.Bson;

public class UserMongodbMapper
implements IUserMapper {
    private ZenStorageEngine zenStorageEngine = Zen.getStorageEngine();
    private static final String tableName = "user";
    private static final String cacheSuffix = "_user";

    @Override
    public void insert(ZenUser userDO) {
        Document document = new Document();
        document.append("_id", (Object)userDO.getUid());
        document.append("username", (Object)userDO.getUsername());
        document.append("mobile", (Object)userDO.getMobile());
        document.append("pwd", (Object)userDO.getPwd());
        document.append("mkey", (Object)userDO.getMkey());
        document.append("ukey", (Object)userDO.getUkey());
        document.append("nick", (Object)userDO.getNick());
        document.append("union_id", (Object)userDO.getUnionId());
        document.append("email", (Object)userDO.getEmail());
        if (userDO.getTag() != null) {
            document.append("tag", (Object)userDO.getTag());
        } else {
            document.append("tag", (Object)0L);
        }
        if (document.isEmpty()) {
            return;
        }
        MongoCollection<Document> table = MClient.getCollection(tableName);
        table.insertOne((Object)document);
    }

    @Override
    public void updateEmail(String email, String uid) {
        this.updateByKey("email", email, uid);
    }

    @Override
    public void updateNick(String nick, String uid) {
        this.updateByKey("nick", nick, uid);
    }

    @Override
    public void setTag(String uid, Long tagValue) {
        this.updateByKey("unionId", tagValue, uid);
    }

    @Override
    public void updateUionId(String unionId, String uid) {
        this.updateByKey("unionId", unionId, uid);
    }

    @Override
    public ZenUser updateUkey(String uid) {
        String ukey = UUID.captchaNumber(16);
        this.updateByKey("ukey", ukey, uid);
        return this.get(uid);
    }

    private void updateByKey(String key, Object value, String uid) {
        Document params = new Document();
        params.append(key, value);
        BasicDBObject doc = new BasicDBObject();
        doc.put((Object)"$set", (Object)params);
        MongoCollection<Document> docTable = MClient.getCollection(tableName);
        docTable.updateOne(Filters.eq((String)"_id", (Object)uid), (Bson)doc);
        this.cleanCache(uid);
    }

    @Override
    public void changePassword(String uid, String pwd) {
        this.updateByKey("pwd", pwd, uid);
        this.updateUkey(uid);
    }

    @Override
    public void cleanCache(String uid) {
        String cacheKey = uid + cacheSuffix;
        ZenCache.remove(cacheKey);
    }

    @Override
    public void delete(String uid) {
        MongoCollection<Document> docTable = MClient.getCollection(tableName);
        docTable.deleteOne(Filters.eq((String)"_id", (Object)uid));
        this.cleanCache(uid);
    }

    @Override
    public boolean exist(String uid) {
        MongoCollection<Document> docTable = MClient.getCollection(tableName);
        long count = docTable.countDocuments(Filters.eq((String)"_id", (Object)uid));
        return count > 0L;
    }

    @Override
    public boolean existByUnionId(String unionId, int tagValue) {
        MongoCollection<Document> docTable = MClient.getCollection(tableName);
        long count = docTable.countDocuments(Filters.eq((String)"unionId", (Object)unionId));
        return count > 0L;
    }

    @Override
    public ZenUser getByUnionId(String unionId, int tagValue) {
        return this.getByWithTag(unionId, "unionId", tagValue);
    }

    private ZenUser getByWithTag(String relateId, String clm, int tagValue) {
        ZenUser zenUser = null;
        MongoCollection<Document> documentMongoCollection = MClient.getCollection(tableName);
        Bson condition = Filters.eq((String)clm, (Object)relateId);
        FindIterable findIterable = documentMongoCollection.find(condition).limit(1);
        MongoCursor mongoCursor = findIterable.iterator();
        while (mongoCursor.hasNext()) {
            Document document = (Document)mongoCursor.next();
            Long tag = document.getLong((Object)"tag");
            if (TagKit.contain(tag, tagValue)) {
                mongoCursor.close();
            }
            zenUser = this.getUserByDocument(document);
        }
        mongoCursor.close();
        return zenUser;
    }

    @Override
    public List<ZenUser> search(String keyword, int size) {
        if (Strings.isNullOrEmpty((String)keyword)) {
            return this.select(0, size);
        }
        Pattern pattern = Pattern.compile("^.*" + keyword + ".*$", 2);
        MongoCollection<Document> documentMongoCollection = MClient.getCollection(tableName);
        FindIterable findIterable = documentMongoCollection.find(Filters.regex((String)"nick", (Pattern)pattern)).limit(size);
        MongoCursor mongoCursor = findIterable.iterator();
        ArrayList<ZenUser> users = new ArrayList<ZenUser>();
        while (mongoCursor.hasNext()) {
            Document doc = (Document)mongoCursor.next();
            ZenUser user = new ZenUser();
            user.setUid(doc.getString((Object)"_id"));
            user.setNick(doc.getString((Object)"nick"));
            user.setUnionId(doc.getString((Object)"union_id"));
            user.setTag(doc.getLong((Object)"Tag"));
            users.add(user);
        }
        mongoCursor.close();
        return users;
    }

    @Override
    public List<ZenUser> select(int start, int size) {
        MongoCollection<Document> documentMongoCollection = MClient.getCollection(tableName);
        FindIterable findIterable = documentMongoCollection.find().skip(start *= size).limit(size);
        MongoCursor mongoCursor = findIterable.iterator();
        return this.select((MongoCursor<Document>)mongoCursor);
    }

    @Override
    public long count() {
        MongoCollection<Document> docTable = MClient.getCollection(tableName);
        return docTable.countDocuments();
    }

    @Override
    public ZenUser get(String uid) {
        String cacheKey = uid + cacheSuffix;
        ZenUser zenUser = ZenCache.get(cacheKey, ZenUser.class);
        if (zenUser != null) {
            return zenUser;
        }
        return this.get("_id", uid);
    }

    @Override
    public ZenUser getByName(String username) {
        if (Strings.isNullOrEmpty((String)username)) {
            return null;
        }
        return this.get("username", username);
    }

    @Override
    public ZenUser getByMobile(String phone, int tagValue) {
        if (!PatternKit.isPhone(phone)) {
            return null;
        }
        return this.getByWithTag(phone, "mobile", tagValue);
    }

    private ZenUser get(String key, String val) {
        Bson condition;
        MongoCollection<Document> documentMongoCollection = MClient.getCollection(tableName);
        FindIterable findIterable = documentMongoCollection.find(condition = Filters.eq((String)key, (Object)val)).limit(1);
        MongoCursor mongoCursor = findIterable.iterator();
        if (mongoCursor.hasNext()) {
            Document document = (Document)mongoCursor.next();
            mongoCursor.close();
            return this.getUserByDocument(document);
        }
        return null;
    }

    private List<ZenUser> select(MongoCursor<Document> mongoCursor) {
        ArrayList<ZenUser> users = new ArrayList<ZenUser>();
        while (mongoCursor.hasNext()) {
            Document doc = (Document)mongoCursor.next();
            ZenUser user = this.getUserByDocument(doc);
            users.add(user);
        }
        mongoCursor.close();
        return users;
    }

    private ZenUser getUserByDocument(Document doc) {
        ZenUser user = new ZenUser();
        user.setUid(doc.getString((Object)"_id"));
        user.setNick(doc.getString((Object)"nick"));
        user.setUnionId(doc.getString((Object)"union_id"));
        user.setTag(doc.getLong((Object)"tag"));
        user.setUsername(doc.getString((Object)"username"));
        user.setMobile(doc.getString((Object)"mobile"));
        user.setPwd(doc.getString((Object)"pwd"));
        user.setEmail(doc.getString((Object)"email"));
        String cacheKey = user.getUid() + cacheSuffix;
        String ukey = EncryptKit.md5(doc.getString((Object)"ukey"));
        user.setUkey(ukey);
        ZenCache.set(cacheKey, user);
        return user;
    }
}

